/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.panels.assertion;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.AssertImageData;
import org.eclipse.rcptt.tesla.core.protocol.AssertKind;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.ecl.model.Recognize;
import org.eclipse.rcptt.tesla.ecl.model.RecognizeResponse;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.ui.panels.assertion.AssertionPanelWindow;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AssertImageWindow
extends Dialog {
    private static final int TYPE_CONTAIN_IMAGE = 0;
    private static final int TYPE_IMAGE_TEXT_CONTAINS = 1;
    private AssertionPanelWindow assertPanelWindow;
    private byte[] image;
    private Image img;
    private Point firstAncor = new Point(0, 0);
    private Point secondAncor = new Point(100, 100);
    protected boolean inDrag;
    private Label selectedImage;
    private Text text;
    private Combo assertKind;
    private Assert result;
    private Rectangle imgBounds;

    public AssertImageWindow(Shell parentShell, AssertionPanelWindow window) {
        super(parentShell);
        this.assertPanelWindow = window;
        this.setShellStyle(84080);
    }

    protected Control createDialogArea(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 10).numColumns(2).applyTo(content);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)content);
        this.img = new Image((Device)parent.getDisplay(), (InputStream)new ByteArrayInputStream(this.image));
        new Label(content, 0).setText(Messages.AssertImageWindow_TypeLabel);
        this.assertKind = new Combo(content, 2056);
        this.assertKind.setItems(new String[]{Messages.AssertImageWindow_AssertKind_ContainsImage, Messages.AssertImageWindow_AssertKind_ContainsText});
        this.assertKind.select(0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.assertKind);
        Label textLabel = new Label(content, 0);
        textLabel.setText(Messages.AssertImageWindow_TextLabel);
        this.text = new Text(content, 2050);
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 60).span(1, 1).applyTo((Control)this.text);
        this.text.setEnabled(false);
        this.assertKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AssertImageWindow.this.assertKind.getSelectionIndex();
                if (index == 0) {
                    AssertImageWindow.this.text.setEnabled(false);
                } else if (index == 1) {
                    AssertImageWindow.this.text.setEnabled(true);
                }
            }
        });
        new Label(content, 0).setText(Messages.AssertImageWindow_SelectionLabel);
        this.selectedImage = new Label(content, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.selectedImage);
        new Label(content, 0).setText(Messages.AssertImageWindow_ImageLabel);
        ScrolledComposite sc = new ScrolledComposite(content, 2816);
        GridDataFactory.fillDefaults().span(1, 2).grab(true, true).hint(600, 300).applyTo((Control)sc);
        final Canvas imageCanvas = new Canvas((Composite)sc, 2048);
        this.imgBounds = this.img.getBounds();
        this.firstAncor = new Point(0, 0);
        this.secondAncor = new Point(this.imgBounds.width - 1, this.imgBounds.height - 1);
        this.updateImageInfo();
        imageCanvas.setBounds(0, 0, this.imgBounds.width + 2, this.imgBounds.height + 2);
        sc.setMinSize(this.imgBounds.width + 1, this.imgBounds.height + 1);
        sc.setContent((Control)imageCanvas);
        Color color = imageCanvas.getDisplay().getSystemColor(1);
        sc.setBackground(new Color(color.getDevice(), color.getRGB()));
        final Color blueColor = new Color(color.getDevice(), imageCanvas.getDisplay().getSystemColor(9).getRGB());
        imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (AssertImageWindow.this.img != null) {
                    e.gc.drawImage(AssertImageWindow.this.img, 0, 0);
                    e.gc.setForeground(blueColor);
                    Rectangle selection = AssertImageWindow.this.getSelection();
                    e.gc.drawRectangle(selection);
                }
            }
        });
        imageCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AssertImageWindow.this.firstAncor = AssertImageWindow.this.updatePoint(new Point(e.x, e.y));
                AssertImageWindow.this.inDrag = true;
            }

            public void mouseUp(MouseEvent e) {
                AssertImageWindow.this.secondAncor = AssertImageWindow.this.updatePoint(new Point(e.x, e.y));
                AssertImageWindow.this.inDrag = false;
                AssertImageWindow.this.updateRecognizeText(AssertImageWindow.this.assertKind);
            }
        });
        imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (AssertImageWindow.this.inDrag) {
                    AssertImageWindow.this.secondAncor = AssertImageWindow.this.updatePoint(new Point(e.x, e.y));
                    imageCanvas.redraw();
                    AssertImageWindow.this.updateImageInfo();
                }
            }
        });
        return content;
    }

    protected Point updatePoint(Point point) {
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        Rectangle bounds = this.img.getBounds();
        if (point.x > bounds.width) {
            point.x = bounds.width - 1;
        }
        if (point.y > bounds.height) {
            point.y = bounds.height - 1;
        }
        return point;
    }

    private void updateImageInfo() {
        Rectangle rect = this.getSelection();
        this.selectedImage.setText(this.getInfoText(rect));
    }

    private String getInfoText(Rectangle rect) {
        return "(" + rect.x + ", " + rect.y + ", " + rect.width + ", " + rect.height + ")";
    }

    private Rectangle getSelection() {
        return new Rectangle(Math.min(this.firstAncor.x, this.secondAncor.x), Math.min(this.firstAncor.y, this.secondAncor.y), Math.abs(this.firstAncor.x - this.secondAncor.x), Math.abs(this.firstAncor.y - this.secondAncor.y));
    }

    public boolean close() {
        if (this.img != null) {
            this.img.dispose();
        }
        return super.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AssertImageWindow_Tilte);
    }

    public void setInput(byte[] imageCapture) {
        this.image = imageCapture;
    }

    protected void okPressed() {
        this.result = ProtocolFactory.eINSTANCE.createAssert();
        AssertImageData data = ProtocolFactory.eINSTANCE.createAssertImageData();
        Rectangle selection = this.getSelection();
        data.setX(selection.x);
        data.setY(selection.y);
        data.setWidth(this.imgBounds.width);
        data.setHeight(this.imgBounds.height);
        this.result.setImageData(data);
        int index = this.assertKind.getSelectionIndex();
        switch (index) {
            case 0: {
                GC gc = new GC((Drawable)this.img);
                Image copyImg = new Image(this.img.getDevice(), selection.width, selection.height);
                gc.copyArea(copyImg, selection.x, selection.y);
                gc.dispose();
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{copyImg.getImageData()};
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                loader.save((OutputStream)stream, 5);
                data.setImage(stream.toByteArray());
                copyImg.dispose();
                this.result.setAttribute("Contain image");
                this.result.setKind(AssertKind.CONTAINS_IMAGE);
                break;
            }
            case 1: {
                this.result.setAttribute("Contain text");
                this.result.setKind(AssertKind.IMAGE_CONTAINS_TEXT);
                String resultText = AssertImageWindow.replaceMultilines(this.text.getText());
                this.result.setValue(resultText);
                data.setSx(selection.width);
                data.setSy(selection.height);
            }
        }
        super.okPressed();
    }

    private void updateRecognizeText(Combo assertKind) {
        if (assertKind.getSelectionIndex() == 1) {
            AutLaunch launch = this.assertPanelWindow.getAut();
            Recognize recognize = TeslaFactory.eINSTANCE.createRecognize();
            Rectangle selection = this.getSelection();
            recognize.setX(selection.x);
            recognize.setY(selection.y);
            recognize.setWidth(selection.width);
            recognize.setHeight(selection.height);
            recognize.setImage(this.image);
            try {
                RecognizeResponse resp;
                Object object = launch.execute((Command)recognize);
                if (object instanceof RecognizeResponse && (resp = (RecognizeResponse)object) != null) {
                    if (resp.getText() != null) {
                        this.text.setText(resp.getText());
                    } else {
                        this.text.setText("");
                    }
                }
            }
            catch (Throwable e) {
                Q7UIPlugin.log(e);
            }
        }
    }

    public static String replaceMultilines(String result) {
        if (result == null) {
            return null;
        }
        String finalResult = Platform.getOS().equals("win32") ? result.replaceAll("\r", "").trim() : (Platform.getOS().equals("macosx") ? result.replaceAll("\r", "\n").trim() : result);
        return finalResult;
    }

    public Assert getAssert() {
        return this.result;
    }
}

