/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.ext.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaArgumentsTab;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.internal.launching.ext.UpdateVMArgs;
import org.eclipse.rcptt.internal.launching.ext.ui.IAUTListener;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AUTArgumentsTab
extends JavaArgumentsTab
implements IAUTListener {
    Text vmArguments;
    Button secureStorage;

    protected VMArgumentsBlock createVMArgsBlock() {
        return new VMArgumentsBlock(){

            public void createControl(Composite parent) {
                AUTArgumentsTab.this.createSecureStorageBlock(parent);
                super.createControl(parent);
                AUTArgumentsTab.this.vmArguments = this.fVMArgumentsText;
            }

            public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
                super.setDefaults(configuration);
                configuration.removeAttribute("override-secure-storage");
            }

            public void initializeFrom(ILaunchConfiguration configuration) {
                super.initializeFrom(configuration);
                try {
                    String value = configuration.getAttribute("override-secure-storage", null);
                    AUTArgumentsTab.this.secureStorage.setSelection(value == null);
                }
                catch (CoreException coreException) {}
            }

            public void performApply(ILaunchConfigurationWorkingCopy configuration) {
                if (AUTArgumentsTab.this.secureStorage.getSelection()) {
                    configuration.removeAttribute("override-secure-storage");
                } else {
                    configuration.setAttribute("override-secure-storage", "false");
                }
                super.performApply(configuration);
            }
        };
    }

    @Override
    public void update(ITargetPlatformHelper info) {
        String attr;
        String vmArgs = info.getIniVMArgs();
        if (vmArgs != null && vmArgs.trim().length() > 0 && (attr = UpdateVMArgs.updateAttr((String)vmArgs)) != null) {
            this.vmArguments.setText(attr);
        }
    }

    private void createSecureStorageBlock(Composite parent) {
        Group securityBlock = new Group(parent, 0);
        securityBlock.setText("Secure Storage:");
        GridLayoutFactory.swtDefaults().applyTo((Composite)securityBlock);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)securityBlock);
        this.secureStorage = new Button((Composite)securityBlock, 32);
        this.secureStorage.setText("Override '-eclipse.keyring' with 'launch shortcut folder/secure_storage'.");
        new Label((Composite)securityBlock, 0).setText("Please be aware. If unset, global secure storage could be cleared by Preferences context apply.");
        this.secureStorage.setToolTipText("Use launch shortcut folder for secure storage");
        this.secureStorage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AUTArgumentsTab.this.setDirty(true);
                AUTArgumentsTab.this.scheduleUpdateJob();
            }
        });
    }
}

