/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.search;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.workspace.IWorkspaceFinder;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceFinder;
import org.eclipse.rcptt.internal.core.model.Q7InternalContext;
import org.eclipse.rcptt.internal.core.model.Q7InternalVerification;
import org.eclipse.rcptt.parameters.Parameter;
import org.eclipse.rcptt.parameters.ParametersContext;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;

public class Q7SearchVisitor {
    private static final String SEARCH_CONTEXT_REFERENCES_TASK = "Searching references to context \"{0}\"";
    private static final String SEARCH_VERIFICATION_REFERENCES_TASK = "Searching references to verification \"{0}\"";
    private static final String SEARCH_TESTCASE_REFERENCES_TASK = "Searching references to \"{0}\"";
    private static final int N_THREADS = 8;
    private final TextSearchRequestor fCollector;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private final MultiStatus fStatus;
    private final FileCharSequenceProvider fFileCharSequenceProvider;
    private final ReusableMatchAccess fMatchAccess;
    private int fSearchFor;
    private String fQ7ElementName;
    private Pattern searchPattern;

    public Q7SearchVisitor(TextSearchRequestor collector, Pattern searchPattern, int searchFor, String q7ElementName) {
        this(collector, searchPattern);
        this.fSearchFor = searchFor;
        this.fQ7ElementName = q7ElementName;
    }

    public Q7SearchVisitor(TextSearchRequestor collector, Pattern searchPattern) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.searchPattern = searchPattern;
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
        this.fMatchAccess = new ReusableMatchAccess();
        this.fSearchFor = 0;
    }

    private Matcher getMatcher() {
        return this.searchPattern.pattern().length() == 0 ? null : this.searchPattern.matcher(new String());
    }

    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                this.fLastNumberOfScannedFiles = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = null;
                    Q7SearchVisitor q7SearchVisitor = Q7SearchVisitor.this;
                    synchronized (q7SearchVisitor) {
                        file = Q7SearchVisitor.this.fCurrentFile;
                    }
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, new Integer(Q7SearchVisitor.this.fNumberOfScannedFiles), new Integer(Q7SearchVisitor.this.fNumberOfFilesToScan)};
                        Q7SearchVisitor.this.fProgressMonitor.subTask(Messages.format((String)SearchMessages.TextSearchVisitor_scanning, (Object[])args));
                        int steps = Q7SearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        Q7SearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            MultiStatus multiStatus;
            String taskName;
            String string = taskName = this.getMatcher() == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : Messages.format((String)SearchMessages.TextSearchVisitor_textsearch_task_label, (Object)this.getMatcher().pattern().pattern());
            if (this.fSearchFor == 5) {
                taskName = Messages.format((String)SEARCH_CONTEXT_REFERENCES_TASK, (Object)this.fQ7ElementName);
            } else if (this.fSearchFor == 7) {
                taskName = Messages.format((String)SEARCH_CONTEXT_REFERENCES_TASK, (Object)this.fQ7ElementName);
            } else if (this.fSearchFor == 6) {
                taskName = Messages.format((String)SEARCH_TESTCASE_REFERENCES_TASK, (Object)this.fQ7ElementName);
            }
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processFiles(files, monitor);
                multiStatus = this.fStatus;
            }
            catch (Throwable throwable) {
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            return multiStatus;
        }
        finally {
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFiles(IFile[] files, IProgressMonitor monitor) {
        int i = 0;
        while (i < files.length) {
            IFile curFile = files[i];
            if (monitor.isCanceled()) {
                return;
            }
            Q7SearchVisitor q7SearchVisitor = this;
            synchronized (q7SearchVisitor) {
                this.fCurrentFile = curFile;
            }
            this.processFile(curFile);
            ++i;
        }
    }

    private String getScenarioContexts(ITestCase scenario) throws ModelException {
        String contextList = null;
        IContext[] contexts = RcpttCore.getInstance().getContexts(scenario, (IWorkspaceFinder)WorkspaceFinder.getInstance(), true);
        String[] contextsRef = Q7SearchCore.findContextsByDocument((IQ7Element)scenario);
        if (contextsRef == null) {
            contextsRef = scenario.getContexts();
        }
        List<String> ctx = Arrays.asList(contextsRef);
        IContext[] iContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IContext contextId = iContextArray[n2];
            if (!(contextId instanceof Q7InternalContext) && contextId != null && ctx.contains(contextId.getID())) {
                contextList = contextList == null ? contextId.getElementName() : String.valueOf(contextList) + ", " + contextId.getElementName();
            }
            ++n2;
        }
        return contextList;
    }

    private String getScenarioVerifications(ITestCase scenario) throws ModelException {
        String verificationList = null;
        IVerification[] verifications = RcpttCore.getInstance().getVerifications(scenario, (IWorkspaceFinder)WorkspaceFinder.getInstance(), true);
        String[] verificationRefs = Q7SearchCore.findVerificationsByDocument((IQ7Element)scenario);
        if (verificationRefs == null) {
            verificationRefs = scenario.getVerifications();
        }
        List<String> verificationIds = Arrays.asList(verificationRefs);
        IVerification[] iVerificationArray = verifications;
        int n = verifications.length;
        int n2 = 0;
        while (n2 < n) {
            IVerification v = iVerificationArray[n2];
            if (!(v instanceof Q7InternalVerification) && v != null && verificationIds.contains(v.getID())) {
                verificationList = verificationList == null ? v.getElementName() : String.valueOf(verificationList) + ", " + v.getElementName();
            }
            ++n2;
        }
        return verificationList;
    }

    private String getContextParameters(IContext context) throws CoreException {
        StringBuilder parametersList = new StringBuilder();
        NamedElement element = context.getNamedElement();
        if (element instanceof ParametersContext) {
            EList pars = ((ParametersContext)element).getParameters();
            for (Parameter par : pars) {
                parametersList.append(par.getName()).append(" = ").append(par.getValue()).append('\n');
            }
        }
        return parametersList.toString();
    }

    private String getScenarioContextsIds(IQ7NamedElement scenario) throws ModelException {
        IContext[] contexts;
        String ContextList = "";
        IContext[] iContextArray = contexts = RcpttCore.getInstance().getContexts(scenario, (IWorkspaceFinder)WorkspaceFinder.getInstance(), true);
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IContext contextId = iContextArray[n2];
            if (contextId != null && !(contextId instanceof Q7InternalContext)) {
                ContextList = String.valueOf(ContextList) + contextId.getID() + " ";
            }
            ++n2;
        }
        return ContextList;
    }

    private String getScenarioVerificationIds(IQ7NamedElement scenario) throws ModelException {
        String verificationsList = "";
        if (scenario instanceof ITestCase) {
            IVerification[] verifications;
            IVerification[] iVerificationArray = verifications = RcpttCore.getInstance().getVerifications((ITestCase)scenario, (IWorkspaceFinder)WorkspaceFinder.getInstance(), true);
            int n = verifications.length;
            int n2 = 0;
            while (n2 < n) {
                IVerification v = iVerificationArray[n2];
                if (v != null && !(v instanceof Q7InternalVerification)) {
                    verificationsList = String.valueOf(verificationsList) + v.getID() + " ";
                }
                ++n2;
            }
        }
        return verificationsList;
    }

    private String getTestSuiteIds(ITestSuite testSuite) throws ModelException {
        IQ7NamedElement[] elements;
        String elementsList = "";
        IQ7NamedElement[] iQ7NamedElementArray = elements = Q7SearchCore.getTestSuiteContent((ITestSuite)testSuite);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IQ7NamedElement element = iQ7NamedElementArray[n2];
            if (element != null) {
                elementsList = String.valueOf(elementsList) + element.getID() + " ";
            }
            ++n2;
        }
        return elementsList;
    }

    /*
     * Exception decompiling
     */
    public boolean processFile(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void locateMatches(IFile file, CharSequence searchInput) throws CoreException {
        try {
            Matcher matcher = this.getMatcher();
            matcher.reset(searchInput);
            int k = 0;
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                if (end != start) {
                    this.fMatchAccess.initialize(file, start, end - start, searchInput);
                    boolean res = this.fCollector.acceptPatternMatch((TextSearchMatchAccess)this.fMatchAccess);
                    if (!res) {
                        return;
                    }
                }
                if (k++ != 20) continue;
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                }
                k = 0;
            }
        }
        finally {
            this.fMatchAccess.initialize(null, 0, 0, new String());
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    private boolean isFileEmpty(IFile file) throws IOException, CoreException {
        boolean isEmpty = false;
        BufferedInputStream stream = new BufferedInputStream(file.getContents());
        try {
            int firstByte = ((InputStream)stream).read();
            isEmpty = firstByte == -1;
        }
        finally {
            ((InputStream)stream).close();
        }
        return isEmpty;
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }
}

