/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.workbench.ui.views;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rcptt.core.ecl.core.model.GetViews;
import org.eclipse.rcptt.core.ecl.core.model.Q7CoreFactory;
import org.eclipse.rcptt.core.ecl.core.model.ViewInfo;
import org.eclipse.rcptt.core.ecl.core.model.ViewList;
import org.eclipse.rcptt.ctx.workbench.ui.views.ViewsLabelProvider;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.ui.commons.SearchControl;
import org.eclipse.rcptt.ui.launching.LaunchUtils;
import org.eclipse.rcptt.ui.utils.TreeViewerWildcardFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class SelectViewDialog
extends Dialog {
    private final DataBindingContext dbc = new DataBindingContext();
    private final WritableValue<ViewInfo> selectedView = new WritableValue(null, ViewInfo.class);
    private ViewList viewList;
    private TreeViewer viewer;
    private SearchControl searchControl;

    public SelectViewDialog(Shell parentShell) throws CoreException {
        super(parentShell);
        this.viewList = this.getViews(parentShell);
        if (this.viewList == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select View");
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    public String getView() {
        return ((ViewInfo)this.selectedView.getValue()).getId();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        return control;
    }

    private ViewList getViews(Shell shell) throws CoreException {
        AutLaunch aut = LaunchUtils.selectAutLaunch((Shell)shell);
        if (aut == null) {
            return null;
        }
        GetViews getPerspectives = Q7CoreFactory.eINSTANCE.createGetViews();
        try {
            Object object = aut.execute((Command)getPerspectives);
            if (!(object instanceof ViewList)) {
                throw new CoreException(Q7UIPlugin.createStatus((String)("Unexpected object: " + object + ". Context is expected")));
            }
            return (ViewList)object;
        }
        catch (InterruptedException e) {
            throw new CoreException(Q7UIPlugin.createStatus((String)"Command execution was interrupted", (Throwable)e));
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 2;
        Label descriptionLabel = new Label(composite, 16384);
        descriptionLabel.setText("Please select view from the list below");
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        descriptionLabel.setLayoutData((Object)data);
        this.searchControl = new SearchControl(composite);
        this.searchControl.setLayoutData((Object)new GridData(768));
        this.searchControl.getFilterControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectViewDialog.this.viewer.expandAll();
                SelectViewDialog.this.viewer.refresh();
            }
        });
        this.createWorkspaces(composite);
        SelectViewDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control retVal = super.createButtonBar(parent);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.getButton(0)), this.selectedView, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), UpdateValueStrategy.create((IConverter)IConverter.create(fromObject -> {
            ViewInfo s = fromObject;
            if (s != null) {
                return true;
            }
            return false;
        })));
        return retVal;
    }

    private void createWorkspaces(Composite parent) {
        Tree tree = new Tree(parent, 2048);
        this.viewer = new TreeViewer(tree);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewsLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.viewer.setFilters(new ViewerFilter[]{new TreeViewerWildcardFilter(this.viewer){

            protected boolean isIgnoredElement(Object parentElement, Object element) {
                return ((ViewInfo)element).getItems().size() > 0;
            }

            protected String getFilterText() {
                String value = SelectViewDialog.this.searchControl.getFilterString();
                if (!SelectViewDialog.this.searchControl.getInitialText().equals(value)) {
                    return value;
                }
                return "";
            }

            protected String getElementText(Object parentElement, Object element) {
                return ((ViewInfo)element).getLabel();
            }
        }});
        this.viewer.setComparator((ViewerComparator)new ViewComparator());
        this.viewer.setInput((Object)this.viewList);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object element = sel.getFirstElement();
                if (element instanceof ViewInfo && ((ViewInfo)element).getItems().isEmpty()) {
                    SelectViewDialog.this.selectedView.setValue((Object)((ViewInfo)element));
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectViewDialog.this.buttonPressed(0);
            }
        });
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        tree.setLayoutData((Object)data);
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof ViewList) {
                return ((ViewList)element).getItems().toArray();
            }
            if (element instanceof ViewInfo) {
                return ((ViewInfo)element).getItems().toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ViewList) {
                return !((ViewList)element).getItems().isEmpty();
            }
            if (element instanceof ViewInfo) {
                return !((ViewInfo)element).getItems().isEmpty();
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    public class ViewComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof ViewInfo && ((ViewInfo)e1).getItems().isEmpty()) {
                String str1 = LegacyActionTools.removeMnemonics((String)((ViewInfo)e1).getLabel());
                String str2 = LegacyActionTools.removeMnemonics((String)((ViewInfo)e2).getLabel());
                return this.getComparator().compare(str1, str2);
            }
            if (e1 instanceof ViewInfo) {
                String str1 = LegacyActionTools.removeMnemonics((String)((ViewInfo)e1).getLabel());
                String str2 = LegacyActionTools.removeMnemonics((String)((ViewInfo)e2).getLabel());
                if ("General".equals(str1)) {
                    return -1;
                }
                if ("General".equals(str2)) {
                    return 1;
                }
                if ("Other".equals(str1)) {
                    return 1;
                }
                if ("Other".equals(str2)) {
                    return -1;
                }
                return this.getComparator().compare(str1, str2);
            }
            return 0;
        }
    }
}

