/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.internal.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.ecl.core.Command;
import org.eclipse.rcptt.ecl.core.IListenSource;
import org.eclipse.rcptt.ecl.core.Listen;
import org.eclipse.rcptt.ecl.runtime.ICommandService;
import org.eclipse.rcptt.ecl.runtime.IProcess;

public class ListenService
implements ICommandService {
    private static Map<String, IListenSource> sources = null;

    @Override
    public IStatus service(Command command, IProcess context) throws InterruptedException, CoreException {
        Listen watch = (Listen)command;
        if (watch.getSource() == null || watch.getSource().length() == 0) {
            return ListenService.error("Listen source name attribute is not provided.");
        }
        IListenSource source = ListenService.getSource(watch.getSource());
        if (source == null) {
            return ListenService.error("Listen source attribute is not found.");
        }
        if (watch.getWhile() == null) {
            return ListenService.error("Listen while attribute is not found.");
        }
        Object snapshot = source.begin();
        IStatus waitFor = context.getSession().execute(watch.getWhile()).waitFor();
        try {
            if (!waitFor.isOK()) {
                IStatus iStatus = waitFor;
                return iStatus;
            }
            List<Object> result = source.finish(snapshot);
            source = null;
            for (Object o : result) {
                context.getOutput().write(o);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            if (source != null) {
                source.finish(snapshot);
            }
        }
    }

    private static Map<String, IListenSource> getSources() throws CoreException {
        if (sources == null) {
            sources = new HashMap<String, IListenSource>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.rcptt.ecl.core.listenSource");
            if (point != null) {
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension e = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = e.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement c = iConfigurationElementArray[n4];
                        sources.put(c.getAttribute("name"), (IListenSource)c.createExecutableExtension("class"));
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return sources;
    }

    private static IListenSource getSource(String name) throws CoreException {
        return ListenService.getSources().get(name);
    }

    private static Status error(String message) {
        return new Status(4, "org.eclipse.rcptt.ecl.core", message);
    }
}

