/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.tesla.core.protocol.TeslaStream;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.internal.core.network.DataSerializer;

public class TeslaNetworkStream
extends TeslaStream {
    private DataInputStream din;
    private DataOutputStream dout;
    private Socket socket;

    public TeslaNetworkStream(Socket socket) throws IOException {
        this.din = new DataInputStream(socket.getInputStream());
        this.dout = new DataOutputStream(socket.getOutputStream());
        this.socket = socket;
    }

    @Override
    public Command readCommand() {
        try {
            EObject object = DataSerializer.readEObject(this.din);
            if (object instanceof Command) {
                return (Command)object;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Response readResponse() throws IOException {
        EObject object = DataSerializer.readEObject(this.din);
        if (object instanceof Response) {
            return (Response)object;
        }
        return null;
    }

    @Override
    public void terminate() {
        try {
            this.din.close();
            this.dout.close();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeCommand(Command command) {
        try {
            DataSerializer.writeEObject(this.dout, command);
        }
        catch (IOException iOException) {}
    }

    @Override
    public void writeResponse(Response command) {
        try {
            DataSerializer.writeEObject(this.dout, command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean hasCommand() {
        try {
            return this.din.available() > 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Socket getSocket() {
        return this.socket;
    }
}

