/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.cheatsheets.CheatSheetHistory;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CheatSheetPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.help.base";
    static CheatSheetPlugin plugin;
    private CheatSheetHistory history = null;
    private static final String HISTORY_FILENAME = "history.xml";
    private static final String MEMENTO_TAG_CHEATSHEET = "cheatsheet";
    private static final String MEMENTO_TAG_VERSION = "version";
    private static final String[] VERSION_STRING;
    private static final String MEMENTO_TAG_CHEATSHEET_HISTORY = "cheatsheetHistory";
    public static final IPath ICONS_PATH;
    public static final String T_OBJ = "obj16/";
    public static final String T_ELCL = "elcl16/";
    public static final String T_VIEW = "view16/";

    static {
        VERSION_STRING = new String[]{"0.0", "3.0.0"};
        ICONS_PATH = IPath.fromOSString((String)"$nl$/icons/");
    }

    public static CheatSheetPlugin getPlugin() {
        return plugin;
    }

    public Image getImage(String key) {
        Image image = this.getImageRegistry().get(key);
        return image;
    }

    public CheatSheetHistory getCheatSheetHistory() {
        if (this.history == null) {
            this.history = new CheatSheetHistory(CheatSheetRegistryReader.getInstance());
            this.restoreCheatSheetHistory();
        }
        return this.history;
    }

    private File getCheatSheetStateFile(String filename) {
        IPath path = CheatSheetPlugin.getPlugin().getStateLocation();
        path = path.append(filename);
        return path.toFile();
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        CheatSheetPlugin.getPlugin().getLog().error(message, ex);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        IPath path = ICONS_PATH.append(T_OBJ).append("cheatsheet_obj.svg");
        ImageDescriptor imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_OBJ", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("skip_status.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("complete_status.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_COMPLETE", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("linkto_help.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_HELP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_cheatsheet.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_cheatsheet.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_RESTART", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("skip_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("complete_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_COMPLETE", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_ITEM_BUTTON_RESTART", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("return_to_start.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_RETURN", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("error.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("ERROR", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("composite_obj.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_OBJ", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("information.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("INFORMATION", imageDescriptor);
        path = ICONS_PATH.append(T_OBJ).append("warning.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("WARNING", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("start_ccs_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_TASK_START", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("skip_ccs_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_TASK_SKIP", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("review_ccs_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_TASK_REVIEW", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("goto_ccs_task.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_GOTO_TASK", imageDescriptor);
        path = ICONS_PATH.append(T_ELCL).append("restart_all.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("COMPOSITE_RESTART_ALL", imageDescriptor);
        path = ICONS_PATH.append(T_VIEW).append("cheatsheet_view.svg");
        imageDescriptor = CheatSheetPlugin.createImageDescriptor(CheatSheetPlugin.getPlugin().getBundle(), path);
        reg.put("CHEATSHEET_VIEW", imageDescriptor);
    }

    private void restoreCheatSheetHistory() {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                IMemento childMem;
                XMLMemento memento = CheatSheetPlugin.this.readMemento(CheatSheetPlugin.HISTORY_FILENAME);
                if (memento != null && (childMem = memento.getChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY)) != null) {
                    CheatSheetPlugin.this.history.restoreState(childMem);
                }
            }

            public void handleException(Throwable e) {
                String message = Messages.ERROR_READING_STATE_FILE;
                CheatSheetPlugin.getPlugin().getLog().error(message, e);
            }
        });
    }

    public XMLMemento readMemento(String filename) {
        XMLMemento memento;
        File stateFile = this.getCheatSheetStateFile(filename);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(stateFile), StandardCharsets.UTF_8);){
                memento = XMLMemento.createReadRoot((Reader)reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            memento = null;
        }
        catch (Exception e) {
            String message = Messages.ERROR_READING_STATE_FILE;
            CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
            memento = null;
        }
        return memento;
    }

    private void saveCheatSheetHistory() {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                XMLMemento memento = XMLMemento.createWriteRoot((String)CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET);
                memento.putString(CheatSheetPlugin.MEMENTO_TAG_VERSION, VERSION_STRING[1]);
                CheatSheetPlugin.this.getCheatSheetHistory().saveState(memento.createChild(CheatSheetPlugin.MEMENTO_TAG_CHEATSHEET_HISTORY));
                IStatus status = CheatSheetPlugin.this.saveMemento(memento, CheatSheetPlugin.HISTORY_FILENAME);
                if (!status.isOK()) {
                    CheatSheetPlugin.getPlugin().getLog().log(status);
                }
            }

            public void handleException(Throwable e) {
                String message = Messages.ERROR_WRITING_STATE_FILE;
                CheatSheetPlugin.getPlugin().getLog().error(message, e);
            }
        });
    }

    public IStatus saveMemento(XMLMemento memento, String filename) {
        File stateFile = this.getCheatSheetStateFile(filename);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(stateFile), StandardCharsets.UTF_8);){
                memento.save((Writer)writer);
                return Status.OK_STATUS;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            stateFile.delete();
            String message = Messages.ERROR_WRITING_STATE_FILE;
            Status status = new Status(4, "org.eclipse.ui.cheatsheets", 0, message, (Throwable)e);
            return status;
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.history != null) {
            this.saveCheatSheetHistory();
        }
        CheatSheetRegistryReader.getInstance().stop();
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        return null;
    }
}

