/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.ui.actions.Q7ExecutionViewAction;
import org.eclipse.rcptt.ui.launching.LaunchUtils;

public class RunSelectedAction
extends Q7ExecutionViewAction {
    public RunSelectedAction(ISelectionProvider selectionProvider) {
        this.setToolTipText(Messages.RunSelectedAction_ToolTip);
        this.setText("&Run");
        this.setImageDescriptor(Images.getImageDescriptor("icons/recording/play.gif"));
        this.setDisabledImageDescriptor(Images.getImageDescriptor("icons/recording/d_play.gif"));
        this.selectionProvider = selectionProvider;
    }

    public void run() {
        List<IExecutable> toExecute = this.getExecutables();
        ArrayList<IFile> files = new ArrayList<IFile>();
        HashMap<String, List<List<String>>> variants = new HashMap<String, List<List<String>>>();
        for (IExecutable executable : toExecute) {
            IFile file = (IFile)executable.getActualElement().getResource();
            if (file != null && !files.contains(file)) {
                files.add(file);
            }
            this.updateVariant(variants, executable);
        }
        if (files.size() > 0) {
            LaunchUtils.launchContext(files.toArray(new IResource[files.size()]), "run", variants);
        }
    }

    private List<IExecutable> getExecutables() {
        ArrayList<IExecutable> topExecutables = new ArrayList<IExecutable>();
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.processExecutable((IExecutable)it.next(), topExecutables);
        }
        return topExecutables;
    }

    private void processExecutable(IExecutable executable, List<IExecutable> topExecutables) {
        Iterator<IExecutable> it = topExecutables.iterator();
        while (it.hasNext()) {
            IExecutable topExecutable = it.next();
            if (this.isInChilds(topExecutable, executable)) {
                return;
            }
            if (!this.isInChilds(executable, topExecutable)) continue;
            it.remove();
            break;
        }
        IExecutable parent = this.executables.getParent(executable);
        if (parent != null && !(executable instanceof PrepareExecutionWrapper)) {
            topExecutables.add(parent);
        } else {
            topExecutables.add(executable);
        }
    }

    private boolean isInChilds(IExecutable parent, IExecutable executable) {
        IExecutable[] iExecutableArray = parent.getChildren();
        int n = iExecutableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable child = iExecutableArray[n2];
            if (executable.equals(child)) {
                return true;
            }
            if (this.isInChilds(child, executable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

