/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.utils;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LogBuilder {
    private final int initialLogSize;
    private final int rotationLogSize;
    private final StringBuilder initialLog = new StringBuilder();
    private final StringBuilder rotationLog = new StringBuilder();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public LogBuilder(int initialLogSize, int rotationLogSize) {
        this.initialLogSize = initialLogSize;
        this.rotationLogSize = rotationLogSize;
    }

    public void append(String string) {
        try {
            this.lock.writeLock().lock();
            if (!this.isFilled(this.initialLog, this.initialLogSize)) {
                this.initialLog.append(string);
            } else if (!this.isFilled(this.rotationLog, this.rotationLogSize)) {
                this.rotationLog.append(string);
            } else {
                this.rotationLog.delete(0, string.length());
                this.rotationLog.append(string);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        try {
            this.lock.writeLock().lock();
            this.initialLog.setLength(0);
            this.rotationLog.setLength(0);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        try {
            this.lock.readLock().lock();
            Object result = "Initial log:";
            result = (String)result + System.lineSeparator();
            result = (String)result + (this.initialLog.length() > 0 ? this.initialLog.toString() : "Empty.");
            result = (String)result + System.lineSeparator();
            if (this.rotationLog.length() > 0) {
                result = (String)result + "Rotation log:";
                result = (String)result + System.lineSeparator();
                result = (String)result + this.rotationLog.toString();
            }
            Object object = result;
            return object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private boolean isFilled(StringBuilder builder, int maxSize) {
        return builder.length() * 2 > maxSize;
    }
}

