/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.widgets.Shell;

public class RemoveAllProjectReferencesDialog {
    private static IPreferenceStore prefStore = Q7UIPlugin.getDefault().getPreferenceStore();
    private static boolean isOpen = false;

    public static boolean open(Shell parentShell, IQ7Project project, List<IQ7NamedElement> elements) {
        if (isOpen) {
            return false;
        }
        isOpen = true;
        try {
            String value = prefStore.getString("all_remove_project_context_references");
            if ("always".equals(value)) {
                return true;
            }
            if ("never".equals(value)) {
                return false;
            }
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)parentShell, (String)"Project Context and Verification References", (String)RemoveAllProjectReferencesDialog.generateMessage(elements), null, (boolean)false, (IPreferenceStore)prefStore, (String)"all_remove_project_context_references");
            boolean bl = dialog.getReturnCode() == 2;
            return bl;
        }
        finally {
            isOpen = false;
        }
    }

    private static String generateMessage(List<IQ7NamedElement> references) {
        StringBuilder label = new StringBuilder("Would you like to remove default project context/verification references from " + references.size() + " elements?\n\n");
        return label.toString();
    }

    public static boolean isNever() {
        String value = prefStore.getString("all_remove_project_context_references");
        return "never".equals(value);
    }
}

