/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IResourceChangeListener;

public class ResourceChangeListenerList {
    private volatile int count1 = 0;
    private volatile int count2 = 0;
    private volatile int count4 = 0;
    private volatile int count8 = 0;
    private volatile int count16 = 0;
    private volatile int count32 = 0;
    private final CopyOnWriteArrayList<ListenerEntry> listeners = new CopyOnWriteArrayList();

    public synchronized void add(IResourceChangeListener listener, int mask) {
        Objects.requireNonNull(listener);
        if (mask == 0) {
            this.remove(listener);
            return;
        }
        ListenerEntry entry = new ListenerEntry(listener, mask);
        int oldSize = this.listeners.size();
        int i = 0;
        while (i < oldSize) {
            ListenerEntry oldEntry = this.listeners.get(i);
            if (oldEntry.listener == listener) {
                this.removing(oldEntry.eventMask);
                this.adding(mask);
                this.listeners.set(i, entry);
                return;
            }
            ++i;
        }
        this.adding(mask);
        this.listeners.add(entry);
    }

    private void adding(int mask) {
        if ((mask & 1) != 0) {
            ++this.count1;
        }
        if ((mask & 2) != 0) {
            ++this.count2;
        }
        if ((mask & 4) != 0) {
            ++this.count4;
        }
        if ((mask & 8) != 0) {
            ++this.count8;
        }
        if ((mask & 0x10) != 0) {
            ++this.count16;
        }
        if ((mask & 0x20) != 0) {
            ++this.count32;
        }
    }

    public ListenerEntry[] getListeners() {
        return (ListenerEntry[])this.listeners.toArray(ListenerEntry[]::new);
    }

    public boolean hasListenerFor(int event) {
        switch (event) {
            case 1: {
                return this.count1 > 0;
            }
            case 2: {
                return this.count2 > 0;
            }
            case 4: {
                return this.count4 > 0;
            }
            case 8: {
                return this.count8 > 0;
            }
            case 16: {
                return this.count16 > 0;
            }
            case 32: {
                return this.count32 > 0;
            }
        }
        return false;
    }

    public synchronized void remove(IResourceChangeListener listener) {
        Objects.requireNonNull(listener);
        int oldSize = this.listeners.size();
        int i = 0;
        while (i < oldSize) {
            ListenerEntry oldEntry = this.listeners.get(i);
            if (oldEntry.listener == listener) {
                this.removing(oldEntry.eventMask);
                this.listeners.remove(i);
                return;
            }
            ++i;
        }
    }

    public synchronized void clear() {
        this.listeners.clear();
        this.count1 = 0;
        this.count2 = 0;
        this.count4 = 0;
        this.count8 = 0;
        this.count16 = 0;
        this.count32 = 0;
    }

    private void removing(int mask) {
        if ((mask & 1) != 0) {
            --this.count1;
        }
        if ((mask & 2) != 0) {
            --this.count2;
        }
        if ((mask & 4) != 0) {
            --this.count4;
        }
        if ((mask & 8) != 0) {
            --this.count8;
        }
        if ((mask & 0x10) != 0) {
            --this.count16;
        }
        if ((mask & 0x20) != 0) {
            --this.count32;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ResourceChangeListenerList [");
        if (this.listeners != null) {
            builder.append("listeners=");
            builder.append(this.listeners.toString());
        }
        builder.append("]");
        return builder.toString();
    }

    static final class ListenerEntry {
        final int eventMask;
        final IResourceChangeListener listener;

        ListenerEntry(IResourceChangeListener listener, int eventMask) {
            this.listener = listener;
            this.eventMask = eventMask;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Listener [eventMask=");
            sb.append(this.eventMask);
            sb.append(", ");
            sb.append(this.listener);
            sb.append("]");
            return sb.toString();
        }
    }
}

