/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.controls;

import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;

public class EmbeddedTabFolder
extends CTabFolder {
    public EmbeddedTabFolder(Composite parent, int style) {
        super(parent, style);
        this.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EmbeddedTabFolder.this.handleTabSelection((TabItem)e.item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                EmbeddedTabFolder.this.handleTabSelection((TabItem)e.item);
            }
        });
    }

    public TabItem getItem(int index) {
        return (TabItem)super.getItem(index);
    }

    public TabItem addTab(IEmbeddedComposite part) {
        TabItem item = new TabItem(this, 0, part);
        return item;
    }

    private void handleTabSelection(TabItem tab) {
        IEmbeddedComposite part = tab.getData();
        Control last = this.getTopRight();
        if (last != null) {
            last.setVisible(false);
        }
        ToolBar toolBar = part.getToolBar();
        this.setTopRight(null);
        if (toolBar != null) {
            toolBar.setVisible(true);
            this.setTopRight((Control)toolBar);
        }
    }

    public static class TabItem
    extends CTabItem {
        public TabItem(EmbeddedTabFolder parent, int style, IEmbeddedComposite part) {
            super((CTabFolder)parent, style);
            boolean first = parent.getItemCount() == 1;
            this.setData(part);
            this.setText(part.getName());
            this.setImage(part.getImage());
            part.createControl((Composite)parent);
            this.setControl(part.getControl());
            part.createToolBar((Composite)parent);
            ToolBar toolBar = part.getToolBar();
            if (toolBar != null) {
                toolBar.setVisible(false);
            }
            if (first) {
                parent.handleTabSelection(this);
            }
        }

        public IEmbeddedComposite getData() {
            return (IEmbeddedComposite)super.getData();
        }
    }
}

