/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testrail.ui.preferences;

import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.internal.testrail.TestRailAPIClient;
import org.eclipse.rcptt.internal.testrail.TestRailPlugin;
import org.eclipse.rcptt.testrail.internal.ui.Messages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class TestRailPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button testRailCheckBox;
    private Text testRailAddress;
    private Text testRailUsername;
    private Text testRailPassword;
    private Text testRailProjectId;
    private Button testConnectionButton;
    private Button useUnicodeButton;

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.testRailCheckBox.getSelection()) {
            TestRailPlugin.setTestRailState((int)1);
        } else {
            TestRailPlugin.setTestRailState((int)0);
        }
        TestRailPlugin.setTestRailAddress((String)this.testRailAddress.getText());
        TestRailPlugin.setTestRailUsername((String)this.testRailUsername.getText());
        TestRailPlugin.setTestRailPassword((String)this.testRailPassword.getText());
        TestRailPlugin.setTestRailProjectId((String)this.testRailProjectId.getText());
        if (this.useUnicodeButton.getSelection()) {
            TestRailPlugin.setTestRailUseUnicode((int)1);
        } else {
            TestRailPlugin.setTestRailUseUnicode((int)0);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        boolean state = false;
        this.testRailCheckBox.setSelection(state);
        this.testRailAddress.setText("");
        this.testRailUsername.setText("");
        this.testRailPassword.setText("");
        this.testRailProjectId.setText("P1");
        this.testConnectionButton.setEnabled(state && this.isValid());
        this.useUnicodeButton.setSelection(false);
        super.performDefaults();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.testRailCheckBox = this.createCheckBoxButton(composite, Messages.TestRailPreferencePage_EnableIntegration, TestRailPlugin.getTestRailState());
        this.testRailAddress = this.createText(composite, Messages.TestRailPreferencePage_Address, TestRailPlugin.getTestRailAddress());
        this.testRailUsername = this.createText(composite, Messages.TestRailPreferencePage_Username, TestRailPlugin.getTestRailUsername());
        this.testRailPassword = this.createText(composite, Messages.TestRailPreferencePage_Password, TestRailPlugin.getTestRailPassword());
        this.testRailPassword.setEchoChar('*');
        this.testRailProjectId = this.createText(composite, Messages.TestRailPreferencePage_ProjectId, TestRailPlugin.getTestRailProjectId());
        this.testConnectionButton = this.createButton(composite, Messages.TestRailPreferencePage_TestConnection);
        boolean state = TestRailPlugin.getTestRailState();
        this.testConnectionButton.setEnabled(state && this.isValid());
        ExpandableComposite advancedExpander = new ExpandableComposite(parent, 0, 2);
        advancedExpander.setText(Messages.TestRailPreferencePage_AdvancedSectionLabel);
        advancedExpander.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite advancedComposite = new Composite((Composite)advancedExpander, 0);
        advancedComposite.setLayout((Layout)new GridLayout(1, false));
        advancedExpander.setClient((Control)advancedComposite);
        this.useUnicodeButton = new Button(advancedComposite, 32);
        this.useUnicodeButton.setText(Messages.TestRailPreferencePage_UseUnicode);
        this.useUnicodeButton.setSelection(TestRailPlugin.getTestRailUseUnicode());
        return null;
    }

    private Text createText(Composite parent, String labelText, String initialValue) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setText(initialValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TestRailPreferencePage.this.validate();
                boolean state = TestRailPreferencePage.this.testRailCheckBox.getSelection();
                TestRailPreferencePage.this.testConnectionButton.setEnabled(state && TestRailPreferencePage.this.isValid());
            }
        });
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private Button createCheckBoxButton(Composite parent, String labelText, boolean state) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Button button = new Button(parent, 32);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestRailPreferencePage.this.validate();
                boolean state = TestRailPreferencePage.this.testRailCheckBox.getSelection();
                TestRailPreferencePage.this.testConnectionButton.setEnabled(state && TestRailPreferencePage.this.isValid());
            }
        });
        button.setSelection(state);
        return button;
    }

    private Button createButton(Composite parent, String labelText) {
        Button button = new Button(parent, 8);
        button.setText(labelText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestRailPreferencePage.this.testConnection();
            }
        });
        return button;
    }

    private void validate() {
        String message = this.doValidate();
        this.setMessage(null);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private String doValidate() {
        if (!this.testRailCheckBox.getSelection()) {
            return null;
        }
        if (!this.isValidURL(this.testRailAddress.getText())) {
            return Messages.TestRailPreferencePage_IncorrectAddressMsg;
        }
        if (!this.testRailAddress.getText().endsWith("/")) {
            return Messages.TestRailPreferencePage_AddressEndsWithSlashMsg;
        }
        if (this.testRailUsername.getText() == null || this.testRailUsername.getText().equals("")) {
            return MessageFormat.format(Messages.TestRailPreferencePage_FieldNotSpecifiedMsg, Messages.TestRailPreferencePage_Username);
        }
        if (this.testRailPassword.getText() == null || this.testRailPassword.getText().equals("")) {
            return MessageFormat.format(Messages.TestRailPreferencePage_FieldNotSpecifiedMsg, Messages.TestRailPreferencePage_Password);
        }
        if (!this.isValidId(this.testRailProjectId.getText())) {
            return Messages.TestRailPreferencePage_IncorrectProjectIdMsg;
        }
        return null;
    }

    private boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            return !url.getHost().equals("");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isValidId(String idString) {
        if (!idString.startsWith("P")) {
            return false;
        }
        try {
            idString = idString.substring(1);
            int parsedValue = Integer.parseInt(idString);
            if (parsedValue > 0) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private void testConnection() {
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

            @Override
            public void run() {
                String projectId;
                String password;
                String username;
                String address = TestRailPreferencePage.this.testRailAddress.getText();
                TestRailAPIClient client = new TestRailAPIClient(address, username = TestRailPreferencePage.this.testRailUsername.getText(), password = TestRailPreferencePage.this.testRailPassword.getText(), projectId = TestRailPreferencePage.this.testRailProjectId.getText());
                boolean isAvailable = client.isAvailable();
                if (!isAvailable) {
                    TestRailPreferencePage.this.setMessage(null);
                    TestRailPreferencePage.this.setErrorMessage(Messages.TestRailPreferencePage_FailedToConnectMsg);
                } else {
                    TestRailPreferencePage.this.setErrorMessage(null);
                    TestRailPreferencePage.this.setMessage(Messages.TestRailPreferencePage_SuccessfullyConnectedMsg, 1);
                }
            }
        });
    }
}

