/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.EmptyModel;

public abstract class FilteredModel
extends AbstractModel {
    private final Model model;
    private static final long serialVersionUID = -2353344619836326934L;
    protected Resource subj;
    protected IRI pred;
    protected Value obj;
    protected Resource[] contexts;

    protected FilteredModel(AbstractModel model, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        Objects.requireNonNull(contexts);
        this.model = model;
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
        this.contexts = contexts;
    }

    public Optional<Namespace> getNamespace(String prefix) {
        return this.model.getNamespace(prefix);
    }

    public Set<Namespace> getNamespaces() {
        return this.model.getNamespaces();
    }

    public Namespace setNamespace(String prefix, String name) {
        return this.model.setNamespace(prefix, name);
    }

    public void setNamespace(Namespace namespace) {
        this.model.setNamespace(namespace);
    }

    public Optional<Namespace> removeNamespace(String prefix) {
        return this.model.removeNamespace(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Iterator iter = this.iterator();
        try {
            int size = 0;
            while (iter.hasNext()) {
                ++size;
                iter.next();
            }
            int n = size;
            return n;
        }
        finally {
            this.closeIterator(iter);
        }
    }

    public boolean add(Resource s, IRI p, Value o, Resource ... c) {
        if (s == null) {
            s = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s, p, o, c)) {
            throw new IllegalArgumentException("Statement is filtered out of view");
        }
        return this.model.add(s, p, o, c);
    }

    public boolean remove(Resource s, IRI p, Value o, Resource ... c) {
        if (s == null) {
            s = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s, p, o, c)) {
            return false;
        }
        return this.model.remove(s, p, o, c);
    }

    public boolean contains(Resource s, IRI p, Value o, Resource ... c) {
        if (s == null) {
            s = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s, p, o, c)) {
            return false;
        }
        return this.model.contains(s, p, o, c);
    }

    public Model filter(Resource s, IRI p, Value o, Resource ... c) {
        if (s == null) {
            s = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s, p, o, c)) {
            return new EmptyModel(this.model);
        }
        return this.model.filter(s, p, o, c);
    }

    @Override
    public final void removeTermIteration(Iterator<Statement> iter, Resource s, IRI p, Value o, Resource ... c) {
        if (s == null) {
            s = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s, p, o, c)) {
            throw new IllegalStateException();
        }
        this.removeFilteredTermIteration(iter, s, p, o, c);
    }

    protected abstract void removeFilteredTermIteration(Iterator<Statement> var1, Resource var2, IRI var3, Value var4, Resource ... var5);

    private boolean accept(Resource s, IRI p, Value o, Resource ... c) {
        if (this.subj != null && !this.subj.equals(s)) {
            return false;
        }
        if (this.pred != null && !this.pred.equals((Object)p)) {
            return false;
        }
        if (this.obj != null && !this.obj.equals(o)) {
            return false;
        }
        return this.matches(c, this.contexts);
    }

    private boolean matches(Resource[] stContext, Resource ... contexts) {
        Objects.requireNonNull(stContext);
        if (stContext.length > 0) {
            for (Resource c : stContext) {
                if (this.matches(c, contexts)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matches(Resource stContext, Resource ... contexts) {
        Objects.requireNonNull(contexts);
        if (contexts.length == 0) {
            return true;
        }
        for (Resource context : contexts) {
            if (context == null && stContext == null) {
                return true;
            }
            if (context == null || !context.equals(stContext)) continue;
            return true;
        }
        return false;
    }
}

