/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager.util;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;
import org.eclipse.rdf4j.repository.manager.util.RepositoryManagerListener;

public class NotifyingLocalRepositoryManager
extends LocalRepositoryManager {
    private final ArrayList<RepositoryManagerListener> listeners = new ArrayList();

    public NotifyingLocalRepositoryManager(File baseDir) {
        super(baseDir);
    }

    public void addRepositoryManagerListener(RepositoryManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeRepositoryManagerListener(RepositoryManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void init() throws RepositoryException {
        super.init();
        this.fireInitialized();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.fireRefreshed();
    }

    @Override
    public void shutDown() {
        super.shutDown();
        this.fireShutDown();
    }

    private void fireInitialized() {
        for (RepositoryManagerListener listener : this.listeners) {
            listener.initialized(this);
        }
    }

    private void fireRefreshed() {
        for (RepositoryManagerListener listener : this.listeners) {
            listener.refreshed(this);
        }
    }

    private void fireShutDown() {
        for (RepositoryManagerListener listener : this.listeners) {
            listener.shutDown(this);
        }
    }
}

