/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;

public abstract class AbstractTriple
implements Triple {
    private static final long serialVersionUID = 2661609986803671844L;

    @Override
    public String stringValue() {
        return "<<" + String.valueOf(this.getSubject()) + " " + String.valueOf(this.getPredicate()) + " " + String.valueOf(this.getObject()) + ">>";
    }

    @Override
    public boolean equals(Object o) {
        return this == o || o instanceof Triple && this.getObject().equals(((Triple)o).getObject()) && this.getSubject().equals(((Triple)o).getSubject()) && this.getPredicate().equals(((Triple)o).getPredicate());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getSubject(), this.getPredicate(), this.getObject());
    }

    public String toString() {
        return this.stringValue();
    }

    static class GenericTriple
    extends AbstractTriple {
        private static final long serialVersionUID = 7822116805598041700L;
        private final Resource subject;
        private final IRI predicate;
        private final Value object;

        GenericTriple(Resource subject, IRI predicate, Value object) {
            this.subject = subject;
            this.predicate = predicate;
            this.object = object;
        }

        @Override
        public Resource getSubject() {
            return this.subject;
        }

        @Override
        public IRI getPredicate() {
            return this.predicate;
        }

        @Override
        public Value getObject() {
            return this.object;
        }
    }
}

