/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.spatial3d.Geo3DDocValuesField;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoOutsideDistance;
import org.apache.lucene.spatial3d.geom.PlanetModel;

class Geo3DPointOutsideDistanceComparator
extends FieldComparator<Double>
implements LeafFieldComparator {
    final String field;
    final GeoOutsideDistance distanceShape;
    private final PlanetModel planetModel;
    final double[] values;
    double bottomDistance;
    double topValue;
    SortedNumericDocValues currentDocs;

    public Geo3DPointOutsideDistanceComparator(String field, PlanetModel planetModel, GeoOutsideDistance distanceShape, int numHits) {
        this.field = field;
        this.planetModel = planetModel;
        this.distanceShape = distanceShape;
        this.values = new double[numHits];
    }

    public void setScorer(Scorable scorer) {
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.values[slot1], this.values[slot2]);
    }

    public void setBottom(int slot) {
        this.bottomDistance = this.values[slot];
    }

    public void setTopValue(Double value) {
        this.topValue = value;
    }

    public int compareBottom(int doc) throws IOException {
        if (doc > this.currentDocs.docID()) {
            this.currentDocs.advance(doc);
        }
        if (doc < this.currentDocs.docID()) {
            return Double.compare(this.bottomDistance, Double.POSITIVE_INFINITY);
        }
        int numValues = this.currentDocs.docValueCount();
        assert (numValues > 0);
        int cmp = -1;
        for (int i = 0; i < numValues; ++i) {
            long encoded = this.currentDocs.nextValue();
            double x = this.planetModel.getDocValueEncoder().decodeXValue(encoded);
            double y = this.planetModel.getDocValueEncoder().decodeYValue(encoded);
            double z = this.planetModel.getDocValueEncoder().decodeZValue(encoded);
            cmp = Math.max(cmp, Double.compare(this.bottomDistance, this.distanceShape.computeOutsideDistance(DistanceStyle.ARC, x, y, z)));
        }
        return cmp;
    }

    public void copy(int slot, int doc) throws IOException {
        this.values[slot] = this.computeMinimumDistance(doc);
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        LeafReader reader = context.reader();
        FieldInfo info = reader.getFieldInfos().fieldInfo(this.field);
        if (info != null) {
            Geo3DDocValuesField.checkCompatible(info);
        }
        this.currentDocs = DocValues.getSortedNumeric((LeafReader)reader, (String)this.field);
        return this;
    }

    public Double value(int slot) {
        return this.values[slot] * this.planetModel.getMeanRadius();
    }

    public int compareTop(int doc) throws IOException {
        return Double.compare(this.topValue, this.computeMinimumDistance(doc));
    }

    double computeMinimumDistance(int doc) throws IOException {
        if (doc > this.currentDocs.docID()) {
            this.currentDocs.advance(doc);
        }
        double minValue = Double.POSITIVE_INFINITY;
        if (doc == this.currentDocs.docID()) {
            int numValues = this.currentDocs.docValueCount();
            for (int i = 0; i < numValues; ++i) {
                long encoded = this.currentDocs.nextValue();
                double distance = this.distanceShape.computeOutsideDistance(DistanceStyle.ARC, this.planetModel.getDocValueEncoder().decodeXValue(encoded), this.planetModel.getDocValueEncoder().decodeYValue(encoded), this.planetModel.getDocValueEncoder().decodeZValue(encoded));
                minValue = Math.min(minValue, distance);
            }
        }
        return minValue;
    }
}

