/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class IndependentJoingroupBindingsIteration2
extends LookAheadIteration<BindingSet> {
    protected static final Pattern pattern = Pattern.compile("(.*)_(.*)_(.*)");
    protected final List<BindingSet> bindings;
    protected final CloseableIteration<BindingSet> iter;
    protected ArrayList<BindingSet> result = null;
    protected int currentIdx = 0;

    public IndependentJoingroupBindingsIteration2(CloseableIteration<BindingSet> iter, List<BindingSet> bindings) {
        this.bindings = bindings;
        this.iter = iter;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.result == null) {
            this.result = this.computeResult();
        }
        if (this.currentIdx >= this.result.size()) {
            return null;
        }
        return this.result.get(this.currentIdx++);
    }

    protected ArrayList<BindingSet> computeResult() throws QueryEvaluationException {
        ArrayList<BindingInfo> a_res = new ArrayList<BindingInfo>();
        ArrayList<BindingInfo> b_res = new ArrayList<BindingInfo>();
        while (this.iter.hasNext()) {
            BindingSet bIn = (BindingSet)this.iter.next();
            if (bIn.size() != 1) {
                throw new RuntimeException("For this optimization a bindingset needs to have exactly one binding, it has " + bIn.size() + ": " + String.valueOf(bIn));
            }
            Binding b = bIn.getBinding(bIn.getBindingNames().iterator().next());
            Matcher m = pattern.matcher(b.getName());
            if (!m.find()) {
                throw new QueryEvaluationException("Unexpected pattern for binding name: " + b.getName());
            }
            BindingInfo bInfo = new BindingInfo(m.group(1), Integer.parseInt(m.group(3)), b.getValue());
            int bIndex = Integer.parseInt(m.group(2));
            if (bIndex == 0) {
                a_res.add(bInfo);
                continue;
            }
            if (bIndex == 1) {
                b_res.add(bInfo);
                continue;
            }
            throw new RuntimeException("Unexpected binding value.");
        }
        ArrayList<BindingSet> res = new ArrayList<BindingSet>(a_res.size() * b_res.size());
        for (BindingInfo a : a_res) {
            for (BindingInfo b : b_res) {
                if (a.bindingsIdx != b.bindingsIdx) continue;
                QueryBindingSet newB = new QueryBindingSet(this.bindings.size() + 2);
                newB.addBinding(a.name, a.value);
                newB.addBinding(b.name, b.value);
                newB.addAll(this.bindings.get(a.bindingsIdx));
                res.add(newB);
            }
        }
        return res;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        this.iter.close();
    }

    protected static class BindingInfo {
        public final String name;
        public final int bindingsIdx;
        public final Value value;

        public BindingInfo(String name, int bindingsIdx, Value value) {
            this.name = name;
            this.bindingsIdx = bindingsIdx;
            this.value = value;
        }

        public String toString() {
            return this.name + ":" + this.value.stringValue();
        }
    }
}

