/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;

public class IrUnion
extends IrNode {
    private final List<IrBGP> branches = new ArrayList<IrBGP>();

    public IrUnion(boolean newScope) {
        super(newScope);
    }

    public List<IrBGP> getBranches() {
        return this.branches;
    }

    public void addBranch(IrBGP w) {
        if (w != null) {
            this.branches.add(w);
        }
    }

    @Override
    public void print(IrPrinter p) {
        for (int i = 0; i < this.branches.size(); ++i) {
            IrBGP b = this.branches.get(i);
            if (b != null) {
                IrBGP toPrint = b;
                if (toPrint.isNewScope()) {
                    toPrint = new IrBGP(toPrint.getLines(), false);
                }
                if (toPrint.getLines().size() == 1 && toPrint.getLines().get(0) instanceof IrBGP) {
                    IrBGP inner = (IrBGP)toPrint.getLines().get(0);
                    new IrBGP(inner.getLines(), false).print(p);
                } else {
                    toPrint.print(p);
                }
            }
            if (i + 1 >= this.branches.size()) continue;
            p.line("UNION");
        }
    }

    @Override
    public IrNode transformChildren(UnaryOperator<IrNode> op) {
        IrUnion u = new IrUnion(this.isNewScope());
        for (IrBGP b : this.branches) {
            IrNode t = (IrNode)op.apply(b);
            u.addBranch((t = t.transformChildren(op)) instanceof IrBGP ? (IrBGP)t : b);
        }
        return u;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IrBGP branch : this.branches) {
            sb.append("  ");
            sb.append(branch);
            sb.append("\n");
        }
        return "IrUnion{branches=\n" + String.valueOf(sb) + ", newScope=" + this.isNewScope() + "}";
    }

    @Override
    public Set<Var> getVars() {
        HashSet<Var> out = new HashSet<Var>();
        for (IrBGP b : this.branches) {
            if (b == null) continue;
            out.addAll(b.getVars());
        }
        return out;
    }
}

