/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class NormalizeNpsMemberOrderTransform
extends BaseTransform {
    private NormalizeNpsMemberOrderTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        Iterator<IrNode> iterator = bgp.getLines().iterator();
        while (iterator.hasNext()) {
            IrNode n;
            IrNode m = n = iterator.next();
            if (n instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)n;
                String ptxt = pt.getPathText();
                String rew = NormalizeNpsMemberOrderTransform.reorderAllNps(ptxt);
                if (!rew.equals(ptxt)) {
                    IrPathTriple np = new IrPathTriple(pt.getSubject(), rew, pt.getObject(), pt.isNewScope(), pt.getPathVars());
                    m = np;
                }
            } else if (n instanceof IrGraph) {
                IrGraph g = (IrGraph)n;
                m = new IrGraph(g.getGraph(), NormalizeNpsMemberOrderTransform.apply(g.getWhere()), g.isNewScope());
            } else if (n instanceof IrOptional) {
                IrOptional o = (IrOptional)n;
                IrOptional no = new IrOptional(NormalizeNpsMemberOrderTransform.apply(o.getWhere()), o.isNewScope());
                no.setNewScope(o.isNewScope());
                m = no;
            } else if (n instanceof IrMinus) {
                IrMinus mi = (IrMinus)n;
                m = new IrMinus(NormalizeNpsMemberOrderTransform.apply(mi.getWhere()), mi.isNewScope());
            } else if (n instanceof IrUnion) {
                IrUnion u = (IrUnion)n;
                IrUnion u2 = new IrUnion(u.isNewScope());
                for (IrBGP b : u.getBranches()) {
                    u2.addBranch(NormalizeNpsMemberOrderTransform.apply(b));
                }
                m = u2;
            } else if (n instanceof IrService) {
                IrService s = (IrService)n;
                m = new IrService(s.getServiceRefText(), s.isSilent(), NormalizeNpsMemberOrderTransform.apply(s.getWhere()), s.isNewScope());
            } else if (n instanceof IrSubSelect) {
                // empty if block
            }
            out.add(m);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }

    static String reorderAllNps(String path) {
        if (path == null || path.indexOf(33) < 0) {
            return path;
        }
        String s = path;
        StringBuilder out = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            int start;
            int bang = s.indexOf("!(", i);
            if (bang < 0) {
                out.append(s.substring(i));
                break;
            }
            out.append(s, i, bang);
            int j = start = bang + 2;
            int depth = 1;
            while (j < s.length() && depth > 0) {
                char c;
                if ((c = s.charAt(j++)) == '(') {
                    ++depth;
                    continue;
                }
                if (c != ')') continue;
                --depth;
            }
            if (depth != 0) {
                out.append(s.substring(bang));
                break;
            }
            int end = j - 1;
            String inner = s.substring(start, end);
            String reordered = NormalizeNpsMemberOrderTransform.reorderMembers(inner);
            out.append("!(").append(reordered).append(")");
            i = end + 1;
        }
        return out.toString();
    }

    static String reorderMembers(String inner) {
        class Tok {
            final String text;

            Tok(String t) {
                this.text = t;
            }
        }
        List toks = Arrays.stream(inner.split("\\|")).map(String::trim).filter(t -> !t.isEmpty()).map(x$0 -> new Tok((String)x$0)).collect(Collectors.toList());
        return toks.stream().map(t -> t.text).collect(Collectors.joining("|"));
    }
}

