/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.wal;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalReader;
import org.eclipse.rdf4j.sail.nativerdf.wal.ValueStoreWalRecord;

public final class ValueStoreWalRecovery {
    public Map<Integer, ValueStoreWalRecord> replay(ValueStoreWalReader reader) throws IOException {
        return this.replayWithReport(reader).dictionary();
    }

    public ReplayReport replayWithReport(ValueStoreWalReader reader) throws IOException {
        ValueStoreWalReader.ScanResult scan = reader.scan();
        LinkedHashMap<Integer, ValueStoreWalRecord> dictionary = new LinkedHashMap<Integer, ValueStoreWalRecord>();
        for (ValueStoreWalRecord record : scan.records()) {
            dictionary.putIfAbsent(record.id(), record);
        }
        return new ReplayReport(dictionary, scan.complete());
    }

    public static final class ReplayReport {
        private final Map<Integer, ValueStoreWalRecord> dictionary;
        private final boolean complete;

        public ReplayReport(Map<Integer, ValueStoreWalRecord> dictionary, boolean complete) {
            this.dictionary = Collections.unmodifiableMap(new LinkedHashMap<Integer, ValueStoreWalRecord>(dictionary));
            this.complete = complete;
        }

        public Map<Integer, ValueStoreWalRecord> dictionary() {
            return this.dictionary;
        }

        public boolean complete() {
            return this.complete;
        }
    }
}

