/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

public class ReduceTargets
implements PlanNode {
    private final PlanNode parentToReduce;
    private final PlanNode reductionSource;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public ReduceTargets(PlanNode parentToReduce, PlanNode reductionSource, ConnectionsGroup connectionsGroup) {
        this.parentToReduce = PlanNodeHelper.handleSorting(this, parentToReduce, connectionsGroup);
        this.reductionSource = reductionSource;
    }

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple> parentIterator;
            Set<Value> reductionSourceSet;
            ValidationTuple next;

            @Override
            protected void init() {
                assert (this.reductionSourceSet == null);
                this.parentIterator = ReduceTargets.this.parentToReduce.iterator();
                if (!this.parentIterator.hasNext()) {
                    this.parentIterator.close();
                    this.reductionSourceSet = null;
                } else {
                    this.reductionSourceSet = new HashSet<Value>();
                    try (CloseableIteration<? extends ValidationTuple> iterator = ReduceTargets.this.reductionSource.iterator();){
                        while (iterator.hasNext()) {
                            this.reductionSourceSet.add(((ValidationTuple)iterator.next()).getActiveTarget());
                        }
                    }
                }
            }

            void calculateNext() {
                while (this.next == null && this.parentIterator.hasNext()) {
                    ValidationTuple temp = (ValidationTuple)this.parentIterator.next();
                    if (this.reductionSourceSet != null && this.reductionSourceSet.contains(temp.getActiveTarget())) continue;
                    this.next = temp;
                }
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.calculateNext();
                ValidationTuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            protected boolean localHasNext() {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public void localClose() {
                if (this.parentIterator != null) {
                    this.parentIterator.close();
                }
            }
        };
    }

    @Override
    public int depth() {
        return this.parentToReduce.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId()).append(" [label=\"").append(StringEscapeUtils.escapeJava((String)this.toString())).append("\"];").append("\n");
        stringBuilder.append(this.parentToReduce.getId() + " -> " + this.getId()).append("\n");
        stringBuilder.append(this.reductionSource.getId() + " -> " + this.getId()).append("\n");
        this.parentToReduce.getPlanAsGraphvizDot(stringBuilder);
        this.reductionSource.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return "" + System.identityHashCode(this);
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parentToReduce.receiveLogger(validationExecutionLogger);
        this.reductionSource.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parentToReduce.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public String toString() {
        return "ReduceTargets";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReduceTargets that = (ReduceTargets)o;
        if (!this.parentToReduce.equals(that.parentToReduce)) {
            return false;
        }
        return this.reductionSource.equals(that.reductionSource);
    }

    public int hashCode() {
        return 31 * this.parentToReduce.hashCode() + this.reductionSource.hashCode();
    }
}

