/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.config;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.actf.core.config.ConfigurationException;
import org.eclipse.actf.core.config.IConfiguration;
import org.eclipse.actf.util.resources.ClassLoaderCache;

public class AbstractConfiguration
implements IConfiguration {
    static final long serialVersionUID = -1301837737929422833L;
    protected Map _configMap = new HashMap();
    protected String _curPool;

    public AbstractConfiguration() {
        this.createSymbolPool("actf");
    }

    public Map getSymbolPoolContents(String string) {
        return (Map)this._configMap.get(string);
    }

    public void setSymbolPool(String string) {
        if (string == null || !this._configMap.containsKey(string)) {
            throw new IllegalArgumentException("No pool with id " + string);
        }
        this._curPool = string;
    }

    public void createSymbolPool(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Pool name cannot be null");
        }
        this._configMap.put(string, new HashMap());
        this.setSymbolPool(string);
    }

    public String getSymbolPool() {
        return this._curPool;
    }

    public String[] getSymbolPools() {
        return this._configMap.keySet().toArray(new String[0]);
    }

    public String[] getModelTypes() {
        this.setSymbolPool("model");
        return this.getParameterNames();
    }

    public void setParameter(String string, Object object) {
        if (object != null) {
            this.getSymbolPoolContents(this._curPool).put(string, object);
        }
    }

    public void setParameter(String string, String string2) {
        this.getSymbolPoolContents(this._curPool).put(string, string2);
    }

    public void setParameter(String string, int n) {
        this.getSymbolPoolContents(this._curPool).put(string, new Integer(n));
    }

    public void setParameter(String string, double d) {
        this.getSymbolPoolContents(this._curPool).put(string, new Double(d));
    }

    public void setParameter(String string, boolean bl) {
        this.getSymbolPoolContents(this._curPool).put(string, bl);
    }

    public void setParameter(String string, Class clazz) {
        this.getSymbolPoolContents(this._curPool).put(string, clazz);
    }

    public void setParameter(String string, String string2, Object object) {
        String string3 = this.getSymbolPool();
        this.setSymbolPool(string);
        this.getSymbolPoolContents(this._curPool).put(string2, object);
        this.setSymbolPool(string3);
    }

    public Object getParameter(String string) {
        return this.getSymbolPoolContents(this._curPool).get(string);
    }

    public String getStringParameter(String string) {
        String string2 = (String)this.getSymbolPoolContents(this._curPool).get(string);
        return string2 == null ? "" : string2;
    }

    public int getIntParameter(String string) {
        Object v = this.getSymbolPoolContents(this._curPool).get(string);
        int n = Integer.MIN_VALUE;
        if (v instanceof Integer) {
            n = (Integer)v;
        } else if (v instanceof String) {
            try {
                n = Integer.parseInt((String)v);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n;
    }

    public double getDoubleParameter(String string) {
        Object v = this.getSymbolPoolContents(this._curPool).get(string);
        double d = Double.MIN_VALUE;
        if (v instanceof Double) {
            d = (Double)v;
        } else if (v instanceof String) {
            try {
                d = Double.parseDouble((String)v);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return d;
    }

    public boolean getBooleanParameter(String string) {
        Object v = this.getSymbolPoolContents(this._curPool).get(string);
        boolean bl = false;
        if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else if (v instanceof String) {
            try {
                bl = Boolean.valueOf((String)v);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    public Class getClassParameter(String string) {
        Object v = this.getSymbolPoolContents(this._curPool).get(string);
        Class clazz = null;
        if (v instanceof Class) {
            clazz = (Class)v;
        } else if (v instanceof String) {
            try {
                clazz = ClassLoaderCache.getDefault().classForName((String)v);
            }
            catch (Exception exception) {
                Logger.getLogger("org.eclipse.actf.core").log(Level.SEVERE, exception.getMessage(), exception);
            }
        }
        return clazz;
    }

    public String getParameterAsString(String string) {
        return this.getSymbolPoolContents(this._curPool).get(string).toString();
    }

    public void addConfigurationData(Object object) throws ConfigurationException {
        if (object != null && object instanceof Map) {
            this._configMap.put(this.getSymbolPool(), (Map)object);
        }
    }

    public String[] getParameterNames() {
        return this.getSymbolPoolContents(this._curPool).keySet().toArray(new String[0]);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getSymbolPools();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append("Pool: " + stringArray[n]);
            stringBuffer.append('\n');
            Map map = this.getSymbolPoolContents(stringArray[n]);
            if (map != null && !map.isEmpty()) {
                for (String string : map.keySet()) {
                    stringBuffer.append(string);
                    stringBuffer.append('=');
                    stringBuffer.append(map.get(string).toString());
                    stringBuffer.append('\n');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

