/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.actions;

import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class GoToActivityExplorerAction
extends BaseSelectionListenerAction {
    private Session session;

    public GoToActivityExplorerAction() {
        this("Go To Activity Explorer");
    }

    protected GoToActivityExplorerAction(String text) {
        super(text);
        ActivityExplorerActivator.getDefault().getImage("icons/full/obj16/menu-overview.gif");
        this.setImageDescriptor(ActivityExplorerActivator.getDefault().getImageRegistry().getDescriptor("icons/full/obj16/menu-overview.gif"));
    }

    public void run() {
        if (this.session == null) {
            this.session = this.getSession();
        }
        if (this.session != null) {
            ActivityExplorerEditor part = ActivityExplorerManager.INSTANCE.getEditorFromSession(this.session);
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)part);
        }
    }

    protected Session getSession() {
        IStructuredSelection selection = this.getStructuredSelection();
        Session session = null;
        if (!selection.isEmpty()) {
            ModelingProject p;
            Option modelingProjectOption;
            Object selectedElement = selection.getFirstElement();
            if (selectedElement instanceof IFile && "aird".equals(((IFile)selectedElement).getFileExtension())) {
                session = SessionHelper.getSessionForDiagramFile((IFile)selectedElement);
            } else if (selectedElement instanceof IProject && (modelingProjectOption = ModelingProject.asModelingProject((IProject)((IProject)selectedElement))).some() && (p = (ModelingProject)modelingProjectOption.get()).isValid()) {
                session = p.getSession();
            }
        }
        return session;
    }

    public boolean canAddedToMenu() {
        boolean result = false;
        this.session = this.getSession();
        if (this.session != null) {
            ActivityExplorerEditor editor = ActivityExplorerManager.INSTANCE.getEditorFromSession(this.session);
            result = editor != null;
        }
        return result;
    }
}

