/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.TableBorderHelper;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutCell;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutData;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutHelper;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.FixTableLayoutCalculator;
import org.eclipse.birt.report.designer.util.ITableLayoutCalculator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class TableLayout
extends XYLayout {
    private static final Insets INSETS_SINGLETON = new Insets();
    protected Map constraints = new HashMap();
    WorkingData data = null;
    private ITableLayoutOwner owner;
    boolean needlayout = true;
    TableBorderHelper helper;
    Map<IFigure, FigureInfomation> figureInfo = new HashMap<IFigure, FigureInfomation>();
    private boolean isCalculating = false;
    private boolean isNeedRelayout = true;

    public TableLayout() {
    }

    public TableLayout(ITableLayoutOwner part) {
        this.owner = part;
    }

    public void layout(IFigure container, boolean bool) {
        boolean temp = this.needlayout;
        this.layout(container);
        if (bool) {
            this.needlayout = temp;
        }
    }

    public void markDirty() {
        this.needlayout = true;
    }

    public TableBorderHelper getBorderHelper() {
        return this.helper;
    }

    public void layout(IFigure container) {
        if (!this.isDistroy()) {
            return;
        }
        this.helper = new TableBorderHelper(this.owner);
        this.helper.updateCellBorderInsets();
        this.figureInfo.clear();
        this.data = new WorkingData();
        this.data.columnWidths = new TableLayoutData.ColumnData[this.getColumnCount()];
        this.data.rowHeights = new TableLayoutData.RowData[this.getRowCount()];
        this.init(this.data.columnWidths, this.data.rowHeights);
        List children = container.getChildren();
        this.initMinSize(children);
        this.initMergeMinsize(children);
        this.caleLayoutData(container);
        if (!this.isCalculating) {
            this.layoutTable(container);
        }
        this.resetRowMinSize(this.data.rowHeights);
        this.initRowMinSize(children);
        this.initRowMergeMinsize(children);
        this.caleRowData();
        if (!this.isCalculating) {
            this.layoutTable(container);
        }
        this.setConstraint(container, this.data);
        this.needlayout = false;
        int containerWidth = this.getOwner().getFigure().getParent().getClientArea().getSize().width;
        if (containerWidth < 0) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TableLayout.this.isNeedRelayout) {
                        TableLayout.this.getOwner().reLayout();
                        TableLayout.this.isNeedRelayout = false;
                    }
                }
            });
            return;
        }
        this.reselect();
    }

    void reselect() {
        ArrayList list = new ArrayList(((StructuredSelection)this.getOwner().getViewer().getSelection()).toList());
        boolean hasCell = false;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof ITableLayoutCell || list.get(i) instanceof ITableLayoutOwner) {
                hasCell = true;
                break;
            }
            ++i;
        }
        if (hasCell) {
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    UIUtil.resetViewSelection(TableLayout.this.getOwner().getViewer(), false);
                }
            });
        }
    }

    void layoutTable(IFigure container) {
        List children = container.getChildren();
        int size = children.size();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            FigureInfomation info = this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int columnNumber = info.columnNumber;
            int rowSpan = info.rowSpan;
            int columnSpan = info.columnSpan;
            int x = this.getColumnWidth(1, columnNumber);
            int y = this.getRowHeight(1, rowNumber);
            int width = this.getColumnWidth(columnNumber, columnNumber + columnSpan);
            int height = this.getRowHeight(rowNumber, rowNumber + rowSpan);
            this.setBoundsOfChild(container, figure, new Rectangle(x, y, width, height));
            ++i;
        }
    }

    private int getRowHeight(int start, int end) {
        int retValue = 0;
        int i = start;
        while (i < end) {
            retValue += this.data.rowHeights[i - 1].height;
            ++i;
        }
        return retValue;
    }

    private int getColumnWidth(int start, int end) {
        int retValue = 0;
        int i = start;
        while (i < end) {
            retValue += this.data.columnWidths[i - 1].width;
            ++i;
        }
        return retValue;
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
        if (child.getLayoutManager() != null) {
            child.getLayoutManager().invalidate();
        }
        child.revalidate();
    }

    private void resetRowMinSize(TableLayoutData.RowData[] rowHeights) {
        int size = rowHeights.length;
        int i = 1;
        while (i < size + 1) {
            rowHeights[i - 1] = new TableLayoutData.RowData();
            rowHeights[i - 1].rowNumber = i;
            rowHeights[i - 1].height = this.getOwner().getRowHeightValue(i);
            ITableLayoutOwner.DimensionInfomation dim = this.getOwner().getRowHeight(i);
            boolean bl = rowHeights[i - 1].isForce = dim.getMeasure() > 0.0;
            if ("%".equals(dim.getUnits()) && dim.getMeasure() > 0.0) {
                rowHeights[i - 1].isPercentage = true;
                rowHeights[i - 1].percentageHeight = dim.getMeasure();
            }
            if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                rowHeights[i - 1].isAuto = true;
            }
            int n = rowHeights[i - 1].trueMinRowHeight = rowHeights[i - 1].isForce && !rowHeights[i - 1].isPercentage ? rowHeights[i - 1].height : rowHeights[i - 1].minRowHeight;
            if (rowHeights[i - 1].trueMinRowHeight < 23) {
                rowHeights[i - 1].trueMinRowHeight = 23;
            }
            ++i;
        }
    }

    private void initRowMinSize(List children) {
        int size = children.size();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            FigureInfomation info = this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int columnNumber = info.columnNumber;
            int rowSpan = info.rowSpan;
            int columnSpan = info.columnSpan;
            TableLayoutData.RowData rowData = this.data.findRowData(rowNumber);
            TableLayoutData.ColumnData columnData = this.data.findColumnData(columnNumber);
            int colWidth = columnData.width;
            if (columnSpan > 1) {
                int k = 1;
                while (k < columnSpan) {
                    TableLayoutData.ColumnData cData = this.data.findColumnData(columnNumber + k);
                    if (cData != null) {
                        colWidth += cData.width;
                    }
                    ++k;
                }
            }
            Dimension dim = figure.getMinimumSize(colWidth, -1);
            if (dim.height > rowData.minRowHeight && rowSpan == 1) {
                rowData.minRowHeight = dim.height;
            }
            if (dim.height > rowData.trueMinRowHeight && rowSpan == 1) {
                rowData.trueMinRowHeight = dim.height;
                rowData.isSetting = true;
            }
            ++i;
        }
    }

    private void initRowMergeMinsize(List children) {
        int size = children.size();
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        ArrayList<Integer> adjustRow = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            FigureInfomation info = this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int rowSpan = info.rowSpan;
            if (rowSpan != 1) {
                list.add(figure);
                if (rowSpan > 1) {
                    int j = rowNumber;
                    while (j < rowNumber + rowSpan) {
                        adjustRow.add(j);
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.caleRowMergeMinHeight(list, adjustRow, new ArrayList());
    }

    private void caleRowMergeMinHeight(List figures, List adjust, List hasAdjust) {
        if (adjust.isEmpty()) {
            return;
        }
        int size = figures.size();
        int adjustMax = 0;
        int trueAdjustMax = 0;
        int adjustMaxNumber = 0;
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)figures.get(i);
            FigureInfomation info = this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int columnNumber = info.columnNumber;
            int rowSpan = info.rowSpan;
            Dimension minSize = figure.getMinimumSize(this.data.findColumnData((int)columnNumber).width, -1);
            int samMin = 0;
            int trueSamMin = 0;
            int[] adjustNumber = new int[]{};
            int j = rowNumber;
            while (j < rowNumber + rowSpan) {
                TableLayoutData.RowData rowData = this.data.findRowData(j);
                if (!hasAdjust.contains(j)) {
                    int len = adjustNumber.length;
                    int[] temp = new int[len + 1];
                    System.arraycopy(adjustNumber, 0, temp, 0, len);
                    temp[len] = j;
                    adjustNumber = temp;
                } else {
                    samMin += rowData.trueMinRowHeight;
                    trueSamMin += rowData.trueMinRowHeight;
                }
                ++j;
            }
            int adjustCount = adjustNumber.length;
            if (adjustCount != 0) {
                int value = minSize.height - samMin;
                int trueValue = minSize.height - trueSamMin;
                int j2 = 0;
                while (j2 < adjustCount) {
                    int temp = 0;
                    int trueTemp = 0;
                    if (j2 == adjustCount - 1) {
                        temp = value / adjustCount + value % adjustCount;
                        trueTemp = trueValue / adjustCount + trueValue % adjustCount;
                    } else {
                        temp = value / adjustCount;
                        trueTemp = trueValue / adjustCount;
                    }
                    TableLayoutData.RowData rowData = this.data.findRowData(adjustNumber[j2]);
                    temp = Math.max(temp, rowData.minRowHeight);
                    trueTemp = Math.max(trueTemp, rowData.trueMinRowHeight);
                    if (trueTemp > trueAdjustMax) {
                        adjustMax = temp;
                        trueAdjustMax = trueTemp;
                        adjustMaxNumber = adjustNumber[j2];
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (adjustMaxNumber > 0) {
            TableLayoutData.RowData rowData = this.data.findRowData(adjustMaxNumber);
            rowData.minRowHeight = adjustMax;
            rowData.trueMinRowHeight = trueAdjustMax;
            adjust.remove((Object)adjustMaxNumber);
            hasAdjust.add(adjustMaxNumber);
            this.caleMergeMinHeight(figures, adjust, hasAdjust);
        }
    }

    private void caleRowData() {
        if (this.data == null) {
            return;
        }
        int size = this.data.rowHeights.length;
        int[] dxRows = new int[size];
        int dxTotal = 0;
        int i = 0;
        while (i < size) {
            dxRows[i] = this.data.rowHeights[i].height - this.data.rowHeights[i].trueMinRowHeight;
            dxTotal += dxRows[i];
            ++i;
        }
        i = 0;
        while (i < size) {
            if (dxRows[i] < 0) {
                this.data.rowHeights[i].height = this.data.rowHeights[i].trueMinRowHeight;
            }
            ++i;
        }
    }

    private void caleLayoutData(IFigure container) {
        if (this.data == null) {
            return;
        }
        int size = this.data.rowHeights.length;
        int[] dxRows = new int[size];
        int dxTotal = 0;
        int i = 0;
        while (i < size) {
            dxRows[i] = this.data.rowHeights[i].height - this.data.rowHeights[i].trueMinRowHeight;
            dxTotal += dxRows[i];
            ++i;
        }
        i = 0;
        while (i < size) {
            if (dxRows[i] < 0) {
                this.data.rowHeights[i].height = this.data.rowHeights[i].trueMinRowHeight;
            }
            ++i;
        }
        size = this.data.columnWidths.length;
        int containerWidth = this.getLayoutWidth();
        containerWidth = Math.max(0, containerWidth);
        String[] definedWidth = new String[size];
        int i2 = 1;
        while (i2 < size + 1) {
            definedWidth[i2 - 1] = this.getOwner().getRawWidth(i2);
            ++i2;
        }
        FixTableLayoutCalculator calculator = new FixTableLayoutCalculator();
        calculator.setTableWidth((float)containerWidth);
        calculator.setColMinSize(20.0f);
        calculator.setDefinedColWidth(definedWidth);
        TableLayoutHelper.calculateColumnWidth(this.data.columnWidths, containerWidth, (ITableLayoutCalculator)calculator);
    }

    Insets getFigureMargin(IFigure f) {
        if (f instanceof IReportElementFigure) {
            return ((IReportElementFigure)f).getMargin();
        }
        return INSETS_SINGLETON;
    }

    private int getDefinedWidth(String dw, int cw) {
        if (dw == null || dw.length() == 0) {
            return 0;
        }
        try {
            if (dw.endsWith("%")) {
                return (int)(Double.parseDouble(dw.substring(0, dw.length() - 1)) * (double)cw / 100.0);
            }
            return (int)Double.parseDouble(dw);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void initMinSize(List children) {
        int size = children.size();
        Map map = this.getOwner().getViewer().getVisualPartMap();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            ITableLayoutCell cellPart = (ITableLayoutCell)map.get(figure);
            int rowNumber = cellPart.getRowNumber();
            int columnNumber = cellPart.getColumnNumber();
            int rowSpan = cellPart.getRowSpan();
            int columnSpan = cellPart.getColSpan();
            FigureInfomation info = new FigureInfomation();
            info.rowNumber = rowNumber;
            info.columnNumber = columnNumber;
            info.rowSpan = rowSpan;
            info.columnSpan = columnSpan;
            this.figureInfo.put(figure, info);
            Dimension dim = figure.getMinimumSize();
            TableLayoutData.RowData rowData = this.data.findRowData(rowNumber);
            TableLayoutData.ColumnData columnData = this.data.findColumnData(columnNumber);
            if (dim.height > rowData.minRowHeight && rowSpan == 1) {
                rowData.minRowHeight = dim.height;
            }
            if (dim.height > rowData.trueMinRowHeight && rowSpan == 1) {
                rowData.trueMinRowHeight = dim.height;
                rowData.isSetting = true;
            }
            if (dim.width > columnData.minColumnWidth && columnSpan == 1) {
                columnData.minColumnWidth = dim.width;
            }
            if (dim.width > columnData.trueMinColumnWidth && columnSpan == 1) {
                columnData.trueMinColumnWidth = dim.width;
                columnData.isSetting = true;
            }
            ++i;
        }
    }

    private void initMergeMinsize(List children) {
        int size = children.size();
        ArrayList<IFigure> list = new ArrayList<IFigure>();
        ArrayList<Integer> adjustRow = new ArrayList<Integer>();
        ArrayList<Integer> adjustColumn = new ArrayList<Integer>();
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)children.get(i);
            FigureInfomation info = this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int columnNumber = info.columnNumber;
            int rowSpan = info.rowSpan;
            int columnSpan = info.columnSpan;
            if (rowSpan != 1 || columnSpan != 1) {
                int j;
                list.add(figure);
                if (rowSpan > 1) {
                    j = rowNumber;
                    while (j < rowNumber + rowSpan) {
                        adjustRow.add(j);
                        ++j;
                    }
                }
                if (columnSpan > 1) {
                    j = columnNumber;
                    while (j < columnNumber + columnSpan) {
                        adjustColumn.add(j);
                        ++j;
                    }
                }
            }
            ++i;
        }
        this.caleMergeMinHeight(list, adjustRow, new ArrayList());
        this.caleMergeMinWidth(list, adjustColumn, new ArrayList());
    }

    private void caleMergeMinHeight(List figures, List adjust, List hasAdjust) {
        if (adjust.isEmpty()) {
            return;
        }
        int size = figures.size();
        int adjustMax = 0;
        int trueAdjustMax = 0;
        int adjustMaxNumber = 0;
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)figures.get(i);
            FigureInfomation info = this.figureInfo.get(figure);
            int rowNumber = info.rowNumber;
            int rowSpan = info.rowSpan;
            Dimension minSize = figure.getMinimumSize(this.data.findColumnData((int)info.columnNumber).width, -1);
            int samMin = 0;
            int trueSamMin = 0;
            int[] adjustNumber = new int[]{};
            int j = rowNumber;
            while (j < rowNumber + rowSpan) {
                TableLayoutData.RowData rowData = this.data.findRowData(j);
                if (!hasAdjust.contains(j)) {
                    int len = adjustNumber.length;
                    int[] temp = new int[len + 1];
                    System.arraycopy(adjustNumber, 0, temp, 0, len);
                    temp[len] = j;
                    adjustNumber = temp;
                } else {
                    samMin += rowData.trueMinRowHeight;
                    trueSamMin += rowData.trueMinRowHeight;
                }
                ++j;
            }
            int adjustCount = adjustNumber.length;
            if (adjustCount != 0) {
                int value = minSize.height - samMin;
                int trueValue = minSize.height - trueSamMin;
                int j2 = 0;
                while (j2 < adjustCount) {
                    int temp = 0;
                    int trueTemp = 0;
                    if (j2 == adjustCount - 1) {
                        temp = value / adjustCount + value % adjustCount;
                        trueTemp = trueValue / adjustCount + trueValue % adjustCount;
                    } else {
                        temp = value / adjustCount;
                        trueTemp = trueValue / adjustCount;
                    }
                    TableLayoutData.RowData rowData = this.data.findRowData(adjustNumber[j2]);
                    temp = Math.max(temp, rowData.minRowHeight);
                    trueTemp = Math.max(trueTemp, rowData.trueMinRowHeight);
                    if (trueTemp > trueAdjustMax) {
                        adjustMax = temp;
                        trueAdjustMax = trueTemp;
                        adjustMaxNumber = adjustNumber[j2];
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (adjustMaxNumber > 0) {
            TableLayoutData.RowData rowData = this.data.findRowData(adjustMaxNumber);
            rowData.minRowHeight = adjustMax;
            rowData.trueMinRowHeight = trueAdjustMax;
            adjust.remove((Object)adjustMaxNumber);
            hasAdjust.add(adjustMaxNumber);
            this.caleMergeMinHeight(figures, adjust, hasAdjust);
        }
    }

    private void caleMergeMinWidth(List figures, List adjust, List hasAdjust) {
        if (adjust.isEmpty()) {
            return;
        }
        int size = figures.size();
        int adjustMax = 0;
        int trueAdjustMax = 0;
        int adjustMaxNumber = 0;
        int i = 0;
        while (i < size) {
            IFigure figure = (IFigure)figures.get(i);
            FigureInfomation info = this.figureInfo.get(figure);
            int columnNumber = info.columnNumber;
            int columnSpan = info.columnSpan;
            Dimension minSize = figure.getMinimumSize();
            int samMin = 0;
            int trueSamMin = 0;
            int[] adjustNumber = new int[]{};
            int j = columnNumber;
            while (j < columnNumber + columnSpan) {
                TableLayoutData.ColumnData columnData = this.data.findColumnData(j);
                if (!hasAdjust.contains(j)) {
                    int len = adjustNumber.length;
                    int[] temp = new int[len + 1];
                    System.arraycopy(adjustNumber, 0, temp, 0, len);
                    temp[len] = j;
                    adjustNumber = temp;
                } else {
                    samMin += columnData.trueMinColumnWidth;
                    trueSamMin += columnData.trueMinColumnWidth;
                }
                ++j;
            }
            int adjustCount = adjustNumber.length;
            if (adjustCount != 0) {
                int value = minSize.width - samMin;
                int trueValue = minSize.width - trueSamMin;
                int j2 = 0;
                while (j2 < adjustCount) {
                    int temp = 0;
                    int trueTemp = 0;
                    if (j2 == adjustCount - 1) {
                        temp = value / adjustCount + value % adjustCount;
                        trueTemp = trueValue / adjustCount + trueValue % adjustCount;
                    } else {
                        temp = value / adjustCount;
                        trueTemp = trueValue / adjustCount;
                    }
                    TableLayoutData.ColumnData columnData = this.data.findColumnData(adjustNumber[j2]);
                    temp = Math.max(temp, columnData.minColumnWidth);
                    trueTemp = Math.max(trueTemp, columnData.trueMinColumnWidth);
                    if (trueTemp > trueAdjustMax) {
                        adjustMax = temp;
                        trueAdjustMax = trueTemp;
                        adjustMaxNumber = adjustNumber[j2];
                    }
                    ++j2;
                }
            }
            ++i;
        }
        if (adjustMaxNumber > 0) {
            TableLayoutData.ColumnData columnData = this.data.findColumnData(adjustMaxNumber);
            columnData.minColumnWidth = adjustMax;
            columnData.trueMinColumnWidth = trueAdjustMax;
            adjust.remove((Object)adjustMaxNumber);
            hasAdjust.add(adjustMaxNumber);
            this.caleMergeMinWidth(figures, adjust, hasAdjust);
        }
    }

    private void init(TableLayoutData.ColumnData[] columnWidths, TableLayoutData.RowData[] rowHeights) {
        ITableLayoutOwner.DimensionInfomation dim;
        int size = rowHeights.length;
        int i = 1;
        while (i < size + 1) {
            rowHeights[i - 1] = new TableLayoutData.RowData();
            rowHeights[i - 1].rowNumber = i;
            rowHeights[i - 1].height = this.getOwner().getRowHeightValue(i);
            dim = this.getOwner().getRowHeight(i);
            boolean bl = rowHeights[i - 1].isForce = dim.getMeasure() > 0.0;
            if ("%".equals(dim.getUnits()) && dim.getMeasure() > 0.0) {
                rowHeights[i - 1].isPercentage = true;
                rowHeights[i - 1].percentageHeight = dim.getMeasure();
            }
            if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                rowHeights[i - 1].isAuto = true;
            }
            int n = rowHeights[i - 1].trueMinRowHeight = rowHeights[i - 1].isForce && !rowHeights[i - 1].isPercentage ? rowHeights[i - 1].height : rowHeights[i - 1].minRowHeight;
            if (rowHeights[i - 1].trueMinRowHeight < 23) {
                rowHeights[i - 1].trueMinRowHeight = 23;
            }
            ++i;
        }
        size = columnWidths.length;
        i = 1;
        while (i < size + 1) {
            columnWidths[i - 1] = new TableLayoutData.ColumnData();
            columnWidths[i - 1].columnNumber = i;
            columnWidths[i - 1].width = this.getOwner().getColumnWidthValue(i);
            dim = this.getOwner().getColumnWidth(i);
            boolean bl = columnWidths[i - 1].isForce = dim.getMeasure() > 0.0;
            if ("%".equals(dim.getUnits()) && dim.getMeasure() > 0.0) {
                columnWidths[i - 1].isPercentage = true;
                columnWidths[i - 1].percentageWidth = dim.getMeasure();
            }
            if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                columnWidths[i - 1].isAuto = true;
            }
            columnWidths[i - 1].trueMinColumnWidth = columnWidths[i - 1].isForce && !columnWidths[i - 1].isPercentage ? columnWidths[i - 1].width : columnWidths[i - 1].minColumnWidth;
            ++i;
        }
    }

    public Object getConstraint(IFigure figure) {
        return this.constraints.get(figure);
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    public int getColumnCount() {
        return this.getOwner().getColumnCount();
    }

    public int getRowCount() {
        return this.getOwner().getRowCount();
    }

    public ITableLayoutOwner getOwner() {
        return this.owner;
    }

    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        this.isCalculating = true;
        this.layout(figure, true);
        this.isCalculating = false;
        IFigure table = figure.getParent().getParent().getParent();
        int widthExpand = table.getInsets().getWidth();
        int width = 0;
        int size = this.data.columnWidths.length;
        int i = 0;
        while (i < size) {
            width += this.data.columnWidths[i].trueMinColumnWidth;
            ++i;
        }
        String ww = this.getOwner().getDefinedWidth();
        if (ww != null && ww.length() > 0 && !ww.endsWith("%")) {
            try {
                int dwidth = Integer.parseInt(ww);
                if (dwidth > width + widthExpand) {
                    width = dwidth - widthExpand;
                }
            }
            catch (Exception exception) {}
        }
        int height = 0;
        size = this.data.rowHeights.length;
        int i2 = 0;
        while (i2 < size) {
            height += this.data.rowHeights[i2].height;
            ++i2;
        }
        Dimension dim = new Dimension(width, height);
        return dim.expand(table.getInsets().getWidth(), table.getInsets().getHeight());
    }

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.calculateMinimumSize(container, wHint, hHint);
    }

    protected boolean isDistroy() {
        if (this.owner instanceof ReportElementEditPart && ((ReportElementEditPart)((Object)this.owner)).isDelete()) {
            return false;
        }
        return (this.data == null || this.data.columnWidths == null || this.data.columnWidths.length != this.getColumnCount() || this.data.rowHeights == null || this.data.rowHeights.length != this.getRowCount() || this.needlayout) && this.owner.isActive();
    }

    protected int getLayoutWidth() {
        int containerWidth = this.getOwner().getFigure().getParent().getClientArea().getSize().width;
        containerWidth -= this.getFigureMargin(this.getOwner().getFigure()).getWidth();
        String ww = this.getOwner().getDefinedWidth();
        containerWidth = this.getDefinedWidth(ww, containerWidth);
        int padding = this.getOwner().getFigure().getBorder().getInsets(this.getOwner().getFigure()).getWidth();
        return containerWidth -= padding;
    }

    static class FigureInfomation {
        public int rowNumber;
        public int columnNumber;
        public int rowSpan;
        public int columnSpan;

        FigureInfomation() {
        }
    }

    public static class WorkingData {
        public TableLayoutData.ColumnData[] columnWidths;
        public TableLayoutData.RowData[] rowHeights;

        public TableLayoutData.RowData findRowData(int number) {
            return this.rowHeights[number - 1];
        }

        public TableLayoutData.ColumnData findColumnData(int number) {
            return this.columnWidths[number - 1];
        }
    }
}

