/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferencePage;
import org.eclipse.corrosion.RustManager;
import org.eclipse.jface.preference.IPreferenceStore;

public class CorrosionPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final IPreferenceStore STORE = CorrosionPlugin.getDefault().getPreferenceStore();
    private static final String CARGO_DEFAULT_HOME = String.valueOf(System.getProperty("user.home")) + "/.cargo/bin/";
    private static final boolean IS_WINDOWS = Platform.getOS().equals("win32");
    public static final String RUST_SOURCE_PREFERENCE = "corrosion.rustSource";
    public static final String DEFAULT_PATHS_PREFERENCE = "corrosion.rustup_defaultPaths";
    public static final String RUSTUP_PATHS_PREFERENCE = "corrosion.rustup_rustupPath";
    public static final String CARGO_PATH_PREFERENCE = "corrosion.rustup_cargoPath";
    public static final String TOOLCHAIN_ID_PREFERENCE = "corrosion.rustup_toolchain_Id";
    public static final String TOOLCHAIN_TYPE_PREFERENCE = "corrosion.rustup_toolchain_type";
    public static final String RLS_PATH_PREFERENCE = "corrosion.rslPath";
    public static final String SYSROOT_PATH_PREFERENCE = "corrosion.sysrootPath";
    public static final String WORKING_DIRECTORY_PREFERENCE = "corrosion.workingDirectory";

    public void initializeDefaultPreferences() {
        STORE.setDefault(RUST_SOURCE_PREFERENCE, "rustup");
        STORE.setDefault(DEFAULT_PATHS_PREFERENCE, true);
        STORE.setDefault(RUSTUP_PATHS_PREFERENCE, this.getRustupPathBestGuess());
        STORE.setDefault(CARGO_PATH_PREFERENCE, this.getCargoPathBestGuess());
        this.setToolchainBestGuesses();
        STORE.setDefault(RLS_PATH_PREFERENCE, this.getRLSPathBestGuess());
        STORE.setDefault(SYSROOT_PATH_PREFERENCE, this.getSysrootPathBestGuess());
        STORE.setDefault(WORKING_DIRECTORY_PREFERENCE, this.getWorkingDirectoryBestGuess());
    }

    private String getRustupPathBestGuess() {
        File possibleCommandFile;
        String command = this.findCommandPath("rustup");
        if (command.isEmpty() && (possibleCommandFile = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("rustup")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private String getCargoPathBestGuess() {
        File possibleCommandFile;
        String command = this.findCommandPath("cargo");
        if (command.isEmpty() && (possibleCommandFile = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("cargo")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private String findCommandPath(String command) {
        return CorrosionPlugin.getOutputFromCommand(IS_WINDOWS ? "where" : "which", command);
    }

    private void setToolchainBestGuesses() {
        String toolchain = RustManager.getDefaultToolchain();
        if (toolchain == null || toolchain.isEmpty()) {
            STORE.setDefault(TOOLCHAIN_ID_PREFERENCE, "");
            STORE.setDefault(TOOLCHAIN_TYPE_PREFERENCE, "Other");
            return;
        }
        int splitIndex = toolchain.indexOf(45);
        if (splitIndex != -1) {
            String type = toolchain.substring(0, splitIndex);
            if ("nightly".equals(type)) {
                STORE.setDefault(TOOLCHAIN_ID_PREFERENCE, toolchain);
                STORE.setDefault(TOOLCHAIN_TYPE_PREFERENCE, "Nightly");
            } else {
                for (String option : CorrosionPreferencePage.RUSTUP_TOOLCHAIN_OPTIONS) {
                    if (!option.equalsIgnoreCase(type)) continue;
                    STORE.setDefault(TOOLCHAIN_ID_PREFERENCE, type);
                    STORE.setDefault(TOOLCHAIN_TYPE_PREFERENCE, option);
                }
            }
            return;
        }
        STORE.setDefault(TOOLCHAIN_ID_PREFERENCE, toolchain.trim());
        STORE.setDefault(TOOLCHAIN_TYPE_PREFERENCE, "Other");
    }

    private String getRLSPathBestGuess() {
        File possibleCommandFile;
        String command = this.findCommandPath("rls");
        if (command.isEmpty() && (possibleCommandFile = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("rls")).exists() && possibleCommandFile.isFile() && possibleCommandFile.canExecute()) {
            return possibleCommandFile.getAbsolutePath();
        }
        return command;
    }

    private String getSysrootPathBestGuess() {
        File rustc = new File(this.findCommandPath("rustc"));
        if (!(rustc.exists() && rustc.isFile() && rustc.canExecute())) {
            rustc = CorrosionPreferenceInitializer.getExectuableFileOfCargoDefaultHome("rustc");
        }
        if (!(rustc.exists() && rustc.isFile() && rustc.canExecute())) {
            return "";
        }
        String[] command = new String[]{rustc.getAbsolutePath(), "--print", "sysroot"};
        return CorrosionPlugin.getOutputFromCommand(command);
    }

    private static File getExectuableFileOfCargoDefaultHome(String executable) {
        return new File(String.valueOf(CARGO_DEFAULT_HOME) + executable + (IS_WINDOWS ? ".exe" : ""));
    }

    private String getWorkingDirectoryBestGuess() {
        return CorrosionPlugin.getOutputFromCommand(IS_WINDOWS ? "cd" : "pwd");
    }
}

