/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.corrosion.CommandJob;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferencePage;
import org.eclipse.corrosion.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class RustManager {
    private static final IPreferenceStore STORE = CorrosionPlugin.getDefault().getPreferenceStore();
    public static final String RLS_VERSION_FORMAT_REGEX = "^rls.*$";
    public static final String CARGO_VERSION_FORMAT_REGEX = "^cargo .*$";
    public static final String RUSTUP_VERSION_FORMAT_REGEX = "^rustup .*$";
    public static final Pattern RLS_VERSION_FORMAT_PATTERN = Pattern.compile("^rls.*$");
    public static final Pattern CARGO_VERSION_FORMAT_PATTERN = Pattern.compile("^cargo .*$");
    public static final Pattern RUSTUP_VERSION_FORMAT_PATTERN = Pattern.compile("^rustup .*$");
    private static Job settingToolchainJob = null;

    private RustManager() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Unable to fully structure code
     */
    public static String getDefaultToolchain() {
        block20: {
            rustup = RustManager.STORE.getString("corrosion.rustup_rustupPath");
            emptyResult = "";
            if (rustup.isEmpty()) {
                return "";
            }
            process = CorrosionPlugin.getProcessForCommand(new String[]{rustup, "show"});
            if (process.waitFor() == 0) break block20;
            return "";
        }
        try {
            var3_5 = null;
            var4_7 = null;
            try {
                in = new BufferedReader(new InputStreamReader(process.getInputStream()));
                try {
                    line = in.readLine();
                    while (true) {
                        if (line.matches("^.*\\(default\\)$")) {
                            if (line.matches("^nightly-\\d{4}-\\d{2}-\\d{2}.*$")) {
                                return line.substring(0, 18);
                            }
                            splitIndex = line.indexOf(45);
                            if (splitIndex != -1) {
                                return line.substring(0, splitIndex);
                            }
                            return line;
                        }
                        line = in.readLine();
                        return line;
                    }
                }
                finally {
                    if (line != null) ** continue;
                }
            }
            catch (Throwable var4_8) {
                if (var3_5 == null) {
                    var3_5 = var4_8;
                } else if (var3_5 != var4_8) {
                    var3_5.addSuppressed(var4_8);
                }
                throw var3_5;
            }
        }
        catch (IOException e) {
            CorrosionPlugin.logError(e);
            return "";
        }
        catch (InterruptedException e) {
            CorrosionPlugin.logError(e);
            Thread.currentThread().interrupt();
        }
        return "";
    }

    public static synchronized Job setDefaultToolchain(final String toolchainId) {
        if (settingToolchainJob != null) {
            settingToolchainJob.cancel();
        }
        settingToolchainJob = new Job(Messages.RustManager_settingRLSToolchain){
            CommandJob currentCommandJob;

            protected IStatus run(IProgressMonitor monitor) {
                ArrayList<CommandJob> jobs = new ArrayList<CommandJob>();
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_installingToolchain, NLS.bind((String)Messages.RustManager_unableToInstallToolchain, (Object)toolchainId), new String[]{"toolchain", "install", toolchainId}));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_settingDefaultToolchain, NLS.bind((String)Messages.RustManager_unableToSetDefaultToolchain, (Object)toolchainId), new String[]{"default", toolchainId}));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_addingRLSPrevios, NLS.bind((String)Messages.RustManager_toolchainDoesntIncludeRLS, (Object)toolchainId), new String[]{"component", "add", "rls-preview"}));
                jobs.add(RustManager.createRustupCommandJob(Messages.RustManager_addingRustAnalysisRustSrc, Messages.RustManager_unableToAddComponent, new String[]{"component", "add", "rust-analysis"}));
                Iterator iterator = jobs.iterator();
                while (iterator.hasNext()) {
                    CommandJob commandJob;
                    this.currentCommandJob = commandJob = (CommandJob)((Object)iterator.next());
                    if (this.currentCommandJob.run(monitor) == Status.CANCEL_STATUS) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.worked(1);
                }
                HashMap<String, String> updatedSettings = new HashMap<String, String>();
                updatedSettings.put("target", toolchainId);
                RustManager.sendDidChangeConfigurationsMessage(updatedSettings);
                return Status.OK_STATUS;
            }

            protected void canceling() {
                if (this.currentCommandJob != null) {
                    this.currentCommandJob.cancel();
                }
            }
        };
        settingToolchainJob.schedule();
        return settingToolchainJob;
    }

    private static void sendDidChangeConfigurationsMessage(Map<String, String> updatedSettings) {
        DidChangeConfigurationParams params = new DidChangeConfigurationParams();
        params.setSettings(updatedSettings);
        LanguageServiceAccessor.LSPDocumentInfo info = RustManager.infoFromOpenEditors();
        if (info != null) {
            info.getInitializedLanguageClient().thenAccept(languageServer -> languageServer.getWorkspaceService().didChangeConfiguration(params));
        }
    }

    private static CommandJob createRustupCommandJob(String progressMessage, String errorMessage, String ... arguments) {
        String rustup = STORE.getString("corrosion.rustup_rustupPath");
        if (rustup.isEmpty()) {
            return null;
        }
        String[] command = new String[arguments.length + 1];
        command[0] = rustup;
        System.arraycopy(arguments, 0, command, 1, arguments.length);
        return new CommandJob(command, progressMessage, Messages.RustManager_rootToolchainSelectionFailure, errorMessage, 0);
    }

    private static LanguageServiceAccessor.LSPDocumentInfo infoFromOpenEditors() {
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                int n5 = iEditorReferenceArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    block6: {
                        IDocument document;
                        List infos;
                        IEditorInput input;
                        IEditorReference editor = iEditorReferenceArray[n6];
                        try {
                            input = editor.getEditorInput();
                        }
                        catch (PartInitException e) {
                            break block6;
                        }
                        if (input.getName().endsWith(".rs") && editor.getEditor(false) instanceof ITextEditor && !(infos = LanguageServiceAccessor.getLSPDocumentInfosFor((IDocument)(document = ((ITextEditor)editor.getEditor(false)).getDocumentProvider().getDocument((Object)input)), capabilities -> Boolean.TRUE.equals(capabilities.getReferencesProvider()))).isEmpty()) {
                            return (LanguageServiceAccessor.LSPDocumentInfo)infos.iterator().next();
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static List<String> getToolchains() {
        ArrayList<String> toolchainsList = new ArrayList<String>();
        String rustup = STORE.getString("corrosion.rustup_rustupPath");
        if (rustup.isEmpty()) {
            return toolchainsList;
        }
        try {
            Process process = CorrosionPlugin.getProcessForCommand(rustup, "show");
            if (process.waitFor() != 0) {
                return toolchainsList;
            }
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = in.readLine();
                while (line != null && !line.equals("active toolchain")) {
                    int splitIndex;
                    String toolchain = "";
                    if (line.matches("^nightly-\\d{4}-\\d{2}-\\d{2}.*$")) {
                        toolchain = line.substring(0, 18);
                    } else if (line.matches("\\w+\\-.*") && (splitIndex = line.indexOf(45)) != -1) {
                        toolchain = line.substring(0, splitIndex);
                    }
                    if (!toolchain.isEmpty()) {
                        toolchainsList.add(toolchain);
                    }
                    line = in.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            CorrosionPlugin.logError(e);
        }
        return toolchainsList;
    }

    public static boolean setSystemProperties() {
        CorrosionPlugin plugin = CorrosionPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        int rustSourceIndex = CorrosionPreferencePage.RUST_SOURCE_OPTIONS.indexOf(preferenceStore.getString("corrosion.rustSource"));
        String sysrootPath = "";
        if (rustSourceIndex == 0) {
            String rustup = preferenceStore.getString("corrosion.rustup_rustupPath");
            String toolchain = preferenceStore.getString("corrosion.rustup_toolchain_Id");
            if (!rustup.isEmpty() && !toolchain.isEmpty()) {
                String[] command = new String[]{rustup, "run", toolchain, "rustc", "--print", "sysroot"};
                sysrootPath = CorrosionPlugin.getOutputFromCommand(command);
            }
        } else if (rustSourceIndex == 1) {
            sysrootPath = preferenceStore.getString("corrosion.sysrootPath");
        }
        if (sysrootPath != null && !sysrootPath.isEmpty()) {
            System.setProperty("SYS_ROOT", sysrootPath);
            System.setProperty("LD_LIBRARY_PATH", String.valueOf(sysrootPath) + "/lib");
            String sysRoot = System.getProperty("SYS_ROOT");
            String ldLibraryPath = System.getProperty("LD_LIBRARY_PATH");
            if (sysRoot != null && !sysRoot.isEmpty() && ldLibraryPath != null && !ldLibraryPath.isEmpty()) {
                return true;
            }
        }
        CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(4, CorrosionPlugin.getDefault().getBundle().getSymbolicName(), Messages.RLSStreamConnectionProvider_unableToSet));
        return false;
    }

    public static String getRLS() {
        CorrosionPlugin plugin = CorrosionPlugin.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        int rustSourceIndex = CorrosionPreferencePage.RUST_SOURCE_OPTIONS.indexOf(preferenceStore.getString("corrosion.rustSource"));
        String rlsPath = "";
        if (rustSourceIndex == 0) {
            String rustup = preferenceStore.getString("corrosion.rustup_rustupPath");
            rlsPath = CorrosionPlugin.getOutputFromCommand(String.valueOf(rustup) + " which rls");
        } else if (rustSourceIndex == 1) {
            rlsPath = preferenceStore.getString("corrosion.rslPath");
        }
        if (rlsPath.isEmpty()) {
            CorrosionPlugin.getDefault().getLog().log((IStatus)new Status(4, CorrosionPlugin.getDefault().getBundle().getSymbolicName(), Messages.RLSStreamConnectionProvider_rlsNotFound));
        }
        return rlsPath;
    }
}

