/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.wizards.newproject;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoTools;
import org.eclipse.corrosion.wizards.newproject.NewCargoProjectWizardPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class NewCargoProjectWizard
extends Wizard
implements INewWizard {
    private NewCargoProjectWizardPage wizardPage;
    public static final String ID = "org.eclipse.corrosion.wizards.newCargo";

    public NewCargoProjectWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.wizardPage = new NewCargoProjectWizardPage();
        this.setWindowTitle(Messages.NewCargoProjectWizard_title);
        Iterator selectionIterator = selection.iterator();
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>();
        IResource selectedResource = null;
        while (selectionIterator.hasNext()) {
            Object element = selectionIterator.next();
            IResource asResource = this.toResource(element);
            if (asResource != null && selectedResource == null) {
                selectedResource = asResource;
                continue;
            }
            IWorkingSet asWorkingSet = (IWorkingSet)Adapters.adapt(element, IWorkingSet.class);
            if (asWorkingSet == null) continue;
            workingSets.add(asWorkingSet);
        }
        if (workingSets.isEmpty() && selectedResource != null) {
            workingSets.addAll(this.getWorkingSets(selectedResource));
        }
        this.wizardPage.setWorkingSets(workingSets);
        if (selectedResource != null) {
            this.wizardPage.setDirectory(this.toFile(selectedResource));
        } else {
            this.wizardPage.setDirectory(this.newFolderLocation());
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.wizardPage);
    }

    public boolean performFinish() {
        File location = this.wizardPage.getDirectory();
        String projectName = this.wizardPage.getProjectName();
        Boolean isBin = this.wizardPage.isBinaryTemplate();
        String vcs = this.wizardPage.getVCS();
        Boolean makeLocation = !location.exists();
        if (makeLocation.booleanValue()) {
            location.mkdirs();
        }
        try {
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask(Messages.NewCargoProjectWizard_task, 0);
                ArrayList<String> commandLine = new ArrayList<String>();
                commandLine.add(CargoTools.getCargoCommand());
                commandLine.add("init");
                commandLine.add("--name");
                commandLine.add(projectName);
                commandLine.add("--vcs");
                commandLine.add(vcs);
                if (isBin.booleanValue()) {
                    commandLine.add("--bin");
                } else {
                    commandLine.add("--lib");
                }
                ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
                processBuilder.directory(location);
                try {
                    Process process = processBuilder.start();
                    boolean isProcessDone = false;
                    while (!isProcessDone) {
                        if (monitor.isCanceled()) {
                            process.destroyForcibly();
                        }
                        isProcessDone = process.waitFor(100L, TimeUnit.MILLISECONDS);
                    }
                    if (process.exitValue() == 0) {
                        String mainFileName = isBin != false ? "main.rs" : "lib.rs";
                        this.createProject(projectName, location, mainFileName, monitor);
                    } else {
                        StringBuilder errorOutput = new StringBuilder();
                        Throwable throwable = null;
                        Object var13_16 = null;
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                            String errorLine;
                            while ((errorLine = in.readLine()) != null) {
                                errorOutput.append(String.valueOf(errorLine) + '\n');
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        String finalErrorOutput = errorOutput.toString();
                        Display.getDefault().asyncExec(() -> {
                            if (makeLocation.booleanValue() && !location.delete()) {
                                MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_cannotCreateRustProject, (String)NLS.bind((String)Messages.NewCargoProjectWizard_cannotCreateRustProject_commandFailedDetails_partialDeletion, (Object[])new String[]{location.getAbsolutePath(), String.join((CharSequence)" ", commandLine), finalErrorOutput}));
                            } else {
                                MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_cannotCreateRustProject, (String)NLS.bind((String)Messages.NewCargoProjectWizard_cannotCreateRustProject_commandFailedDetails, (Object)String.join((CharSequence)" ", commandLine), (Object)finalErrorOutput));
                            }
                        });
                    }
                    monitor.done();
                }
                catch (IOException e) {
                    monitor.done();
                    Display.getDefault().asyncExec(() -> {
                        if (makeLocation.booleanValue() && !location.delete()) {
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_cannotCreateRustProject, (String)NLS.bind((String)Messages.NewCargoProjectWizard_cannotCreateRustProject_partialDeletion, (Object)location.getAbsolutePath(), (Object)e.toString()));
                        } else {
                            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_cannotCreateRustProject, (String)e.toString());
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_cannotCreateRustProject, (String)e.toString());
            return false;
        }
        catch (InterruptedException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_cannotCreateRustProject, (String)e.toString());
            Thread.currentThread().interrupt();
            return false;
        }
        return true;
    }

    private void createProject(String name, File directory, String mainFileName, IProgressMonitor monitor) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(name);
        IProjectDescription description = root.getWorkspace().newProjectDescription(project.getName());
        description.setLocation(Path.fromOSString((String)directory.getAbsolutePath()));
        try {
            project.create(description, monitor);
            project.open(monitor);
            project.refreshLocal(2, monitor);
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_unableToLoadProjectDescriptor, (String)e.toString());
        }
        IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
        IFile rsPrgramFile = project.getFile("src/" + mainFileName);
        Display.getDefault().asyncExec(() -> {
            wsm.addToWorkingSets((IAdaptable)project, this.wizardPage.getWorkingSets());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                try {
                    if (rsPrgramFile.exists()) {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)rsPrgramFile);
                    }
                }
                catch (CoreException e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.NewCargoProjectWizard_cannotOpenProject, (String)e.toString());
                }
            }
        });
    }

    private File newFolderLocation() {
        IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        int appendedNumber = 0;
        File newFile = workspacePath.append("new_rust_project").toFile();
        while (newFile.isDirectory()) {
            newFile = workspacePath.append("new_rust_project_" + ++appendedNumber).toFile();
        }
        return newFile;
    }

    private Set<IWorkingSet> getWorkingSets(IResource resource) {
        IWorkingSet[] allWorkingSets = PlatformUI.getWorkbench().getWorkingSetManager().getAllWorkingSets();
        HashSet<IWorkingSet> fileWorkingSets = new HashSet<IWorkingSet>();
        IWorkingSet[] iWorkingSetArray = allWorkingSets;
        int n = allWorkingSets.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet iWorkingSet = iWorkingSetArray[n2];
            IAdaptable[] elements = iWorkingSet.getElements();
            if (Arrays.asList(elements).contains(resource.getProject())) {
                fileWorkingSets.add(iWorkingSet);
            }
            ++n2;
        }
        return fileWorkingSets;
    }

    private IResource toResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof IAdaptable) {
            return (IResource)((IAdaptable)o).getAdapter(IResource.class);
        }
        return null;
    }

    private File toFile(IResource r) {
        IPath location = r.getLocation();
        if (location != null && location.toFile().isFile()) {
            File parent = location.toFile().getParentFile();
            return parent == null ? null : parent.getAbsoluteFile();
        }
        return location == null ? null : location.toFile();
    }
}

