/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.commit;

import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.cdo.common.commit.CDOChangeKind;
import org.eclipse.emf.cdo.common.commit.CDOChangeKindProvider;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOChangeKindCache
extends HashMap<CDOID, CDOChangeKind>
implements CDOChangeKindProvider {
    private static final long serialVersionUID = 1L;

    public CDOChangeKindCache(CDOChangeSetData changeSetData) {
        List<CDOIDAndVersion> list;
        List<CDORevisionKey> changedObjects;
        List<CDOIDAndVersion> newObjects = changeSetData.getNewObjects();
        if (newObjects != null) {
            for (CDOIDAndVersion key : newObjects) {
                this.put(key.getID(), CDOChangeKind.NEW);
            }
        }
        if ((changedObjects = changeSetData.getChangedObjects()) != null) {
            for (CDOIDAndVersion cDOIDAndVersion : changedObjects) {
                this.put(cDOIDAndVersion.getID(), CDOChangeKind.CHANGED);
            }
        }
        if ((list = changeSetData.getDetachedObjects()) != null) {
            for (CDOIDAndVersion key : list) {
                this.put(key.getID(), CDOChangeKind.DETACHED);
            }
        }
    }

    @Override
    public CDOChangeKind getChangeKind(CDOID id) {
        return (CDOChangeKind)((Object)this.get(id));
    }
}

