/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.AbstractClassFile;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.ExternalAnnotationTracker;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementInfo;
import org.eclipse.jdt.internal.core.JavaModelCache;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeDescriptor;
import org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeFactory;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.core.OTModelManager;

public class ClassFile
extends AbstractClassFile
implements IOrdinaryClassFile {
    protected BinaryType binaryType = null;
    private IPath externalAnnotationBase;

    protected ClassFile(PackageFragment parent, String nameWithoutExtension) {
        super(parent, nameWithoutExtension);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        IBinaryType typeInfo = this.getBinaryTypeInfo();
        if (typeInfo == null) {
            info.setChildren(JavaElement.NO_ELEMENTS);
            return false;
        }
        IType type = this.getType(typeInfo.getEnclosingTypeName());
        OTModelManager.getSharedInstance().addUnopenedType(type);
        info.setChildren(new IJavaElement[]{type});
        newElements.put(type, typeInfo);
        ((ClassFileInfo)info).readBinaryChildren(this, (HashMap)newElements, typeInfo);
        return true;
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        String source = this.getSource();
        if (source != null) {
            BinaryType type = (BinaryType)this.getType();
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), null, type.sourceFileName((IBinaryType)type.getElementInfo()), this.getJavaProject());
            this.codeComplete(cu, cu, offset, requestor, owner, null, monitor);
        }
    }

    @Override
    public IJavaElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            BinaryType type = (BinaryType)this.getType();
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, null, type.sourceFileName((IBinaryType)type.getElementInfo()), this);
            return super.codeSelect(cu, offset, length, owner);
        }
        return new IJavaElement[0];
    }

    public boolean existsUsingJarTypeCache() {
        if (this.getPackageFragmentRoot().isArchive()) {
            IType type;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            Object info = manager.getInfo(type = this.getType());
            if (info == JavaModelCache.NON_EXISTING_JAR_TYPE_INFO) {
                return false;
            }
            if (info != null) {
                return true;
            }
            JavaElementInfo parentInfo = (JavaElementInfo)manager.getInfo(this.getParent());
            if (parentInfo != null) {
                IJavaElement[] children = parentInfo.getChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IJavaElement child = children[i];
                    if (child instanceof ClassFile && this.name.equals(((ClassFile)child).name)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            try {
                info = this.getJarBinaryTypeInfo();
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {
            }
            catch (ClassFormatException classFormatException) {}
            manager.putJarTypeInfo(type, info == null ? JavaModelCache.NON_EXISTING_JAR_TYPE_INFO : info);
            return info != null;
        }
        return this.exists();
    }

    @Override
    public IType findPrimaryType() {
        IType primaryType = this.getType();
        if (primaryType.exists()) {
            return primaryType;
        }
        return null;
    }

    @Override
    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        return this.getType().getAttachedJavadoc(monitor);
    }

    public IBinaryType getBinaryTypeInfo() throws JavaModelException {
        try {
            IBinaryType info = this.getJarBinaryTypeInfo();
            if (info == null) {
                throw this.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException cfe) {
            if (JavaCore.getPlugin().isDebugging()) {
                cfe.printStackTrace(System.err);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new JavaModelException(ioe, 985);
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    private IBinaryType getJarBinaryTypeInfo() throws CoreException, IOException, ClassFormatException {
        JavaProject javaProject;
        IClasspathEntry entry;
        BinaryTypeDescriptor descriptor = BinaryTypeFactory.createDescriptor(this);
        if (descriptor == null) {
            return null;
        }
        IBinaryType result = null;
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (this.getPackageFragmentRoot() instanceof JarPackageFragmentRoot) {
            if (root instanceof JrtPackageFragmentRoot || this.name.equals("module-info")) {
                String entryName;
                PackageFragment pkg = (PackageFragment)this.getParent();
                JarPackageFragmentRoot jarRoot = (JarPackageFragmentRoot)this.getPackageFragmentRoot();
                byte[] contents = this.getClassFileContent(jarRoot, entryName = jarRoot.getClassFilePath(Util.concatWith(pkg.names, this.getElementName(), '/')));
                if (contents != null) {
                    String fileName = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
                    result = new ClassFileReader(contents, fileName.toCharArray(), false);
                }
            } else {
                result = BinaryTypeFactory.readType(descriptor, null);
            }
        } else {
            result = BinaryTypeFactory.readType(descriptor, null);
        }
        if (result == null) {
            return null;
        }
        if (root.getKind() == 2 && (entry = (javaProject = (JavaProject)this.getAncestor(2)).getClasspathEntryFor(this.getPath())) != null) {
            PackageFragment pkg = (PackageFragment)this.getParent();
            String entryName = Util.concatWith(pkg.names, this.getElementName(), '/');
            entryName = new String(CharArrayUtils.concat(JavaNames.fieldDescriptorToBinaryName(descriptor.fieldDescriptor), SuffixConstants.SUFFIX_CLASS));
            IProject project = javaProject.getProject();
            IPath externalAnnotationPath = ClasspathEntry.getExternalAnnotationPath(entry, project, false);
            if (externalAnnotationPath != null) {
                result = this.setupExternalAnnotationProvider(project, externalAnnotationPath, result, entryName.substring(0, entryName.length() - SuffixConstants.SUFFIX_CLASS.length));
            } else if (entry.getEntryKind() == 3) {
                result = new ExternalAnnotationDecorator(result, true);
            }
        }
        return result;
    }

    private IBinaryType setupExternalAnnotationProvider(IProject project, final IPath externalAnnotationPath, IBinaryType reader, final String typeName) {
        String resolvedPath;
        IFolder resource;
        IBinaryType result = reader;
        IWorkspaceRoot root = project.getWorkspace().getRoot();
        if (externalAnnotationPath.segmentCount() == 1) {
            resource = root.getProject(externalAnnotationPath.lastSegment());
        } else {
            resource = root.getFolder(externalAnnotationPath);
            if (!resource.exists()) {
                resource = root.getFile(externalAnnotationPath);
            }
        }
        if (resource.exists()) {
            if (resource.isVirtual()) {
                Util.log((IStatus)new Status(4, "org.eclipse.jdt.core", "Virtual resource " + externalAnnotationPath + " cannot be used as annotationpath for project " + project.getName()));
                return reader;
            }
            resolvedPath = resource.getLocation().toString();
        } else {
            resolvedPath = externalAnnotationPath.toString();
        }
        ZipFile annotationZip = null;
        try {
            try {
                annotationZip = ExternalAnnotationDecorator.getAnnotationZipFile(resolvedPath, new ExternalAnnotationDecorator.ZipFileProducer(){

                    @Override
                    public ZipFile produce() throws IOException {
                        try {
                            return JavaModelManager.getJavaModelManager().getZipFile(externalAnnotationPath);
                        }
                        catch (CoreException e) {
                            throw new IOException("Failed to read annotation file for " + typeName + " from " + externalAnnotationPath.toString(), e);
                        }
                    }
                });
                ExternalAnnotationProvider annotationProvider = ExternalAnnotationDecorator.externalAnnotationProvider(resolvedPath, typeName, annotationZip);
                result = new ExternalAnnotationDecorator(reader, annotationProvider);
            }
            catch (IOException e) {
                Util.log(e);
                IBinaryType iBinaryType = result;
                if (annotationZip != null) {
                    JavaModelManager.getJavaModelManager().closeZipFile(annotationZip);
                }
                return iBinaryType;
            }
        }
        catch (Throwable throwable) {
            if (annotationZip != null) {
                JavaModelManager.getJavaModelManager().closeZipFile(annotationZip);
            }
            throw throwable;
        }
        if (annotationZip != null) {
            JavaModelManager.getJavaModelManager().closeZipFile(annotationZip);
        }
        if (annotationZip == null) {
            this.externalAnnotationBase = externalAnnotationPath;
            ExternalAnnotationTracker.registerClassFile(externalAnnotationPath, (IPath)new Path(typeName), this);
        }
        return result;
    }

    void closeAndRemoveFromJarTypeCache() throws JavaModelException {
        super.close();
        JavaModelManager.getJavaModelManager().removeFromJarTypeCache(this.binaryType);
    }

    @Override
    public void close() throws JavaModelException {
        if (this.externalAnnotationBase != null) {
            String entryName = Util.concatWith(((PackageFragment)this.getParent()).names, this.name, '/');
            ExternalAnnotationTracker.unregisterClassFile(this.externalAnnotationBase, (IPath)new Path(entryName));
        }
        super.close();
    }

    @Override
    public IClassFile getClassFile() {
        return this;
    }

    @Override
    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        IType type = this.getType();
        return this.findElement(type, position, mapper);
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                BinaryType type = new BinaryType(this, typeName);
                return type.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '(';
    }

    public String getTopLevelTypeName() {
        String topLevelTypeName = this.getElementName();
        int firstDollar = topLevelTypeName.indexOf(36);
        topLevelTypeName = firstDollar != -1 ? topLevelTypeName.substring(0, firstDollar) : topLevelTypeName.substring(0, topLevelTypeName.length() - SUFFIX_CLASS.length);
        return topLevelTypeName;
    }

    @Override
    public IType getType() {
        return this.getType(null);
    }

    IType getType(char[] enclosingTypeName) {
        if (this.binaryType == null) {
            block7: {
                int lastDollar;
                if (enclosingTypeName == null && (lastDollar = this.name.lastIndexOf(36)) != -1) {
                    String enclosingName = this.name.substring(0, lastDollar);
                    if ((lastDollar = enclosingName.lastIndexOf(36)) != -1) {
                        String previousSegment = enclosingName.substring(lastDollar + 1);
                        try {
                            Integer.parseInt(previousSegment);
                            break block7;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    String binaryParentName = this.parent.getElementName().replace('.', '/');
                    enclosingTypeName = (String.valueOf(binaryParentName) + '/' + enclosingName).toCharArray();
                }
            }
            this.binaryType = enclosingTypeName != null ? new BinaryType(enclosingTypeName, this, this.getTypeName()) : new BinaryType(this, this.getTypeName());
            OTModelManager.getSharedInstance().addUnopenedType(this.binaryType);
        } else if (enclosingTypeName != null) {
            this.binaryType.updateEnclosingTypeName(enclosingTypeName);
        }
        return this.binaryType;
    }

    public String getTypeName() {
        int lastDollar = this.name.lastIndexOf(36);
        return lastDollar > -1 ? Util.localTypeName(this.name, lastDollar, this.name.length()) : this.name;
    }

    @Override
    public ICompilationUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy, false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, null);
        op.runOperation(monitor);
        return workingCopy;
    }

    @Override
    public boolean isClass() throws JavaModelException {
        return this.getType().isClass();
    }

    @Override
    public boolean isInterface() throws JavaModelException {
        return this.getType().isInterface();
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IType outerMostEnclosingType = this.getOuterMostEnclosingType();
        IBuffer buffer = this.getBufferManager().getBuffer(outerMostEnclosingType.getClassFile());
        if (buffer == null) {
            IBinaryType typeInfo;
            SourceMapper mapper = this.getSourceMapper();
            IBinaryType iBinaryType = typeInfo = info instanceof IBinaryType ? (IBinaryType)info : null;
            if (mapper != null) {
                buffer = this.mapSource(mapper, typeInfo, outerMostEnclosingType.getClassFile());
            }
        }
        return buffer;
    }

    private IBuffer mapSource(SourceMapper mapper, IBinaryType info, IClassFile bufferOwner) {
        char[] contents = mapper.findSource(this.getType(), info);
        if (contents != null) {
            IBuffer buffer = BufferManager.createBuffer(bufferOwner);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            mapper.mapSource((NamedMember)((Object)this.getOuterMostEnclosingType()), contents, info);
            return buffer;
        }
        IBuffer buffer = BufferManager.createNullBuffer(bufferOwner);
        if (buffer == null) {
            return null;
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    static String simpleName(char[] className) {
        if (className == null) {
            return null;
        }
        String simpleName = new String(ClassFile.unqualifiedName(className));
        int lastDollar = simpleName.lastIndexOf(36);
        if (lastDollar != -1) {
            return Util.localTypeName(simpleName, lastDollar, simpleName.length());
        }
        return simpleName;
    }

    private IType getOuterMostEnclosingType() {
        IType type = this.getType();
        IType enclosingType = type.getDeclaringType();
        while (enclosingType != null) {
            type = enclosingType;
            enclosingType = type.getDeclaringType();
        }
        return type;
    }

    public static char[] translatedName(char[] name) {
        if (name == null) {
            return null;
        }
        int nameLength = name.length;
        char[] newName = new char[nameLength];
        int i = 0;
        while (i < nameLength) {
            newName[i] = name[i] == '/' ? 46 : name[i];
            ++i;
        }
        return newName;
    }

    static char[][] translatedNames(char[][] names) {
        if (names == null) {
            return null;
        }
        int length = names.length;
        char[][] newNames = new char[length][];
        int i = 0;
        while (i < length) {
            newNames[i] = ClassFile.translatedName(names[i]);
            ++i;
        }
        return newNames;
    }

    static char[] unqualifiedName(char[] className) {
        if (className == null) {
            return null;
        }
        int count = 0;
        int i = className.length - 1;
        while (i > -1) {
            if (className[i] == '/') {
                char[] name = new char[count];
                System.arraycopy(className, i + 1, name, 0, count);
                return name;
            }
            ++count;
            --i;
        }
        return className;
    }
}

