/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.linewrap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.eclipse.jdt.internal.formatter.TokenTraverser;

public class FieldAligner {
    private final List<List<FieldDeclaration>> fieldAlignGroups = new ArrayList<List<FieldDeclaration>>();
    private final DefaultCodeFormatterOptions options;
    final TokenManager tm;

    public FieldAligner(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    public void handleAlign(List<FieldDeclaration> bodyDeclarations) {
        if (!this.options.align_type_members_on_columns) {
            return;
        }
        ArrayList<FieldDeclaration> alignGroup = new ArrayList<FieldDeclaration>();
        BodyDeclaration previous = null;
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration instanceof FieldDeclaration) {
                if (this.isNewGroup(bodyDeclaration, previous)) {
                    this.alignFields(alignGroup);
                    alignGroup = new ArrayList();
                }
                alignGroup.add((FieldDeclaration)bodyDeclaration);
            }
            previous = bodyDeclaration;
        }
        this.alignFields(alignGroup);
    }

    private boolean isNewGroup(BodyDeclaration declaration, BodyDeclaration previousDeclaration) {
        if (!(previousDeclaration instanceof FieldDeclaration)) {
            return true;
        }
        int lineBreaks = 0;
        int from = this.tm.lastIndexIn(previousDeclaration, -1);
        int to = this.tm.firstIndexIn(declaration, -1);
        Token previous = this.tm.get(from);
        int i = from + 1;
        while (i <= to) {
            Token token = this.tm.get(i);
            lineBreaks += Math.min(this.tm.countLineBreaksBetween(previous, token), this.options.number_of_empty_lines_to_preserve + 1);
            previous = token;
            ++i;
        }
        return lineBreaks > this.options.align_fields_grouping_blank_lines;
    }

    private void alignFields(ArrayList<FieldDeclaration> alignGroup) {
        List fragments;
        if (alignGroup.size() < 2) {
            return;
        }
        this.fieldAlignGroups.add(alignGroup);
        int maxNameAlign = 0;
        for (FieldDeclaration declaration : alignGroup) {
            List fragments2 = declaration.fragments();
            SimpleName fieldName = ((VariableDeclarationFragment)fragments2.get(0)).getName();
            int nameIndex = this.tm.firstIndexIn(fieldName, 17);
            int positionInLine = this.tm.getPositionInLine(nameIndex);
            maxNameAlign = Math.max(maxNameAlign, positionInLine);
        }
        maxNameAlign = this.normalizedAlign(maxNameAlign);
        int maxAssignAlign = 0;
        for (FieldDeclaration declaration : alignGroup) {
            fragments = declaration.fragments();
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            int nameIndex = this.tm.firstIndexIn(fragment.getName(), 17);
            Token nameToken = this.tm.get(nameIndex);
            nameToken.setAlign(maxNameAlign);
            if (fragment.getInitializer() == null) continue;
            int equalIndex = this.tm.firstIndexAfter(fragment.getName(), 77);
            int positionInLine = this.tm.getPositionInLine(equalIndex);
            maxAssignAlign = Math.max(maxAssignAlign, positionInLine);
        }
        maxAssignAlign = this.normalizedAlign(maxAssignAlign);
        for (FieldDeclaration declaration : alignGroup) {
            fragments = declaration.fragments();
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
            if (fragment.getInitializer() == null) continue;
            int assingIndex = this.tm.firstIndexAfter(fragment.getName(), 77);
            Token assignToken = this.tm.get(assingIndex);
            assignToken.setAlign(maxAssignAlign);
        }
    }

    public void alignComments() {
        if (this.fieldAlignGroups.isEmpty()) {
            return;
        }
        boolean alignLineComments = !this.options.comment_preserve_white_space_between_code_and_line_comments;
        PositionCounter positionCounter = new PositionCounter();
        for (List<FieldDeclaration> alignGroup : this.fieldAlignGroups) {
            int lastIndex;
            int firstIndexInLine;
            int typeIndex;
            int maxCommentAlign = 0;
            for (FieldDeclaration declaration : alignGroup) {
                typeIndex = this.tm.firstIndexIn(declaration.getType(), -1);
                firstIndexInLine = this.tm.findFirstTokenInLine(typeIndex);
                lastIndex = this.tm.lastIndexIn(declaration, -1) + 1;
                maxCommentAlign = Math.max(maxCommentAlign, positionCounter.findMaxPosition(firstIndexInLine, lastIndex));
            }
            maxCommentAlign = this.normalizedAlign(maxCommentAlign);
            for (FieldDeclaration declaration : alignGroup) {
                typeIndex = this.tm.firstIndexIn(declaration.getType(), -1);
                firstIndexInLine = this.tm.findFirstTokenInLine(typeIndex);
                lastIndex = this.tm.lastIndexIn(declaration, -1);
                lastIndex = Math.min(lastIndex, this.tm.size() - 2);
                int i = firstIndexInLine;
                while (i <= lastIndex) {
                    boolean lineBreak;
                    Token token = this.tm.get(i);
                    Token next = this.tm.get(i + 1);
                    boolean bl = lineBreak = token.getLineBreaksAfter() > 0 || next.getLineBreaksBefore() > 0;
                    if (lineBreak) {
                        if (token.tokenType == 1002) {
                            token.setAlign(maxCommentAlign);
                        } else if (alignLineComments) {
                            this.tm.addNLSAlignIndex(i, maxCommentAlign);
                        }
                    } else if (next.tokenType == 1001 && alignLineComments || next.tokenType == 1002 && i == lastIndex) {
                        next.setAlign(maxCommentAlign);
                    }
                    ++i;
                }
            }
        }
    }

    private int normalizedAlign(int desiredAlign) {
        if (this.options.align_with_spaces) {
            return desiredAlign;
        }
        return this.tm.toIndent(desiredAlign, false);
    }

    private class PositionCounter
    extends TokenTraverser {
        int stoppingIndex;
        int maxPosition;

        @Override
        protected boolean token(Token token, int index) {
            if (index == this.stoppingIndex) {
                return false;
            }
            if (this.getLineBreaksBefore() > 0) {
                this.counter = FieldAligner.this.tm.getPositionInLine(index);
            }
            if (token.getAlign() > 0) {
                this.counter = token.getAlign();
            }
            this.counter += FieldAligner.this.tm.getLength(token, this.counter);
            if (this.isSpaceAfter() && this.getLineBreaksAfter() == 0) {
                ++this.counter;
            }
            this.maxPosition = Math.max(this.maxPosition, this.counter);
            return true;
        }

        public int findMaxPosition(int fromIndex, int toIndex) {
            this.counter = FieldAligner.this.tm.getPositionInLine(fromIndex);
            this.stoppingIndex = toIndex;
            this.maxPosition = 0;
            FieldAligner.this.tm.traverse(fromIndex, this);
            return this.maxPosition;
        }
    }
}

