/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.objectteams.otdt.core.ICalloutToFieldMapping;
import org.eclipse.objectteams.otdt.core.IFieldAccessSpec;
import org.eclipse.objectteams.otdt.core.TypeHelper;
import org.eclipse.objectteams.otdt.internal.core.AbstractCalloutMapping;
import org.eclipse.objectteams.otdt.internal.core.OTJavaElement;
import org.eclipse.objectteams.otdt.internal.core.ResolvedCalloutToFieldMapping;
import org.eclipse.objectteams.otdt.internal.core.util.FieldData;
import org.eclipse.objectteams.otdt.internal.core.util.MethodData;

public class CalloutToFieldMapping
extends AbstractCalloutMapping
implements ICalloutToFieldMapping {
    private boolean isOverride;
    private int declaredModifiers;
    private IField baseField;
    private IFieldAccessSpec baseFieldHandle;

    public CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, IType role, IMethod correspondingJavaElem, MethodData roleMethodHandle, IFieldAccessSpec baseFieldHandle, boolean hasSignature, boolean isOverride, int declaredModifiers, boolean addAsChild) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 104, role, correspondingJavaElem, roleMethodHandle, baseFieldHandle, hasSignature, isOverride, declaredModifiers, addAsChild);
    }

    protected CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod correspondingJavaElem, MethodData roleMethodHandle, IFieldAccessSpec baseFieldHandle, boolean hasSignature, boolean isOverride, int declaredModifiers) {
        this(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, 104, parentRole, correspondingJavaElem, roleMethodHandle, baseFieldHandle, hasSignature, isOverride, declaredModifiers, true);
    }

    protected CalloutToFieldMapping(int declarationSourceStart, int sourceStart, int sourceEnd, int declarationSourceEnd, int elementType, IType parentRole, IMethod correspondingJavaElem, MethodData roleMethodHandle, IFieldAccessSpec baseFieldHandle, boolean hasSignature, boolean isOverride, int declaredModifiers, boolean addAsChild) {
        super(declarationSourceStart, sourceStart, sourceEnd, declarationSourceEnd, elementType, correspondingJavaElem, parentRole, roleMethodHandle, hasSignature, addAsChild);
        this.isOverride = isOverride;
        this.baseFieldHandle = baseFieldHandle;
        this.declaredModifiers = declaredModifiers;
    }

    @Override
    public boolean isOverride() {
        return this.isOverride;
    }

    @Override
    public int getFlags() throws JavaModelException {
        return this.declaredModifiers;
    }

    @Override
    public String getElementName() {
        StringBuffer name = new StringBuffer(super.getElementName());
        name.append(" -> ");
        if (this.hasSignature()) {
            name.append(this.baseFieldHandle.toString());
        } else {
            name.append(this.baseFieldHandle.getSelector());
        }
        return name.toString();
    }

    @Override
    public int getMappingKind() {
        return 104;
    }

    @Override
    public IField getBoundBaseField() throws JavaModelException {
        if (this.baseField == null) {
            this.baseField = this.findBaseField();
        }
        return this.baseField;
    }

    @Override
    public IFieldAccessSpec getBaseFieldHandle() {
        return this.baseFieldHandle;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CalloutToFieldMapping)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "callout to field" + super.toString();
    }

    private IField findBaseField() throws JavaModelException {
        IType baseClass = this.getDeclaringRole().getBaseClass();
        IType[] typeParents = TypeHelper.getSuperTypes(baseClass);
        return this.findField(typeParents, this.baseFieldHandle);
    }

    private IField findField(IType[] types, IFieldAccessSpec fieldHandle) throws JavaModelException {
        int idx = 0;
        while (idx < types.length) {
            IField[] fields = types[idx].getFields();
            int idy = 0;
            while (idy < fields.length) {
                IField tmpField = fields[idy];
                if (tmpField.getElementName().equals(fieldHandle.getSelector())) {
                    return tmpField;
                }
                ++idy;
            }
            ++idx;
        }
        return null;
    }

    @Override
    protected char getMappingKindChar() {
        if (this.baseFieldHandle.isSetter()) {
            if (this.isOverride) {
                return 'S';
            }
            return 's';
        }
        if (this.isOverride) {
            return 'G';
        }
        return 'g';
    }

    @Override
    protected void getBaseMethodsForHandle(StringBuffer buff) {
        this.escapeMementoName(buff, this.baseFieldHandle.getSelector());
        buff.append('~');
        this.escapeMementoName(buff, this.baseFieldHandle.getFieldType());
    }

    public static IFieldAccessSpec createFieldData(MementoTokenizer memento, boolean isSetter) {
        String selector = memento.nextToken();
        String cur = memento.nextToken();
        if (cur.charAt(0) == '~') {
            cur = memento.nextToken();
        }
        StringBuffer buffer = new StringBuffer();
        while (cur.length() == 1 && '[' == cur.charAt(0)) {
            buffer.append('[');
            if (!memento.hasMoreTokens()) break;
            cur = memento.nextToken();
        }
        buffer.append(cur);
        String fieldType = buffer.toString();
        memento.nextToken();
        return new FieldData(selector, fieldType, isSetter);
    }

    @Override
    public OTJavaElement resolved(char[] uniqueKey) {
        ResolvedCalloutToFieldMapping resolvedHandle = new ResolvedCalloutToFieldMapping(this.getDeclarationSourceStart(), this.getSourceStart(), this.getSourceEnd(), this.getDeclarationSourceEnd(), this.getElementType(), (IType)this.getParent(), this.getIMethod(), this.getRoleMethodHandle(), this.baseFieldHandle, this.hasSignature(), this.isOverride(), this.declaredModifiers, new String(uniqueKey));
        return resolvedHandle;
    }

    @Override
    public String[] getExceptionTypes() throws JavaModelException {
        return new String[0];
    }

    @Override
    public ILocalVariable[] getParameters() throws JavaModelException {
        return null;
    }
}

