/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.remote.ui.internal.lua;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.ldt.remote.core.internal.lua.LuaSubSystem;
import org.eclipse.ldt.remote.ui.internal.Activator;
import org.eclipse.rse.internal.ui.view.SystemViewSubSystemAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class LuaSubSystemAdapter
extends SystemViewSubSystemAdapter {
    private LuaSubSystem luaSubSystem;

    public LuaSubSystemAdapter(LuaSubSystem subSystem) {
        this.luaSubSystem = subSystem;
    }

    public Object getPropertyValue(Object property) {
        if (property instanceof String) {
            return this.luaSubSystem.getLuaPropertyValue((String)property);
        }
        if (property == null) {
            Activator.logWarning("Try to get a property for null key");
        } else {
            Activator.logWarning(MessageFormat.format("Try to get a property for a non String key (key = {0}, keytype = {1}) ", property.toString(), property.getClass().getName()));
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<TextPropertyDescriptor> result = new ArrayList<TextPropertyDescriptor>();
        TextPropertyDescriptor luaCommandPD = new TextPropertyDescriptor((Object)"lua_command", "Lua Command");
        luaCommandPD.setDescription("The command use to run the Lua VM.");
        result.add(luaCommandPD);
        TextPropertyDescriptor luaPathPD = new TextPropertyDescriptor((Object)"lua_path", "Lua Path");
        luaPathPD.setDescription("The Lua path of the lua VM.");
        luaPathPD.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
        result.add(luaPathPD);
        TextPropertyDescriptor luaCPathPD = new TextPropertyDescriptor((Object)"lua_cpath", "Lua CPath");
        luaCPathPD.setDescription("The Lua cpath of the lua VM.");
        luaCPathPD.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
        result.add(luaCPathPD);
        TextPropertyDescriptor ldLibraryPathPD = new TextPropertyDescriptor((Object)"ld_library_path", "LD_LIBRARY_PATH");
        ldLibraryPathPD.setDescription("The Lua cpath of the lua VM.");
        ldLibraryPathPD.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
        result.add(ldLibraryPathPD);
        TextPropertyDescriptor outputDirectoryPD = new TextPropertyDescriptor((Object)"output_dir", "Output Directory");
        outputDirectoryPD.setDescription("The directory where lua application could be deploy at run or debug time.");
        result.add(outputDirectoryPD);
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    public void setPropertyValue(Object property, Object value) {
        if (property instanceof String) {
            if (value == null) {
                this.luaSubSystem.setLuaPropertyValue((String)property, null);
            } else {
                this.luaSubSystem.setLuaPropertyValue((String)property, value.toString());
            }
        } else if (property == null) {
            Activator.logWarning("Try to set a property for null key");
        } else {
            Activator.logWarning(MessageFormat.format("Try to set a property for a non String key (key = {0}, keytype = {1}) ", property.toString(), property.getClass().getName()));
        }
    }

    public void resetPropertyValue(Object property) {
        this.setPropertyValue(property, null);
    }

    public boolean isPropertySet(Object propertyObject) {
        return true;
    }
}

