/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.labels;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.labels.AbstractLabelGenerator;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;

public final class DynamicEObjectImplLabelGenerator
extends AbstractLabelGenerator<DynamicEObjectImpl> {
    private static final AdapterFactory reflectiveAdapterFactory = new ReflectiveItemProviderAdapterFactory();
    private static final AdapterFactory defaultAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    public static void initialize(ILabelGenerator.Registry registry) {
        registry.install(DynamicEObjectImpl.class, new DynamicEObjectImplLabelGenerator());
    }

    public DynamicEObjectImplLabelGenerator() {
        super(DynamicEObjectImpl.class);
    }

    @Override
    public void buildLabelFor(@NonNull ILabelGenerator.Builder labelBuilder, @NonNull DynamicEObjectImpl object) {
        IItemLabelProvider labeler;
        String className;
        EClass eClass = object.eClass();
        Resource eResource = object.eResource();
        if (eResource != null && object.eContainer() == null && (className = eResource.getClass().getName()).contains("UML")) {
            for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
                if (!(eFeature instanceof EReference) || eFeature.isMany() || !eFeature.getName().startsWith("base_")) continue;
                labelBuilder.appendString("\u00ab");
                labelBuilder.appendString(eClass.getName());
                labelBuilder.appendString("\u00bb");
                labelBuilder.buildLabelFor(object.eGet(eFeature));
                return;
            }
        }
        if ((labeler = (IItemLabelProvider)defaultAdapterFactory.adapt((Notifier)object, IItemLabelProvider.class)) == null) {
            labeler = (IItemLabelProvider)reflectiveAdapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
        }
        if (labeler != null) {
            labelBuilder.appendString(labeler.getText((Object)object));
        } else {
            labelBuilder.appendString(String.valueOf(object));
        }
    }
}

