/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.NoSuchElementException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.values.MapTypeParameters;

public class MapTypeParametersImpl<K extends Type, V extends Type>
implements MapTypeParameters<K, V> {
    private final int hashCode;
    private final @NonNull K keyType;
    private final @NonNull V valueType;

    public MapTypeParametersImpl(@NonNull K keyType, @NonNull V valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.hashCode = 5 * keyType.hashCode() + 7 * valueType.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MapTypeParametersImpl)) {
            return false;
        }
        MapTypeParametersImpl that = (MapTypeParametersImpl)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (!this.keyType.equals(that.keyType)) {
            return false;
        }
        return this.valueType.equals(that.valueType);
    }

    @Override
    public @NonNull K getKeyType() {
        return this.keyType;
    }

    @Override
    public @NonNull V getValueType() {
        return this.valueType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public @NonNull Iterator iterator() {
        return new Iterator();
    }

    public int parametersSize() {
        return 2;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        s.append(this.keyType);
        s.append(',');
        s.append(this.valueType);
        s.append(')');
        return s.toString();
    }

    protected class Iterator
    implements java.util.Iterator<Object> {
        private int position = 0;

        protected Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < 2;
        }

        @Override
        public Object next() {
            switch (this.position++) {
                case 0: {
                    return MapTypeParametersImpl.this.keyType;
                }
                case 1: {
                    return MapTypeParametersImpl.this.valueType;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

