/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.AssociativityKind;
import org.eclipse.ocl.pivot.BagType;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.PackageImpl;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.options.PivotValidationOptions;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.Unlimited;

public class PivotUtil {
    public static void addAllClasses(@NonNull EnvironmentView environmentView, @NonNull Package pPackage) {
        String packageName = pPackage.getName();
        if (packageName == null || "".equals(packageName)) {
            environmentView.addNamedElements(pPackage.getOwnedClasses());
        } else {
            CompletePackageInternal completePackage = environmentView.getEnvironmentFactory().getCompleteModel().getCompletePackage(pPackage);
            environmentView.addNamedElements(completePackage.getAllClasses());
        }
    }

    public static <T extends NamedElement> void addAllNamedElements(@NonNull EnvironmentView environmentView, @NonNull Iterable<T> namedElements) {
        String name = environmentView.getName();
        if (name != null) {
            for (NamedElement namedElement : namedElements) {
                if (namedElement == null || !name.equals(namedElement.getName())) continue;
                environmentView.addElement(name, namedElement);
            }
        } else {
            for (NamedElement namedElement : namedElements) {
                if (namedElement == null) continue;
                environmentView.addNamedElement(namedElement);
            }
        }
    }

    public static void checkExpression(@NonNull ExpressionInOCL expressionInOCL) {
        OCLExpression bodyExpression;
        Variable contextVariable = expressionInOCL.getOwnedContext();
        if (contextVariable == null && (bodyExpression = expressionInOCL.getOwnedBody()) instanceof StringLiteralExp) {
            throw new InvalidValueException(((StringLiteralExp)bodyExpression).getStringSymbol(), new Object[0]);
        }
    }

    public static void checkResourceErrors(@NonNull String message, @NonNull Resource resource) throws ParserException {
        List errors = (List)ClassUtil.nonNullEMF(resource.getErrors());
        if (errors.size() > 0) {
            throw new SemanticException(PivotUtil.formatResourceDiagnostics(errors, message, "\n"));
        }
    }

    public static void checkResourceWarnings(@NonNull String message, @NonNull Resource resource) throws ParserException {
        List warnings = (List)ClassUtil.nonNullEMF(resource.getWarnings());
        if (warnings.size() > 0) {
            throw new SemanticException(PivotUtil.formatResourceDiagnostics(warnings, message, "\n"));
        }
    }

    public static boolean conformsTo(@Nullable EClassifier targetType, @NonNull EClassifier contentType) {
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return ((EClass)targetType).isSuperTypeOf((EClass)contentType);
    }

    public static boolean conformsTo(@Nullable EStructuralFeature eStructuralFeature, @NonNull EClassifier contentType) {
        if (eStructuralFeature == null) {
            return true;
        }
        EClassifier targetType = eStructuralFeature.getEType();
        if (targetType == contentType) {
            return true;
        }
        if (!(targetType instanceof EClass)) {
            return false;
        }
        if (!(contentType instanceof EClass)) {
            return false;
        }
        return PivotUtil.conformsTo(targetType, contentType);
    }

    public static @NonNull AnyType createAnyType(@NonNull String name) {
        AnyType pivotType = PivotFactory.eINSTANCE.createAnyType();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull AnyType createAnyType(EClass eClass) {
        AnyType pivotType = PivotFactory.eINSTANCE.createAnyType();
        pivotType.setName(eClass.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eClass);
        return pivotType;
    }

    public static @NonNull BagType createBagType(@NonNull BagType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createBagType(), unspecializedType, elementType);
    }

    public static @NonNull Class createClass(EClass eClass) {
        Class pivotType = PivotFactory.eINSTANCE.createClass();
        pivotType.setName(eClass.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eClass);
        return pivotType;
    }

    public static @NonNull Class createClass(@NonNull String name) {
        Class pivotType = PivotFactory.eINSTANCE.createClass();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull CollectionType createCollectionType(@NonNull CollectionType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createCollectionType(), unspecializedType, elementType);
    }

    protected static <T extends CollectionType> @NonNull T createCollectionType(T specializedType, @NonNull T unspecializedType, @NonNull Type instanceType) {
        specializedType.setName(unspecializedType.getName());
        specializedType.setLower(unspecializedType.getLower());
        specializedType.setUpper(unspecializedType.getUpper());
        specializedType.setUnspecializedElement(unspecializedType);
        TemplateParameter templateParameter = unspecializedType.getOwnedSignature().getOwnedParameters().get(0);
        assert (templateParameter != null);
        TemplateParameterSubstitution templateParameterSubstitution = PivotUtil.createTemplateParameterSubstitution(templateParameter, instanceType);
        TemplateBinding templateBinding = PivotUtil.createTemplateBinding(templateParameterSubstitution);
        specializedType.getOwnedBindings().add(templateBinding);
        assert (specializedType.getElementType() == instanceType);
        return specializedType;
    }

    public static @NonNull DataType createDataType(EDataType eDataType) {
        DataType pivotType = PivotFactory.eINSTANCE.createDataType();
        pivotType.setName(eDataType.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eDataType);
        return pivotType;
    }

    public static @NonNull DataType createDataType(@NonNull String name) {
        DataType pivotType = PivotFactory.eINSTANCE.createDataType();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull Enumeration createEnumeration(EEnum eEnum) {
        Enumeration pivotType = PivotFactory.eINSTANCE.createEnumeration();
        pivotType.setName(eEnum.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eEnum);
        return pivotType;
    }

    public static @NonNull Enumeration createEnumeration(@NonNull String name) {
        Enumeration pivotType = PivotFactory.eINSTANCE.createEnumeration();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull EnumerationLiteral createEnumerationLiteral(EEnumLiteral eEnumLiteral) {
        EnumerationLiteral pivotEnumerationLiteral = PivotFactory.eINSTANCE.createEnumerationLiteral();
        pivotEnumerationLiteral.setName(eEnumLiteral.getName());
        ((PivotObjectImpl)((Object)pivotEnumerationLiteral)).setESObject((EObject)eEnumLiteral);
        return pivotEnumerationLiteral;
    }

    public static @NonNull EnumerationLiteral createEnumerationLiteral(@NonNull String name) {
        EnumerationLiteral pivotEnumerationLiteral = PivotFactory.eINSTANCE.createEnumerationLiteral();
        pivotEnumerationLiteral.setName(name);
        return pivotEnumerationLiteral;
    }

    public static @NonNull ExpressionInOCL createExpressionInOCL(@Nullable Variable asContextVariable, @NonNull OCLExpression asExpression, Variable ... asParameterVariables) {
        ExpressionInOCL asExpressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
        asExpressionInOCL.setOwnedContext(asContextVariable);
        if (asParameterVariables != null) {
            Variable[] variableArray = asParameterVariables;
            int n = asParameterVariables.length;
            int n2 = 0;
            while (n2 < n) {
                Variable asParameterVariable = variableArray[n2];
                asExpressionInOCL.getOwnedParameters().add(asParameterVariable);
                ++n2;
            }
        }
        asExpressionInOCL.setOwnedBody(asExpression);
        asExpressionInOCL.setType(asExpression.getType());
        asExpressionInOCL.setIsRequired(asExpression.isIsRequired());
        return asExpressionInOCL;
    }

    public static @NonNull ExpressionInOCL createExpressionInOCLError(@NonNull String string) {
        ExpressionInOCL expressionInOCL = PivotFactory.eINSTANCE.createExpressionInOCL();
        StringLiteralExp stringLiteral = PivotFactory.eINSTANCE.createStringLiteralExp();
        stringLiteral.setStringSymbol(string);
        expressionInOCL.setOwnedBody(stringLiteral);
        expressionInOCL.setType(stringLiteral.getType());
        return expressionInOCL;
    }

    public static @NonNull InvalidType createInvalidType(@NonNull String name) {
        InvalidType pivotType = PivotFactory.eINSTANCE.createInvalidType();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull InvalidType createInvalidType(EClass eClass) {
        InvalidType pivotType = PivotFactory.eINSTANCE.createInvalidType();
        pivotType.setName(eClass.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eClass);
        return pivotType;
    }

    public static @NonNull Iteration createIteration(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @NonNull LibraryFeature implementation) {
        Iteration pivotIteration = PivotFactory.eINSTANCE.createIteration();
        pivotIteration.setName(name);
        pivotIteration.setType(type);
        pivotIteration.setImplementationClass(implementationClass);
        pivotIteration.setImplementation(implementation);
        return pivotIteration;
    }

    public static @NonNull LambdaType createLambdaType(@NonNull String name) {
        LambdaType pivotType = PivotFactory.eINSTANCE.createLambdaType();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull LetExp createLetExp(@NonNull Variable asVariable, @NonNull OCLExpression asIn) {
        LetExp asLetExp = PivotFactory.eINSTANCE.createLetExp();
        asLetExp.setOwnedIn(asIn);
        asLetExp.setType(asIn.getType());
        asLetExp.setIsRequired(asIn.isIsRequired());
        asLetExp.setOwnedVariable(asVariable);
        return asLetExp;
    }

    public static @NonNull Model createModel(String externalURI) {
        Model pivotModel = PivotFactory.eINSTANCE.createModel();
        pivotModel.setExternalURI(externalURI);
        return pivotModel;
    }

    public static @NonNull MapType createMapType(@NonNull MapType unspecializedType, @NonNull Type keyType, @NonNull Type valueType) {
        return PivotUtil.createMapType(PivotFactory.eINSTANCE.createMapType(), unspecializedType, keyType, valueType);
    }

    protected static <T extends MapType> @NonNull T createMapType(T specializedType, T unspecializedType, @NonNull Type keyType, @NonNull Type valueType) {
        specializedType.setName(unspecializedType.getName());
        specializedType.setUnspecializedElement(unspecializedType);
        TemplateParameter templateParameter1 = unspecializedType.getOwnedSignature().getOwnedParameters().get(0);
        TemplateParameter templateParameter2 = unspecializedType.getOwnedSignature().getOwnedParameters().get(1);
        assert (templateParameter1 != null);
        assert (templateParameter2 != null);
        TemplateParameterSubstitution templateParameterSubstitution1 = PivotUtil.createTemplateParameterSubstitution(templateParameter1, keyType);
        TemplateParameterSubstitution templateParameterSubstitution2 = PivotUtil.createTemplateParameterSubstitution(templateParameter2, valueType);
        TemplateBinding templateBinding = PivotUtil.createTemplateBinding(templateParameterSubstitution1, templateParameterSubstitution2);
        specializedType.getOwnedBindings().add(templateBinding);
        assert (specializedType.getKeyType() == keyType);
        assert (specializedType.getValueType() == valueType);
        return specializedType;
    }

    public static <T extends Model> @NonNull T createModel(@NonNull java.lang.Class<T> pivotClass, EClass pivotEClass, String externalURI) {
        assert (pivotEClass != null);
        Model pivotModel = (Model)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        pivotModel.setExternalURI(externalURI);
        return (T)pivotModel;
    }

    @Deprecated
    public static @NonNull NavigationCallExp createNavigationCallExp(@NonNull OCLExpression asSource, @NonNull Property asProperty) {
        NavigationCallExp asNavigationCallExp;
        if (asProperty.isIsImplicit()) {
            OppositePropertyCallExp asCallExp = PivotFactory.eINSTANCE.createOppositePropertyCallExp();
            asCallExp.setReferredProperty(asProperty.getOpposite());
            asNavigationCallExp = asCallExp;
        } else {
            PropertyCallExp asCallExp = PivotFactory.eINSTANCE.createPropertyCallExp();
            asCallExp.setReferredProperty(asProperty);
            asNavigationCallExp = asCallExp;
        }
        asNavigationCallExp.setName(asProperty.getName());
        asNavigationCallExp.setOwnedSource(asSource);
        asNavigationCallExp.setType(asProperty.getType());
        asNavigationCallExp.setIsRequired(asProperty.isIsRequired());
        return asNavigationCallExp;
    }

    public static @NonNull Operation createOperation(@NonNull String name, @NonNull Type type, @Nullable String implementationClass, @Nullable LibraryFeature implementation) {
        Operation pivotOperation = PivotFactory.eINSTANCE.createOperation();
        pivotOperation.setName(name);
        pivotOperation.setType(type);
        pivotOperation.setImplementationClass(implementationClass);
        pivotOperation.setImplementation(implementation);
        return pivotOperation;
    }

    public static @NonNull Operation createOperation(EOperation eOperation, @NonNull Type type, @Nullable String implementationClass, @Nullable LibraryFeature implementation) {
        Operation pivotOperation = PivotFactory.eINSTANCE.createOperation();
        pivotOperation.setName(eOperation.getName());
        pivotOperation.setType(type);
        pivotOperation.setImplementationClass(implementationClass);
        pivotOperation.setImplementation(implementation);
        ((PivotObjectImpl)((Object)pivotOperation)).setESObject((EObject)eOperation);
        return pivotOperation;
    }

    public static @NonNull Operation createOperation(@NonNull String name, @NonNull ExpressionInOCL asExpressionInOCL) {
        Operation asOperation = PivotFactory.eINSTANCE.createOperation();
        asOperation.setName(name);
        PivotUtil.initOperation(asOperation, asExpressionInOCL);
        return asOperation;
    }

    @Deprecated
    public static @NonNull OperationCallExp createOperationCallExp(@NonNull OCLExpression asSource, @NonNull Operation asOperation, OCLExpression ... asArguments) {
        OperationCallExp asCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        asCallExp.setReferredOperation(asOperation);
        asCallExp.setName(asOperation.getName());
        asCallExp.setOwnedSource(asSource);
        if (asArguments != null) {
            List<OCLExpression> asCallArguments = asCallExp.getOwnedArguments();
            OCLExpression[] oCLExpressionArray = asArguments;
            int n = asArguments.length;
            int n2 = 0;
            while (n2 < n) {
                OCLExpression asArgument = oCLExpressionArray[n2];
                asCallArguments.add(ClassUtil.nonNullState(asArgument));
                ++n2;
            }
        }
        asCallExp.setType(asOperation.getType());
        asCallExp.setIsRequired(asOperation.isIsRequired());
        return asCallExp;
    }

    public static @NonNull OrderedSetType createOrderedSetType(@NonNull OrderedSetType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createOrderedSetType(), unspecializedType, elementType);
    }

    public static @NonNull Package createOwnedPackage(@NonNull Model parentRoot, @NonNull String name) {
        Package aPackage = PivotUtil.createPackage(Package.class, PivotPackage.Literals.PACKAGE, name, null, null);
        parentRoot.getOwnedPackages().add(aPackage);
        return aPackage;
    }

    public static @NonNull Package createOwnedPackage(@NonNull Package parentPackage, @NonNull String name) {
        Package aPackage = PivotUtil.createPackage(Package.class, PivotPackage.Literals.PACKAGE, name, null, null);
        parentPackage.getOwnedPackages().add(aPackage);
        return aPackage;
    }

    public static @NonNull Package createPackage(EPackage ePackage, @Nullable String nsPrefix, @NonNull String nsURI) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(ePackage.getName());
        pivotPackage.setNsPrefix(nsPrefix);
        pivotPackage.setURI(nsURI);
        ((PivotObjectImpl)((Object)pivotPackage)).setESObject((EObject)ePackage);
        return pivotPackage;
    }

    public static @NonNull Package createPackage(@NonNull String name, @Nullable String nsPrefix, @NonNull String nsURI, @Nullable PackageId packageId) {
        Package pivotPackage = PivotFactory.eINSTANCE.createPackage();
        pivotPackage.setName(name);
        pivotPackage.setNsPrefix(nsPrefix);
        if (packageId != null) {
            ((PackageImpl)pivotPackage).setPackageId(packageId);
        }
        pivotPackage.setURI(nsURI);
        return pivotPackage;
    }

    public static <T extends Package> @NonNull T createPackage(@NonNull java.lang.Class<T> pivotClass, @NonNull EClass pivotEClass, @NonNull String name, @Nullable String nsURI, @Nullable PackageId packageId) {
        Package asPackage = (Package)pivotEClass.getEPackage().getEFactoryInstance().create(pivotEClass);
        asPackage.setName(name);
        if (packageId != null) {
            ((PackageImpl)asPackage).setPackageId(packageId);
        }
        asPackage.setURI(nsURI);
        return (T)asPackage;
    }

    public static @NonNull Parameter createParameter(@NonNull String name, @NonNull Type asType, boolean isRequired) {
        Parameter asParameter = PivotFactory.eINSTANCE.createParameter();
        asParameter.setName(name);
        asParameter.setType(asType);
        asParameter.setIsRequired(isRequired);
        return asParameter;
    }

    public static @NonNull Precedence createPrecedence(@NonNull String name, AssociativityKind kind) {
        assert (kind != null);
        Precedence pivotPrecedence = PivotFactory.eINSTANCE.createPrecedence();
        pivotPrecedence.setName(name);
        pivotPrecedence.setAssociativity(kind);
        return pivotPrecedence;
    }

    public static @NonNull PrimitiveType createPrimitiveType(@NonNull String name) {
        PrimitiveType pivotType = PivotFactory.eINSTANCE.createPrimitiveType();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull Property createProperty(EStructuralFeature eFeature, @NonNull Type type) {
        Property pivotProperty = PivotFactory.eINSTANCE.createProperty();
        pivotProperty.setName(eFeature.getName());
        pivotProperty.setType(type);
        ((PivotObjectImpl)((Object)pivotProperty)).setESObject((EObject)eFeature);
        return pivotProperty;
    }

    public static @NonNull Property createProperty(@NonNull String name, @NonNull Type type) {
        Property pivotProperty = PivotFactory.eINSTANCE.createProperty();
        pivotProperty.setName(name);
        pivotProperty.setType(type);
        return pivotProperty;
    }

    public static @NonNull PropertyCallExp createPropertyCallExp(@NonNull OCLExpression asSource, @NonNull Property asProperty) {
        PropertyCallExp asChild = PivotFactory.eINSTANCE.createPropertyCallExp();
        asChild.setOwnedSource(asSource);
        asChild.setReferredProperty(asProperty);
        asChild.setType(asProperty.getType());
        asChild.setIsRequired(asProperty.isIsRequired());
        return asChild;
    }

    public static @NonNull SelfType createSelfType(@NonNull String name) {
        SelfType pivotType = PivotFactory.eINSTANCE.createSelfType();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull SelfType createSelfType(EClass eClass) {
        SelfType pivotType = PivotFactory.eINSTANCE.createSelfType();
        pivotType.setName(eClass.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eClass);
        return pivotType;
    }

    public static @NonNull SequenceType createSequenceType(@NonNull SequenceType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createSequenceType(), unspecializedType, elementType);
    }

    public static @NonNull SetType createSetType(@NonNull SetType unspecializedType, @NonNull Type elementType) {
        return PivotUtil.createCollectionType(PivotFactory.eINSTANCE.createSetType(), unspecializedType, elementType);
    }

    public static @NonNull TemplateBinding createTemplateBinding(TemplateParameterSubstitution ... templateParameterSubstitutions) {
        TemplateBinding pivotTemplateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        List<TemplateParameterSubstitution> parameterSubstitutions = pivotTemplateBinding.getOwnedSubstitutions();
        TemplateParameterSubstitution[] templateParameterSubstitutionArray = templateParameterSubstitutions;
        int n = templateParameterSubstitutions.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateParameterSubstitution templateParameterSubstitution = templateParameterSubstitutionArray[n2];
            parameterSubstitutions.add(templateParameterSubstitution);
            ++n2;
        }
        return pivotTemplateBinding;
    }

    public static @NonNull TemplateParameter createTemplateParameter(@NonNull String name, Class ... lowerBounds) {
        TemplateParameter pivotTemplateParameter = PivotFactory.eINSTANCE.createTemplateParameter();
        pivotTemplateParameter.setName(name);
        if (lowerBounds != null) {
            List<Class> constrainingClasses = pivotTemplateParameter.getConstrainingClasses();
            Class[] classArray = lowerBounds;
            int n = lowerBounds.length;
            int n2 = 0;
            while (n2 < n) {
                Class lowerBound = classArray[n2];
                constrainingClasses.add(lowerBound);
                ++n2;
            }
        }
        return pivotTemplateParameter;
    }

    public static @NonNull TemplateParameterSubstitution createTemplateParameterSubstitution(@NonNull TemplateParameter formal, @NonNull Type actual) {
        TemplateParameterSubstitution pivotTemplateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
        pivotTemplateParameterSubstitution.setFormal(formal);
        pivotTemplateParameterSubstitution.setActual(actual);
        return pivotTemplateParameterSubstitution;
    }

    public static @NonNull TemplateSignature createTemplateSignature(@NonNull TemplateableElement templateableElement, TemplateParameter ... templateParameters) {
        TemplateSignature pivotTemplateSignature = PivotFactory.eINSTANCE.createTemplateSignature();
        List<TemplateParameter> parameters = pivotTemplateSignature.getOwnedParameters();
        TemplateParameter[] templateParameterArray = templateParameters;
        int n = templateParameters.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateParameter templateParameter = templateParameterArray[n2];
            parameters.add(templateParameter);
            ++n2;
        }
        pivotTemplateSignature.setOwningElement(templateableElement);
        return pivotTemplateSignature;
    }

    public static @NonNull TupleType createTupleType(@NonNull String name, Property ... properties) {
        TupleType pivotType = PivotFactory.eINSTANCE.createTupleType();
        pivotType.setName(name);
        List<Property> ownedProperties = pivotType.getOwnedProperties();
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            ownedProperties.add(property);
            ++n2;
        }
        return pivotType;
    }

    public static @NonNull String createTupleValuedConstraint(@NonNull String statusText, @Nullable Integer severity, @Nullable String messageText) {
        if (severity == null && messageText == null) {
            return statusText;
        }
        StringBuilder s = new StringBuilder();
        s.append("Tuple {");
        if (messageText != null) {
            s.append("\n\tmessage : String = " + messageText + ",");
        }
        if (severity != null) {
            s.append("\n\tseverity : Integer = " + severity + ",");
        }
        s.append("\n\tstatus : Boolean = " + statusText);
        s.append("\n}.status");
        return s.toString();
    }

    @Deprecated
    public static @NonNull Variable createVariable(@NonNull String name, @NonNull OCLExpression asInitExpression) {
        Variable asVariable = PivotFactory.eINSTANCE.createVariable();
        asVariable.setName(name);
        asVariable.setType(asInitExpression.getType());
        asVariable.setIsRequired(asInitExpression.isIsRequired());
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    @Deprecated
    public static @NonNull Variable createVariable(@NonNull String name, @NonNull Type asType, boolean isRequired, @Nullable OCLExpression asInitExpression) {
        Variable asVariable = PivotFactory.eINSTANCE.createVariable();
        asVariable.setName(name);
        asVariable.setType(asType);
        asVariable.setIsRequired(isRequired);
        asVariable.setOwnedInit(asInitExpression);
        return asVariable;
    }

    public static @NonNull VariableExp createVariableExp(@NonNull VariableDeclaration asVariable) {
        VariableExp asVariableExp = PivotFactory.eINSTANCE.createVariableExp();
        asVariableExp.setReferredVariable(asVariable);
        asVariableExp.setName(asVariable.getName());
        asVariableExp.setType(asVariable.getType());
        asVariableExp.setIsRequired(asVariable.isIsRequired());
        return asVariableExp;
    }

    @Deprecated
    public static @NonNull VariableExp createVariableExp(@NonNull Variable asVariable) {
        return PivotUtil.createVariableExp((VariableDeclaration)asVariable);
    }

    public static @NonNull VoidType createVoidType(@NonNull String name) {
        VoidType pivotType = PivotFactory.eINSTANCE.createVoidType();
        pivotType.setName(name);
        return pivotType;
    }

    public static @NonNull VoidType createVoidType(EClass eClass) {
        VoidType pivotType = PivotFactory.eINSTANCE.createVoidType();
        pivotType.setName(eClass.getName());
        ((PivotObjectImpl)((Object)pivotType)).setESObject((EObject)eClass);
        return pivotType;
    }

    public static void debugObjectUsage(String prefix, EObject element) {
        StringBuilder s = new StringBuilder();
        s.append(prefix);
        if (element != null) {
            s.append(element.eClass().getName());
            s.append("@");
            s.append(Integer.toHexString(element.hashCode()));
            Resource eResource = element.eResource();
            if (eResource != null) {
                if (element instanceof Element) {
                    s.append(" ");
                    s.append(AS2Moniker.toString((Element)element));
                }
                s.append(" ");
                s.append(eResource.getURI());
            } else if (element instanceof NamedElement) {
                s.append(" ");
                s.append(String.valueOf(((NamedElement)element).getName()));
            }
        } else {
            s.append("null");
        }
        System.out.println(s.toString());
    }

    public static boolean debugWellContainedness(Type type) {
        Type elementType;
        if (type.eResource() == null) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        if (type instanceof CollectionType && (elementType = ((CollectionType)type).getElementType()) != null && !PivotUtil.debugWellContainedness(elementType)) {
            PivotUtil.debugObjectUsage("Badly contained ", type);
            return false;
        }
        return true;
    }

    public static String formatDiagnostics(@NonNull Diagnostic diagnostic, @NonNull String newLine) {
        StringBuilder s = new StringBuilder();
        PivotUtil.formatDiagnostic(s, diagnostic, newLine);
        return s.toString();
    }

    public static void formatDiagnostic(@NonNull StringBuilder s, @NonNull Diagnostic diagnostic, @NonNull String newLine) {
        if (diagnostic.getSeverity() != 0) {
            s.append(newLine);
            s.append(String.valueOf(diagnostic.getSeverity()) + " - ");
            String location = diagnostic.getSource();
            if (location != null) {
                s.append(location);
                s.append(": ");
            }
            s.append(diagnostic.getMessage());
            for (Object obj : diagnostic.getData()) {
                s.append(newLine);
                s.append("\t");
                s.append(obj);
            }
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (childDiagnostic == null) continue;
                PivotUtil.formatDiagnostic(s, childDiagnostic, String.valueOf(newLine) + "\t");
            }
        }
    }

    public static String formatResourceDiagnostics(@NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    Resource.Diagnostic> diagnostics, @NonNull String messagePrefix, @NonNull String newLine) {
        if (diagnostics.size() <= 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(messagePrefix);
        for (Resource.Diagnostic diagnostic : diagnostics) {
            if (diagnostic instanceof Diagnostic) {
                PivotUtil.formatDiagnostic(s, (Diagnostic)diagnostic, newLine);
                continue;
            }
            s.append(newLine);
            String location = diagnostic.getLocation();
            if (location != null) {
                s.append(location);
                s.append(":");
            }
            s.append(diagnostic.getLine());
            try {
                int column = diagnostic.getColumn();
                if (column > 0) {
                    s.append(":");
                    s.append(column);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            s.append(": ");
            s.append(diagnostic.getMessage());
        }
        return s.toString();
    }

    public static @NonNull Element getActual(@NonNull TemplateParameterSubstitution templateParameterSubstitution) {
        return ClassUtil.nonNullState(templateParameterSubstitution.getActual());
    }

    public static @NonNull Class getClass(@NonNull TypedElement typedElement) {
        return ClassUtil.nonNullState((Class)typedElement.getType());
    }

    public static @Nullable Constraint getContainingConstraint(@Nullable Element element) {
        Element eObject = element;
        while (eObject != null) {
            if (eObject instanceof Constraint) {
                return (Constraint)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable ExpressionInOCL getContainingExpressionInOCL(@Nullable Element element) {
        Element eObject = element;
        while (eObject != null) {
            if (eObject instanceof ExpressionInOCL) {
                return (ExpressionInOCL)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Model getContainingModel(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Model) {
                return (Model)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Namespace getContainingNamespace(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Namespace) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Operation getContainingOperation(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Operation) {
                return (Operation)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable Package getContainingPackage(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Package) {
                return (Package)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    @Deprecated
    public static @Nullable Model getContainingRoot(@Nullable EObject element) {
        return PivotUtil.getContainingModel(element);
    }

    public static @Nullable Type getContainingType(@Nullable EObject element) {
        if (element != null) {
            EObject eObject = element;
            while (true) {
                if (eObject instanceof Type) {
                    return (Type)eObject;
                }
                EObject eContainer = eObject.eContainer();
                if (eContainer == null) {
                    if (!(eObject instanceof ExpressionInOCL)) break;
                    return ((ExpressionInOCL)eObject).getOwnedContext().getType();
                }
                eObject = eContainer;
            }
        }
        return null;
    }

    public static int getContainmentDepth(EObject eObject) {
        int depth = 0;
        EObject eContainer = eObject.eContainer();
        while (eContainer != null) {
            if (++depth > 100000) {
                return depth;
            }
            eContainer = eContainer.eContainer();
        }
        return depth;
    }

    public static @NonNull Type getContextType(@NonNull LambdaType lambdaType) {
        return ClassUtil.nonNullState(lambdaType.getContextType());
    }

    public static @Nullable java.lang.Class<?> getEcoreInstanceClass(@Nullable Property asProperty) {
        EClassifier eType;
        EObject eTarget;
        java.lang.Class instanceClass = null;
        if (asProperty != null && (eTarget = asProperty.getESObject()) instanceof EStructuralFeature && (eType = ((EStructuralFeature)eTarget).getEType()) != null) {
            instanceClass = eType.getInstanceClass();
        }
        return instanceClass;
    }

    public static @NonNull Type getElementType(@NonNull CollectionType collectionType) {
        return ClassUtil.nonNullState(collectionType.getElementType());
    }

    public static @NonNull Type getElementalType(@NonNull Type type) {
        Type elementType = type;
        while (elementType instanceof CollectionType) {
            elementType = ((CollectionType)elementType).getElementType();
            assert (elementType != null);
        }
        return elementType;
    }

    public static @NonNull Model getModel(@NonNull Resource asResource) {
        for (EObject eObject : asResource.getContents()) {
            if (!(eObject instanceof Model)) continue;
            return (Model)eObject;
        }
        throw new IllegalStateException();
    }

    public static @NonNull String getMultiplicity(@NonNull TypedElement typedElement) {
        StringBuilder s = new StringBuilder();
        Type type = typedElement.getType();
        if (type instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)type;
            Number lower = collectionType.getLower();
            Number upper = collectionType.getUpper();
            StringUtil.appendMultiplicity(s, lower.intValue(), upper instanceof Unlimited ? -1 : upper.intValue(), collectionType.isIsNullFree());
        } else {
            s.append(typedElement.isIsRequired() ? "[1]" : "[?]");
        }
        return s.toString();
    }

    public static @NonNull String getName(@NonNull NamedElement namedElement) {
        return ClassUtil.nonNullState(namedElement.getName());
    }

    public static @Nullable Namespace getNamespace(@Nullable EObject element) {
        EObject eObject = element;
        while (eObject != null) {
            if (eObject instanceof Model) {
                return null;
            }
            if (eObject instanceof Type) {
                return (Namespace)eObject;
            }
            if (eObject instanceof Package) {
                return (Namespace)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @NonNull String getNavigationOperator(boolean isSafe, boolean isAggregate) {
        if (isAggregate) {
            return isSafe ? "?->" : "->";
        }
        return isSafe ? "?." : ".";
    }

    public static @NonNull Property getOpposite(@NonNull Property asProperty) {
        return ClassUtil.nonNullState(asProperty.getOpposite());
    }

    public static @NonNull Iterable<@NonNull Parameter> getOwnedAccumulators(@NonNull Iteration iteration) {
        return ClassUtil.nullFree(iteration.getOwnedAccumulators());
    }

    public static @NonNull OCLExpression getOwnedArgument(@NonNull OperationCallExp object, int index) {
        return ClassUtil.nonNullState(object.getOwnedArguments().get(index));
    }

    public static @NonNull Iterable<@NonNull OCLExpression> getOwnedArguments(@NonNull OperationCallExp operationCallExp) {
        return ClassUtil.nullFree(operationCallExp.getOwnedArguments());
    }

    public static @NonNull Iterable<@NonNull TemplateBinding> getOwnedBindings(@NonNull TemplateableElement asElement) {
        return ClassUtil.nullFree(asElement.getOwnedBindings());
    }

    public static @NonNull OCLExpression getOwnedBody(@NonNull ExpressionInOCL asExpression) {
        return ClassUtil.nonNullState(asExpression.getOwnedBody());
    }

    public static @NonNull OCLExpression getOwnedBody(@NonNull LoopExp loopExp) {
        return ClassUtil.nonNullState(loopExp.getOwnedBody());
    }

    public static @NonNull Iterable<@NonNull Class> getOwnedClasses(@NonNull Package asPackage) {
        return ClassUtil.nullFree(asPackage.getOwnedClasses());
    }

    @Deprecated
    public static @NonNull Iterable<@NonNull Operation> getOwnedClasses(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getOwnedOperations());
    }

    public static @NonNull Iterable<@NonNull CompleteClass> getOwnedCompleteClasses(@NonNull CompletePackage completePackage) {
        return ClassUtil.nullFree(completePackage.getOwnedCompleteClasses());
    }

    public static @NonNull Iterable<@NonNull CompletePackage> getOwnedCompletePackages(@NonNull CompletePackage completePackage) {
        return ClassUtil.nullFree(completePackage.getOwnedCompletePackages());
    }

    public static @NonNull Iterable<@NonNull Comment> getOwnedComments(@NonNull Element asElement) {
        return ClassUtil.nullFree(asElement.getOwnedComments());
    }

    public static @NonNull OCLExpression getOwnedCondition(@NonNull IfExp ifExp) {
        return ClassUtil.nonNullState(ifExp.getOwnedCondition());
    }

    public static @NonNull VariableDeclaration getOwnedContext(@NonNull ExpressionInOCL asExpression) {
        return ClassUtil.nonNullState(asExpression.getOwnedContext());
    }

    public static @NonNull OCLExpression getOwnedElse(@NonNull IfExp ifExp) {
        return ClassUtil.nonNullState(ifExp.getOwnedElse());
    }

    public static @NonNull OCLExpression getOwnedFirst(@NonNull CollectionRange collectionRange) {
        return ClassUtil.nonNullState(collectionRange.getOwnedFirst());
    }

    public static @NonNull Iterable<@NonNull Import> getOwnedImports(@NonNull Model asModel) {
        return ClassUtil.nullFree(asModel.getOwnedImports());
    }

    public static @NonNull OCLExpression getOwnedIn(@NonNull LetExp letExp) {
        return ClassUtil.nonNullState(letExp.getOwnedIn());
    }

    public static @NonNull OCLExpression getOwnedInit(@NonNull ShadowPart shadowPart) {
        return ClassUtil.nonNullState(shadowPart.getOwnedInit());
    }

    public static @NonNull OCLExpression getOwnedInit(@NonNull Variable variable) {
        return ClassUtil.nonNullState(variable.getOwnedInit());
    }

    public static @NonNull Iterable<@NonNull Constraint> getOwnedInvariants(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getOwnedInvariants());
    }

    public static @NonNull OCLExpression getOwnedItem(@NonNull CollectionItem collectionItem) {
        return ClassUtil.nonNullState(collectionItem.getOwnedItem());
    }

    public static @NonNull Iterable<@NonNull Parameter> getOwnedIterators(@NonNull Iteration iteration) {
        return ClassUtil.nullFree(iteration.getOwnedIterators());
    }

    public static @NonNull Iterable<@NonNull Variable> getOwnedIterators(@NonNull LoopExp loopExp) {
        return ClassUtil.nullFree(loopExp.getOwnedIterators());
    }

    public static @NonNull OCLExpression getOwnedKey(@NonNull MapLiteralPart mapLiteralPart) {
        return ClassUtil.nonNullState(mapLiteralPart.getOwnedKey());
    }

    public static @NonNull OCLExpression getOwnedLast(@NonNull CollectionRange collectionRange) {
        return ClassUtil.nonNullState(collectionRange.getOwnedLast());
    }

    public static @NonNull Iterable<@NonNull Operation> getOwnedOperations(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getOwnedOperations());
    }

    public static @NonNull Iterable<@NonNull Package> getOwnedPackages(@NonNull Model asModel) {
        return ClassUtil.nullFree(asModel.getOwnedPackages());
    }

    public static @NonNull Iterable<@NonNull Package> getOwnedPackages(@NonNull Package asPackage) {
        return ClassUtil.nullFree(asPackage.getOwnedPackages());
    }

    public static @NonNull Parameter getOwnedParameter(@NonNull Operation operation, int index) {
        return ClassUtil.nonNullState(operation.getOwnedParameters().get(index));
    }

    public static @NonNull Iterable<@NonNull Parameter> getOwnedParameters(@NonNull Operation operation) {
        return ClassUtil.nullFree(operation.getOwnedParameters());
    }

    public static @NonNull Iterable<@NonNull TemplateParameter> getOwnedParameters(@NonNull TemplateSignature templateSignature) {
        return ClassUtil.nullFree(templateSignature.getOwnedParameters());
    }

    public static @NonNull Iterable<@NonNull CollectionLiteralPart> getOwnedParts(@NonNull CollectionLiteralExp asCollectionLiteralExp) {
        return ClassUtil.nullFree(asCollectionLiteralExp.getOwnedParts());
    }

    public static @NonNull Iterable<@NonNull TupleLiteralPart> getOwnedParts(@NonNull TupleLiteralExp asTupleLiteralExp) {
        return ClassUtil.nullFree(asTupleLiteralExp.getOwnedParts());
    }

    public static @NonNull Iterable<@NonNull Constraint> getOwnedPostconditions(@NonNull Operation asOperation) {
        return ClassUtil.nullFree(asOperation.getOwnedPostconditions());
    }

    public static @NonNull Iterable<@NonNull Constraint> getOwnedPreconditions(@NonNull Operation asOperation) {
        return ClassUtil.nullFree(asOperation.getOwnedPreconditions());
    }

    public static @NonNull Iterable<@NonNull Property> getOwnedProperties(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getOwnedProperties());
    }

    public static @NonNull Variable getOwnedResult(@NonNull IterateExp iterateExp) {
        return ClassUtil.nonNullState(iterateExp.getOwnedResult());
    }

    public static @NonNull OCLExpression getOwnedSource(@NonNull CallExp object) {
        return ClassUtil.nonNullState(object.getOwnedSource());
    }

    public static @NonNull Iterable<@NonNull TemplateParameterSubstitution> getOwnedSubstitutions(@NonNull TemplateBinding asTemplateBinding) {
        return ClassUtil.nullFree(asTemplateBinding.getOwnedSubstitutions());
    }

    public static @NonNull OCLExpression getOwnedThen(@NonNull IfExp ifExp) {
        return ClassUtil.nonNullState(ifExp.getOwnedThen());
    }

    public static @NonNull OCLExpression getOwnedValue(@NonNull MapLiteralPart mapLiteralPart) {
        return ClassUtil.nonNullState(mapLiteralPart.getOwnedValue());
    }

    public static @NonNull Variable getOwnedVariable(@NonNull LetExp letExp) {
        return ClassUtil.nonNullState(letExp.getOwnedVariable());
    }

    public static @NonNull Class getOwningClass(@NonNull Operation operation) {
        return ClassUtil.nonNullState(operation.getOwningClass());
    }

    public static @NonNull Class getOwningClass(@NonNull Property property) {
        return ClassUtil.nonNullState(property.getOwningClass());
    }

    public static @NonNull Enumeration getOwningEnumeration(@NonNull EnumerationLiteral enumerationLiteral) {
        return ClassUtil.nonNullState(enumerationLiteral.getOwningEnumeration());
    }

    public static @NonNull Package getOwningPackage(@NonNull Class asClass) {
        return ClassUtil.nonNullState(asClass.getOwningPackage());
    }

    public static @Nullable Package getPackage(@NonNull EObject object) {
        EObject eObject = object;
        while (eObject != null) {
            if (eObject instanceof Package) {
                return (Package)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @NonNull List<@NonNull Type> getParameterType(@NonNull LambdaType lambdaType) {
        return ClassUtil.nullFree(lambdaType.getParameterType());
    }

    public static @NonNull Iterable<@NonNull Class> getPartialClasses(@NonNull CompleteClass completeClass) {
        return ClassUtil.nullFree(completeClass.getPartialClasses());
    }

    public static <T extends Element> @Nullable T getPivot(@NonNull java.lang.Class<T> pivotClass, @Nullable Pivotable pivotableElement) {
        if (pivotableElement == null) {
            return null;
        }
        Element pivotElement = pivotableElement.getPivot();
        if (pivotElement == null) {
            return null;
        }
        if (!pivotClass.isAssignableFrom(pivotElement.getClass())) {
            throw new ClassCastException(String.valueOf(pivotElement.getClass().getName()) + " is not assignable to " + pivotClass.getName());
        }
        Element castElement = pivotElement;
        return (T)castElement;
    }

    public static @NonNull Iterable<@NonNull Operation> getRedefinedOperations(@NonNull Operation operation) {
        return ClassUtil.nullFree(operation.getRedefinedOperations());
    }

    public static @NonNull Iterable<@NonNull Property> getRedefinedProperties(@NonNull Property property) {
        return ClassUtil.nullFree(property.getRedefinedProperties());
    }

    public static Feature getReferredFeature(CallExp callExp) {
        Feature feature = null;
        if (callExp instanceof LoopExp) {
            feature = ((LoopExp)callExp).getReferredIteration();
        } else if (callExp instanceof OperationCallExp) {
            feature = ((OperationCallExp)callExp).getReferredOperation();
        } else if (callExp instanceof OppositePropertyCallExp) {
            Property referredOppositeProperty = ((OppositePropertyCallExp)callExp).getReferredProperty();
            feature = referredOppositeProperty != null ? referredOppositeProperty.getOpposite() : null;
        } else if (callExp instanceof PropertyCallExp) {
            feature = ((PropertyCallExp)callExp).getReferredProperty();
        }
        return feature;
    }

    public static @NonNull Iteration getReferredIteration(@NonNull LoopExp loopExp) {
        return ClassUtil.nonNullState(loopExp.getReferredIteration());
    }

    public static @NonNull EnumerationLiteral getReferredLiteral(@NonNull EnumLiteralExp enumLiteralExp) {
        return ClassUtil.nonNullState(enumLiteralExp.getReferredLiteral());
    }

    public static @NonNull Operation getReferredOperation(@NonNull CallExp callExp) {
        if (callExp instanceof LoopExp) {
            return ClassUtil.nonNullState(((LoopExp)callExp).getReferredIteration());
        }
        if (callExp instanceof OperationCallExp) {
            return ClassUtil.nonNullState(((OperationCallExp)callExp).getReferredOperation());
        }
        throw new IllegalStateException();
    }

    public static @NonNull Property getReferredProperty(@NonNull NavigationCallExp navigationCallExp) {
        if (navigationCallExp instanceof PropertyCallExp) {
            return ClassUtil.nonNullState(((PropertyCallExp)navigationCallExp).getReferredProperty());
        }
        if (navigationCallExp instanceof OppositePropertyCallExp) {
            Property referredProperty = ClassUtil.nonNullState(((OppositePropertyCallExp)navigationCallExp).getReferredProperty());
            if (referredProperty.eIsProxy()) {
                throw new IllegalStateException("Unresolved referred property proxy '" + EcoreUtil.getURI((EObject)referredProperty) + "' at '" + EcoreUtil.getURI((EObject)navigationCallExp) + "'");
            }
            return ClassUtil.nonNullState(referredProperty.getOpposite());
        }
        throw new IllegalStateException();
    }

    public static @NonNull Type getReferredType(@NonNull TypeExp typeExp) {
        return ClassUtil.nonNullState(typeExp.getReferredType());
    }

    public static @NonNull VariableDeclaration getReferredVariable(@NonNull VariableExp variableExp) {
        return ClassUtil.nonNullState(variableExp.getReferredVariable());
    }

    public static @NonNull Resource getResource(@NonNull EObject eObject) {
        return ClassUtil.nonNullState(eObject.eResource());
    }

    public static int getSeverity(@NonNull EnvironmentFactory environmentFactory) {
        StatusCodes.Severity severity = environmentFactory.getValue(PivotValidationOptions.EcoreValidation);
        if (severity != null) {
            switch (severity) {
                case ERROR: {
                    return 4;
                }
                case IGNORE: {
                    return 0;
                }
                case INFO: {
                    return 1;
                }
                case WARNING: {
                    return 2;
                }
            }
        }
        return 4;
    }

    public static @NonNull Iterable<@NonNull Class> getSuperClasses(@NonNull Class asClass) {
        return ClassUtil.nullFree(asClass.getSuperClasses());
    }

    public static @NonNull Type getResultType(@NonNull LambdaType lambdaType) {
        return ClassUtil.nonNullState(lambdaType.getResultType());
    }

    public static @NonNull Type getType(@NonNull TypedElement typedElement) {
        return ClassUtil.nonNullState(typedElement.getType());
    }

    public static @NonNull TupleType getType(@NonNull TupleLiteralExp tupleLiteralExp) {
        return ClassUtil.nonNullState((TupleType)tupleLiteralExp.getType());
    }

    public static <T extends TemplateableElement> @NonNull T getUnspecializedTemplateableElement(@NonNull T templateableElement) {
        TemplateableElement unspecializedElement = templateableElement.getUnspecializedElement();
        if (unspecializedElement == null) {
            return templateableElement;
        }
        TemplateableElement castUnspecializedElement = unspecializedElement;
        return (T)castUnspecializedElement;
    }

    public static @NonNull Operation initOperation(@NonNull Operation asOperation, @NonNull ExpressionInOCL asExpressionInOCL) {
        for (Variable asParameterVariable : asExpressionInOCL.getOwnedParameters()) {
            String parameterName = ClassUtil.nonNullState(asParameterVariable.getName());
            Type parameterType = ClassUtil.nonNullState(asParameterVariable.getType());
            Parameter asParameter = PivotUtil.createParameter(parameterName, parameterType, asParameterVariable.isIsRequired());
            asParameterVariable.setRepresentedParameter(asParameter);
            asOperation.getOwnedParameters().add(asParameter);
        }
        asOperation.setBodyExpression(asExpressionInOCL);
        asOperation.setType(asExpressionInOCL.getType());
        asOperation.setIsRequired(asExpressionInOCL.isIsRequired());
        return asOperation;
    }

    public static void initializeLoadOptionsToSupportSelfReferences(@NonNull ResourceSet resourceSet) {
        resourceSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", true);
    }

    public static boolean isAggregate(Type type) {
        return type instanceof CollectionType || type instanceof MapType;
    }

    public static boolean isAggregateNavigationOperator(String operatorName) {
        return "->".equals(operatorName) || "?->".equals(operatorName);
    }

    public static boolean isObjectNavigationOperator(String operatorName) {
        return ".".equals(operatorName) || "?.".equals(operatorName);
    }

    public static boolean isSafeNavigationOperator(String operatorName) {
        return "?->".equals(operatorName) || "?.".equals(operatorName);
    }

    public static boolean isSameOperation(@NonNull OperationId operationId1, @NonNull OperationId operationId2) {
        if (operationId1 == operationId2) {
            return true;
        }
        if (!operationId1.getName().equals(operationId2.getName())) {
            return false;
        }
        return operationId1.getParametersId().equals(operationId2.getParametersId());
    }

    public static void replaceChild(@NonNull EObject oldChild, @NonNull EObject newChild) {
        EObject eContainer = oldChild.eContainer();
        EReference eContainmentFeature = oldChild.eContainmentFeature();
        if (eContainmentFeature.isMany()) {
            EList list = (EList)eContainer.eGet((EStructuralFeature)eContainmentFeature);
            int index = list.indexOf((Object)oldChild);
            assert (index >= 0);
            PivotUtilInternal.resetContainer(oldChild);
            list.add(index, (Object)newChild);
        } else {
            PivotUtilInternal.resetContainer(oldChild);
            eContainer.eSet((EStructuralFeature)eContainmentFeature, (Object)newChild);
        }
    }

    @Deprecated
    public static void rewriteSafeNavigations(@NonNull EnvironmentFactory environmentFactory, @NonNull Element asTree) {
        PivotHelper helper = new PivotHelper(environmentFactory);
        helper.rewriteSafeNavigations(asTree);
    }

    public static void setBody(@NonNull ExpressionInOCL expressionInOCL, @Nullable OCLExpression oclExpression, @Nullable String stringExpression) {
        expressionInOCL.setBody(stringExpression);
        expressionInOCL.setOwnedBody(oclExpression);
    }

    @Deprecated
    public static boolean setParserContext(@NonNull CSResource csResource, @NonNull EObject eObject, Object ... unusedParameters) throws ParserException {
        EnvironmentFactoryAdapter adapter = OCLInternal.adapt((Notifier)csResource);
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)adapter.getEnvironmentFactory();
        Element pivotElement = environmentFactory.getTechnology().getParseableElement(environmentFactory, eObject);
        if (pivotElement == null) {
            return false;
        }
        ParserContext parserContext = environmentFactory.createParserContext(pivotElement);
        if (parserContext == null) {
            return false;
        }
        csResource.setParserContext(parserContext);
        return true;
    }

    @Deprecated
    public static class PrecedenceComparator
    implements Comparator<Precedence> {
        public static final PrecedenceComparator INSTANCE = new PrecedenceComparator();

        @Override
        public int compare(Precedence p1, Precedence p2) {
            int o1 = p1 != null ? p1.getOrder().intValue() : -1;
            int o2 = p2 != null ? p2.getOrder().intValue() : -1;
            return o1 - o2;
        }
    }

    public static class TemplateParameterSubstitutionComparator
    implements Comparator<TemplateParameterSubstitution> {
        public static Comparator<? super TemplateParameterSubstitution> INSTANCE = new TemplateParameterSubstitutionComparator();

        @Override
        public int compare(TemplateParameterSubstitution o1, TemplateParameterSubstitution o2) {
            TemplateParameter f1 = o1.getFormal();
            TemplateParameter f2 = o2.getFormal();
            int i1 = f1.getOwningSignature().getOwnedParameters().indexOf(f1);
            int i2 = f2.getOwningSignature().getOwnedParameters().indexOf(f2);
            return i1 - i2;
        }
    }
}

