/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xml.utilities;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMILoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.xml.Attribute;
import org.eclipse.qvtd.xml.CDATA;
import org.eclipse.qvtd.xml.Characters;
import org.eclipse.qvtd.xml.Comment;
import org.eclipse.qvtd.xml.DTD;
import org.eclipse.qvtd.xml.Document;
import org.eclipse.qvtd.xml.Element;
import org.eclipse.qvtd.xml.Entity;
import org.eclipse.qvtd.xml.Node;
import org.eclipse.qvtd.xml.PrefixMapping;
import org.eclipse.qvtd.xml.ProcessingInstruction;
import org.eclipse.qvtd.xml.XMLmodelFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLmodelResourceImpl
extends XMIResourceImpl {
    public XMLmodelResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLLoad createXMLLoad() {
        return new XMLmodelLoadImpl(this.createXMLHelper());
    }

    protected XMLLoad createXMLLoad(Map<?, ?> options) {
        return this.createXMLLoad();
    }

    protected XMLSave createXMLSave() {
        return new XMLmodelSave(this.createXMLHelper());
    }

    protected XMLSave createXMLSave(Map<?, ?> options) {
        return this.createXMLSave();
    }

    public static class XMLmodelHandler
    extends DefaultHandler
    implements LexicalHandler {
        private XMLResource xmlResource;
        private Document document = null;
        private @NonNull Stack<@NonNull Node> nodeStack = new Stack();

        public XMLmodelHandler(XMLResource xmlResource, XMLHelper helper, Map<?, ?> options) {
            this.xmlResource = xmlResource;
        }

        protected void addNode(Node node) {
            if (this.nodeStack.isEmpty()) {
                this.document.getChildren().add((Object)node);
            } else {
                this.nodeStack.peek().getChildren().add((Object)node);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            boolean isWhite = true;
            int i = 0;
            while (i < length) {
                char c = ch[start + i];
                if (!Character.isWhitespace(c)) {
                    isWhite = false;
                    break;
                }
                ++i;
            }
            if (!isWhite) {
                String characterText = new String(ch, start, length);
                Characters characters = XMLmodelFactory.eINSTANCE.createCharacters();
                characters.setData(characterText);
                this.addNode(characters);
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) {
            Comment comment = XMLmodelFactory.eINSTANCE.createComment();
            comment.setData(new String(ch, start, length));
            this.addNode(comment);
        }

        @Override
        public void endCDATA() {
            this.nodeStack.pop();
        }

        @Override
        public void endDTD() {
            this.nodeStack.pop();
        }

        @Override
        public void endDocument() {
            this.xmlResource.getContents().add((Object)this.document);
            this.document = null;
        }

        @Override
        public void endElement(String uri, String localName, String name) {
            this.nodeStack.pop();
        }

        @Override
        public void endEntity(String name) {
            this.nodeStack.pop();
        }

        @Override
        public void endPrefixMapping(String prefix) {
            this.nodeStack.pop();
        }

        @Override
        public void processingInstruction(String target, String data) {
            ProcessingInstruction processingInstruction = XMLmodelFactory.eINSTANCE.createProcessingInstruction();
            processingInstruction.setTarget(target);
            processingInstruction.setData(data);
            this.addNode(processingInstruction);
        }

        @Override
        public void startCDATA() {
            CDATA cdata = XMLmodelFactory.eINSTANCE.createCDATA();
            this.addNode(cdata);
            this.nodeStack.push(cdata);
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) {
            DTD dtd = XMLmodelFactory.eINSTANCE.createDTD();
            dtd.setName(name);
            dtd.setPublicId(publicId);
            dtd.setSystemId(systemId);
            this.addNode(dtd);
            this.nodeStack.push(dtd);
        }

        @Override
        public void startDocument() {
            this.document = XMLmodelFactory.eINSTANCE.createDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Element element = XMLmodelFactory.eINSTANCE.createElement();
            element.setUri(uri);
            element.setLocalName(localName);
            element.setQName(qName);
            int index = 0;
            while (index < attributes.getLength()) {
                Attribute attribute = XMLmodelFactory.eINSTANCE.createAttribute();
                attribute.setName(attributes.getQName(index));
                attribute.setValue(attributes.getValue(index));
                element.getChildren().add((Object)attribute);
                ++index;
            }
            this.addNode(element);
            this.nodeStack.push(element);
        }

        @Override
        public void startEntity(String name) {
            Entity entity = XMLmodelFactory.eINSTANCE.createEntity();
            entity.setName(name);
            this.addNode(entity);
            this.nodeStack.push(entity);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            PrefixMapping prefixMapping = XMLmodelFactory.eINSTANCE.createPrefixMapping();
            prefixMapping.setPrefix(prefix);
            prefixMapping.setUri(uri);
            this.addNode(prefixMapping);
            this.nodeStack.push(prefixMapping);
        }
    }

    public static class XMLmodelLoadImpl
    extends XMILoadImpl {
        private SAXParser makeParser = null;

        public XMLmodelLoadImpl(XMLHelper helper) {
            super(helper);
        }

        protected DefaultHandler makeDefaultHandler() {
            XMLmodelHandler handler = new XMLmodelHandler(this.resource, this.helper, this.options);
            try {
                this.makeParser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (SAXException sAXException) {}
            return handler;
        }

        protected SAXParser makeParser() throws ParserConfigurationException, SAXException {
            this.makeParser = super.makeParser();
            return this.makeParser;
        }
    }

    public static class XMLmodelSave
    extends XMISaveImpl {
        public XMLmodelSave(XMLHelper helper) {
            super(helper);
        }

        public void traverse(List<? extends EObject> contents) {
            this.doc.add("<?xml version=\"" + this.xmlVersion + "\" encoding=\"" + this.encoding + "\"?>");
            this.doc.addLine();
            this.doc.setMixed(true);
            this.traverseElements(contents);
        }

        protected void traverseElements(List<? extends EObject> contents) {
            for (EObject eObject : contents) {
                if (eObject instanceof Document) {
                    this.traverseElements((List<? extends EObject>)((Document)eObject).getChildren());
                    continue;
                }
                if (eObject instanceof Element) {
                    Element element = (Element)eObject;
                    this.doc.startElement(element.getQName());
                    EList<Node> children = element.getChildren();
                    if (children.size() == 1 && children.get(0) instanceof Characters) {
                        Characters characters = (Characters)children.get(0);
                        String data = characters.getData();
                        this.doc.endContentElement(this.escape.convert(data));
                        continue;
                    }
                    this.traverseElements((List<? extends EObject>)children);
                    this.doc.endElement();
                    continue;
                }
                if (eObject instanceof Attribute) {
                    Attribute attribute = (Attribute)eObject;
                    this.doc.startAttribute(attribute.getName());
                    this.doc.addAttributeContent(this.escape.convert(attribute.getValue()));
                    this.doc.endAttribute();
                    continue;
                }
                if (eObject instanceof Comment) {
                    Comment comment = (Comment)eObject;
                    this.doc.addComment(comment.getData());
                    this.doc.addLine();
                    continue;
                }
                if (eObject instanceof Characters) {
                    Characters characters = (Characters)eObject;
                    String data = characters.getData();
                    this.doc.addText(data);
                    continue;
                }
                if (eObject instanceof CDATA) {
                    CDATA cdata = (CDATA)eObject;
                    this.doc.addCDATA(this.getCharacters(cdata));
                    continue;
                }
                if (!(eObject instanceof ProcessingInstruction)) continue;
                ProcessingInstruction processingInstruction = (ProcessingInstruction)eObject;
                this.doc.addProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
            }
        }

        private String getCharacters(Node node) {
            StringBuilder s = new StringBuilder();
            for (Node child : node.getChildren()) {
                if (!(child instanceof Characters)) continue;
                s.append(((Characters)child).getData());
            }
            return s.toString();
        }
    }
}

