/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ui.diagram.shape.def.BackgroundDef;
import org.eclipse.sapphire.ui.diagram.shape.def.GradientBackgroundDef;
import org.eclipse.sapphire.ui.diagram.shape.def.GradientSegmentDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SelectionPresentation;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SequenceLayoutOrientation;
import org.eclipse.sapphire.ui.diagram.shape.def.ShapeLayoutDef;
import org.eclipse.sapphire.ui.diagram.shape.def.SolidBackgroundDef;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.figures.ContainerShapeFigure;
import org.eclipse.sapphire.ui.swt.gef.figures.IShapeFigure;
import org.eclipse.sapphire.ui.swt.gef.figures.RectangleBorder;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireSequenceLayout;
import org.eclipse.sapphire.ui.swt.gef.layout.SapphireStackLayout;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.RectanglePresentation;
import org.eclipse.swt.graphics.Path;

public class RectangleFigure
extends ContainerShapeFigure
implements IShapeFigure {
    private static final Color DEFAULT_BACKGROUND_START = new Color(255, 255, 255);
    private static final Color DEFAULT_BACKGROUND_END = new Color(212, 231, 248);
    private RectanglePresentation rectPresentation;
    private ShapeLayoutDef layout;
    private DiagramResourceCache resourceCache;
    private boolean selected;

    public RectangleFigure(RectanglePresentation rectPresentation, DiagramResourceCache resourceCache, DiagramConfigurationManager configManager) {
        super(rectPresentation, resourceCache, configManager);
        this.rectPresentation = rectPresentation;
        this.layout = rectPresentation.getLayout();
        this.resourceCache = resourceCache;
        if (this.layout instanceof SequenceLayoutDef) {
            if (((SequenceLayoutDef)this.layout).getOrientation().content() != SequenceLayoutOrientation.STACKED) {
                SapphireSequenceLayout sequenceLayout = new SapphireSequenceLayout((SequenceLayoutDef)this.layout);
                this.setLayoutManager((LayoutManager)sequenceLayout);
            } else {
                SapphireStackLayout sapphireStackLayout = new SapphireStackLayout((SequenceLayoutDef)this.layout);
                this.setLayoutManager((LayoutManager)sapphireStackLayout);
            }
        }
        this.setBorder((Border)new RectangleBorder(this.rectPresentation, this.resourceCache));
    }

    @Override
    protected void fillShape(Graphics graphics) {
        BackgroundDef bg = null;
        if (this.selected) {
            SelectionPresentation selectionPresentation = this.rectPresentation.getSelectionPresentation();
            BackgroundDef backgroundDef = bg = selectionPresentation != null ? (BackgroundDef)selectionPresentation.getBackground().content() : null;
        }
        if (bg == null) {
            bg = this.rectPresentation.getBackground();
        }
        if (bg != null) {
            org.eclipse.swt.graphics.Color foregroundSave = graphics.getForegroundColor();
            org.eclipse.swt.graphics.Color backgroundSave = graphics.getBackgroundColor();
            Rectangle fillRectangle = new Rectangle(this.getBounds());
            if (this.rectPresentation.getCornerRadius() > 0) {
                Path path = this.createPath(fillRectangle, graphics, true, this.rectPresentation.getCornerRadius());
                graphics.clipPath(path);
            }
            if (bg instanceof SolidBackgroundDef) {
                Color color = (Color)((SolidBackgroundDef)bg).getColor().content();
                if (color != null) {
                    graphics.setBackgroundColor(this.resourceCache.getColor(color));
                } else {
                    graphics.setBackgroundColor(this.resourceCache.getColor(DEFAULT_BACKGROUND_END));
                }
                graphics.fillRectangle(fillRectangle);
            } else if (bg instanceof GradientBackgroundDef) {
                boolean isVertical = (Boolean)((GradientBackgroundDef)bg).isVertical().content();
                ElementList segments = ((GradientBackgroundDef)bg).getGradientSegments();
                org.eclipse.swt.graphics.Color backgroundStart = null;
                org.eclipse.swt.graphics.Color backgrounEnd = null;
                if (segments.size() == 0) {
                    backgrounEnd = this.resourceCache.getColor(DEFAULT_BACKGROUND_END);
                    backgroundStart = this.resourceCache.getColor(DEFAULT_BACKGROUND_START);
                } else if (segments.size() == 1) {
                    GradientSegmentDef segment0 = (GradientSegmentDef)segments.get(0);
                    backgroundStart = backgrounEnd = this.resourceCache.getColor((Color)segment0.getColor().content());
                } else {
                    GradientSegmentDef segment0 = (GradientSegmentDef)segments.get(0);
                    GradientSegmentDef segment1 = (GradientSegmentDef)segments.get(1);
                    backgrounEnd = this.resourceCache.getColor((Color)segment0.getColor().content());
                    backgroundStart = this.resourceCache.getColor((Color)segment1.getColor().content());
                }
                graphics.setForegroundColor(backgrounEnd);
                graphics.setBackgroundColor(backgroundStart);
                graphics.fillGradient(fillRectangle.x, fillRectangle.y, fillRectangle.width, fillRectangle.height, isVertical);
            }
            graphics.setForegroundColor(foregroundSave);
            graphics.setBackgroundColor(backgroundSave);
        }
    }

    public Dimension getMaximumSize() {
        if (this.getLayoutManager() instanceof SapphireSequenceLayout) {
            SapphireSequenceLayout sapphireSequenceLayout = (SapphireSequenceLayout)this.getLayoutManager();
            return sapphireSequenceLayout.calculateMaximumSize((IFigure)this);
        }
        if (this.getLayoutManager() instanceof SapphireStackLayout) {
            SapphireStackLayout sapphireStackLayout = (SapphireStackLayout)this.getLayoutManager();
            return sapphireStackLayout.calculateMaximumSize((IFigure)this);
        }
        return super.getMaximumSize();
    }

    @Override
    public void setSelected(boolean b) {
        this.selected = b;
        this.repaint();
    }

    @Override
    public void setFocus(boolean b) {
        this.repaint();
    }

    private Path createPath(Rectangle outerBounds, Graphics graphics, boolean isFill, int cornerRadius) {
        Path path = new Path(null);
        float x = outerBounds.x;
        float y = outerBounds.y;
        float height = outerBounds.height;
        float width = outerBounds.width;
        float bottom = y + height;
        float right = x + width;
        float cornerWidth = cornerRadius;
        float cornerHeight = cornerRadius;
        cornerWidth = cornerWidth > width ? width : cornerWidth;
        float f = cornerHeight = cornerHeight > height ? height : cornerHeight;
        if (isFill) {
            cornerHeight = Math.max(1.0f, cornerHeight - ((float)this.getLineWidth() + cornerHeight / 64.0f));
            cornerWidth = Math.max(1.0f, cornerWidth - ((float)this.getLineWidth() + cornerWidth / 64.0f));
        }
        if (cornerHeight <= 0.0f || cornerWidth <= 0.0f) {
            path.addRectangle(x, y, width, height);
        } else {
            path.moveTo(x, y);
            path.addArc(x, y, cornerWidth, cornerHeight, 90.0f, 90.0f);
            path.addArc(x, bottom - cornerHeight, cornerWidth, cornerHeight, 180.0f, 90.0f);
            path.addArc(right - cornerWidth, bottom - cornerHeight, cornerWidth, cornerHeight, 270.0f, 90.0f);
            path.addArc(right - cornerWidth, y, cornerWidth, cornerHeight, 0.0f, 90.0f);
            path.close();
        }
        return path;
    }
}

