/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.swt.gef.model.ContainerShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.RectangleModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeFactoryModel;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.ContainerShapePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapeFactoryPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class ShapeModelUtil {
    public static List<ShapeModel> collectActiveChildrenRecursively(ContainerShapeModel containerShapeModel) {
        ArrayList<ShapeModel> activeChildren = new ArrayList<ShapeModel>();
        List<ShapeModel> modelChildren = containerShapeModel.getChildren();
        for (ShapeModel shapeModel : modelChildren) {
            ShapePart shapePart = (ShapePart)shapeModel.getSapphirePart();
            if (!shapePart.isActive() && !(shapeModel instanceof RectangleModel)) continue;
            activeChildren.add(shapeModel);
        }
        return activeChildren;
    }

    public static ShapeModel getChildShapeModel(ShapeModel parent, ShapePart shapePart) {
        block4: {
            block3: {
                if (parent.getSapphirePart().equals(shapePart)) {
                    return parent;
                }
                if (!(parent instanceof ContainerShapeModel)) break block3;
                ContainerShapeModel container = (ContainerShapeModel)parent;
                for (ShapeModel child : container.getChildren()) {
                    ShapeModel model = ShapeModelUtil.getChildShapeModel(child, shapePart);
                    if (model == null) continue;
                    return model;
                }
                break block4;
            }
            if (!(parent instanceof ShapeFactoryModel)) break block4;
            ShapeFactoryModel container = (ShapeFactoryModel)parent;
            for (ShapeModel child : container.getChildren()) {
                ShapeModel model = ShapeModelUtil.getChildShapeModel(child, shapePart);
                if (model == null) continue;
                return model;
            }
        }
        return null;
    }

    public static ContainerShapeModel getNearestContainerModel(ShapeModel shapeModel) {
        if (shapeModel instanceof ContainerShapeModel) {
            return (ContainerShapeModel)shapeModel;
        }
        ShapeModel parentModel = shapeModel.getParent();
        while (!(parentModel instanceof ContainerShapeModel) && parentModel != null) {
            parentModel = parentModel.getParent();
        }
        return (ContainerShapeModel)parentModel;
    }

    public static ShapePresentation getChildShapePresentation(ShapePresentation parent, ShapePart shapePart) {
        block4: {
            block3: {
                if (parent.part().equals(shapePart)) {
                    return parent;
                }
                if (!(parent instanceof ContainerShapePresentation)) break block3;
                ContainerShapePresentation container = (ContainerShapePresentation)parent;
                for (ShapePresentation child : container.getChildren()) {
                    ShapePresentation presentation = ShapeModelUtil.getChildShapePresentation(child, shapePart);
                    if (presentation == null) continue;
                    return presentation;
                }
                break block4;
            }
            if (!(parent instanceof ShapeFactoryPresentation)) break block4;
            ShapeFactoryPresentation container = (ShapeFactoryPresentation)parent;
            for (ShapePresentation child : container.getChildren()) {
                ShapePresentation presentation = ShapeModelUtil.getChildShapePresentation(child, shapePart);
                if (presentation == null) continue;
                return presentation;
            }
        }
        return null;
    }
}

