/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.steps;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.steps.AbstractPeerNodeStep;
import org.eclipse.tcf.te.tcf.locator.utils.SimulatorUtils;
import org.osgi.framework.Bundle;

public class StartPingTimerStep
extends AbstractPeerNodeStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing or closed channel"));
        }
    }

    public void execute(final IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        SimulatorUtils.Result result = SimulatorUtils.getSimulatorService(this.getActivePeerModelContext(context, data, fullQualifiedId));
        boolean startClientPing = StepperAttributeUtil.getBooleanProperty((String)"org.eclipse.tcf.te.tcf.locator.start_client_ping", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (result == null && startClientPing) {
            final IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    final IPeerNode peerNode = StartPingTimerStep.this.getActivePeerModelContext(context, data, fullQualifiedId);
                    Map attrs = peerNode.getPeer().getAttributes();
                    int interval = 10000;
                    if (attrs.containsKey("pingInterval")) {
                        try {
                            interval = Integer.parseInt((String)attrs.get("pingInterval"));
                            interval *= 1000;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    int pingInterval = interval;
                    int timeout = 10000;
                    if (attrs.containsKey("pingTimeout")) {
                        try {
                            timeout = Integer.parseInt((String)attrs.get("pingTimeout"));
                            timeout *= 1000;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    final int pingTimeout = timeout;
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) {
                        CoreBundleActivator.getTraceHandler().trace("Interval=" + pingInterval + "ms Timeout=" + pingTimeout + "ms", "trace/ping", (Object)StartPingTimerStep.this);
                    }
                    if (pingInterval > 0 && pingTimeout > 0) {
                        String name = peerNode.getName();
                        final IDiagnostics diagnostics = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
                        if (diagnostics != null) {
                            final Timer pingTimer = new Timer(String.valueOf(name) + " ping");
                            TimerTask pingTask = new TimerTask(){
                                final AtomicBoolean running = new AtomicBoolean(false);

                                @Override
                                public void run() {
                                    block3: {
                                        try {
                                            if (!this.running.get()) {
                                                this.running.set(true);
                                                Protocol.invokeLater((Runnable)new Runnable(){
                                                    TimerTask timeoutTask = null;
                                                    long startTime = 0L;

                                                    @Override
                                                    public void run() {
                                                        block6: {
                                                            try {
                                                                if (peerNode.getConnectState() == 11) {
                                                                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) {
                                                                        this.startTime = System.currentTimeMillis();
                                                                        CoreBundleActivator.getTraceHandler().trace("Send ping.", "trace/ping", (Object)StartPingTimerStep.this);
                                                                    }
                                                                    diagnostics.echo("ping", new IDiagnostics.DoneEcho(){

                                                                        public void doneEcho(IToken token, Throwable error, String s) {
                                                                            if (!running.get()) {
                                                                                return;
                                                                            }
                                                                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) {
                                                                                long endTime = System.currentTimeMillis();
                                                                                CoreBundleActivator.getTraceHandler().trace("Received ping after " + (endTime - startTime) + "ms.", "trace/ping", (Object)StartPingTimerStep.this);
                                                                            }
                                                                            if (timeoutTask != null) {
                                                                                timeoutTask.cancel();
                                                                                timeoutTask = null;
                                                                            }
                                                                            running.set(false);
                                                                            if (error != null) {
                                                                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) {
                                                                                    CoreBundleActivator.getTraceHandler().trace("Received error '" + error.getMessage() + "'.", "trace/ping", (Object)StartPingTimerStep.this);
                                                                                }
                                                                                pingTimer.cancel();
                                                                            }
                                                                        }
                                                                    });
                                                                    this.timeoutTask = new TimerTask(){

                                                                        @Override
                                                                        public void run() {
                                                                            block3: {
                                                                                if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) {
                                                                                    long endTime = System.currentTimeMillis();
                                                                                    CoreBundleActivator.getTraceHandler().trace("Timeout after " + (endTime - startTime) + "ms.", "trace/ping", (Object)StartPingTimerStep.this);
                                                                                }
                                                                                try {
                                                                                    pingTimer.cancel();
                                                                                    running.set(false);
                                                                                    Protocol.invokeLater((Runnable)new Runnable(){

                                                                                        @Override
                                                                                        public void run() {
                                                                                            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) {
                                                                                                CoreBundleActivator.getTraceHandler().trace("Close channel.", "trace/ping", (Object)StartPingTimerStep.this);
                                                                                            }
                                                                                            channel.close();
                                                                                        }
                                                                                    });
                                                                                }
                                                                                catch (Throwable e) {
                                                                                    if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) break block3;
                                                                                    CoreBundleActivator.getTraceHandler().trace("Error '" + e.getMessage() + "'.", "trace/ping", (Object)StartPingTimerStep.this);
                                                                                }
                                                                            }
                                                                        }
                                                                    };
                                                                    pingTimer.schedule(this.timeoutTask, pingTimeout);
                                                                } else {
                                                                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) {
                                                                        CoreBundleActivator.getTraceHandler().trace("Connection no longer connected - cancel.", "trace/ping", (Object)StartPingTimerStep.this);
                                                                    }
                                                                    pingTimer.cancel();
                                                                }
                                                            }
                                                            catch (Throwable e) {
                                                                if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) break block6;
                                                                CoreBundleActivator.getTraceHandler().trace("Error '" + e.getMessage() + "'.", "trace/ping", (Object)StartPingTimerStep.this);
                                                            }
                                                        }
                                                    }
                                                });
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/ping")) break block3;
                                            CoreBundleActivator.getTraceHandler().trace("Error '" + e.getMessage() + "'.", "trace/ping", (Object)StartPingTimerStep.this);
                                        }
                                    }
                                }
                            };
                            pingTimer.schedule(pingTask, pingInterval, (long)pingInterval);
                        } else if (Platform.inDebugMode()) {
                            Platform.getLog((Bundle)CoreBundleActivator.getDefault().getBundle()).log((IStatus)new Status(2, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.StartPingTimerStep_warning_noDiagnosticsService, (Object)name)));
                        }
                    }
                }
            });
        }
        this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
    }
}

