/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.debuginfo.UstDebugInfoStateProvider;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryFile;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoLoadedBinaryFile;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfUtils;

public class UstDebugInfoAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.debuginfo";

    protected ITmfStateProvider createStateProvider() {
        return new UstDebugInfoStateProvider((LttngUstTrace)((Object)NonNullUtils.checkNotNull((Object)((Object)this.getTrace()))));
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!(trace instanceof LttngUstTrace)) {
            return false;
        }
        return super.setTrace(trace);
    }

    public @Nullable LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return Collections.EMPTY_SET;
    }

    public boolean canExecute(ITmfTrace trace) {
        if (!(trace instanceof LttngUstTrace)) {
            return false;
        }
        LttngUstTrace ustTrace = (LttngUstTrace)trace;
        String tracerName = CtfUtils.getTracerName((CtfTmfTrace)ustTrace);
        int majorVersion = CtfUtils.getTracerMajorVersion((CtfTmfTrace)ustTrace);
        int minorVersion = CtfUtils.getTracerMinorVersion((CtfTmfTrace)ustTrace);
        if (!"lttng-ust".equals(tracerName)) {
            return false;
        }
        if (majorVersion < 2) {
            return false;
        }
        if (majorVersion == 2 && minorVersion < 8) {
            return false;
        }
        return super.canExecute(trace);
    }

    public Collection<UstDebugInfoBinaryFile> getAllBinaries() {
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return Collections.EMPTY_SET;
        }
        @NonNull TreeSet<UstDebugInfoBinaryFile> files = new TreeSet<UstDebugInfoBinaryFile>();
        ImmutableList.Builder builder = ImmutableList.builder();
        List vpidQuarks = ss.getSubAttributes(-1, false);
        for (Integer vpidQuark : vpidQuarks) {
            builder.addAll((Iterable)ss.getSubAttributes(vpidQuark.intValue(), false));
        }
        ImmutableList baddrQuarks = builder.build();
        try {
            for (Integer baddrQuark : baddrQuarks) {
                int buildIdQuark = ss.getQuarkRelative(baddrQuark.intValue(), new String[]{"build_id"});
                int debugLinkQuark = ss.getQuarkRelative(baddrQuark.intValue(), new String[]{"debug_link"});
                int pathQuark = ss.getQuarkRelative(baddrQuark.intValue(), new String[]{"path"});
                int isPICQuark = ss.getQuarkRelative(baddrQuark.intValue(), new String[]{"is_pic"});
                long ts = ss.getStartTime();
                ITmfStateInterval interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)baddrQuark, (long)ts, (long)Long.MAX_VALUE);
                while (interval != null) {
                    ts = interval.getStartTime();
                    ITmfStateValue filePathStateValue = ss.querySingleState(ts, pathQuark).getStateValue();
                    String filePath = filePathStateValue.unboxStr();
                    ITmfStateValue buildIdStateValue = ss.querySingleState(ts, buildIdQuark).getStateValue();
                    String buildId = UstDebugInfoAnalysisModule.unboxStrOrNull(buildIdStateValue);
                    ITmfStateValue debuglinkStateValue = ss.querySingleState(ts, debugLinkQuark).getStateValue();
                    String debugLink = UstDebugInfoAnalysisModule.unboxStrOrNull(debuglinkStateValue);
                    ITmfStateValue isPICStateValue = ss.querySingleState(ts, isPICQuark).getStateValue();
                    Boolean isPIC = isPICStateValue.unboxInt() != 0;
                    files.add(new UstDebugInfoBinaryFile(filePath, buildId, debugLink, isPIC));
                    ts = interval.getEndTime() + 1L;
                    interval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ss, (int)baddrQuark, (long)ts, (long)Long.MAX_VALUE);
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return files;
    }

    @VisibleForTesting
    public @Nullable UstDebugInfoLoadedBinaryFile getMatchingFile(long ts, long vpid, long ip) {
        int baddrQuark;
        long baddr2;
        List state;
        ITmfStateSystem ss;
        block7: {
            OptionalLong potentialBaddr;
            block6: {
                block5: {
                    ss = this.getStateSystem();
                    if (ss != null) break block5;
                    return null;
                }
                List possibleBaddrQuarks = ss.getQuarks(new String[]{String.valueOf(vpid), "*"});
                state = ss.queryFullState(ts);
                potentialBaddr = possibleBaddrQuarks.stream().filter(quark -> Objects.equals(1, ((ITmfStateInterval)state.get((int)quark)).getValue())).map(arg_0 -> ((ITmfStateSystem)ss).getAttributeName(arg_0)).mapToLong(Long::parseLong).filter(baddr -> baddr <= ip).max();
                if (potentialBaddr.isPresent()) break block6;
                return null;
            }
            baddr2 = potentialBaddr.getAsLong();
            baddrQuark = ss.getQuarkAbsolute(new String[]{String.valueOf(vpid), String.valueOf(baddr2)});
            int memszQuark = ss.getQuarkRelative(baddrQuark, new String[]{"memsz"});
            long memsz = ((ITmfStateInterval)state.get(memszQuark)).getStateValue().unboxLong();
            if (ip < baddr2 + memsz) break block7;
            return null;
        }
        try {
            int pathQuark = ss.getQuarkRelative(baddrQuark, new String[]{"path"});
            String filePath = ((ITmfStateInterval)state.get(pathQuark)).getStateValue().unboxStr();
            int buildIdQuark = ss.getQuarkRelative(baddrQuark, new String[]{"build_id"});
            ITmfStateValue buildIdValue = ((ITmfStateInterval)state.get(buildIdQuark)).getStateValue();
            String buildId = UstDebugInfoAnalysisModule.unboxStrOrNull(buildIdValue);
            int debugLinkQuark = ss.getQuarkRelative(baddrQuark, new String[]{"debug_link"});
            ITmfStateValue debugLinkValue = ((ITmfStateInterval)state.get(debugLinkQuark)).getStateValue();
            String debugLink = UstDebugInfoAnalysisModule.unboxStrOrNull(debugLinkValue);
            int isPicQuark = ss.getQuarkRelative(baddrQuark, new String[]{"is_pic"});
            boolean isPic = ((ITmfStateInterval)state.get(isPicQuark)).getStateValue().unboxInt() != 0;
            return new UstDebugInfoLoadedBinaryFile(baddr2, filePath, buildId, debugLink, isPic);
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            return null;
        }
    }

    private static @Nullable String unboxStrOrNull(ITmfStateValue value) {
        return value.isNull() ? null : value.unboxStr();
    }
}

