/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlLocationCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlMappingGroupCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlMapEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlPatternEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.ISegmentListener;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternSegmentStoreModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlPatternStateProvider
extends AbstractTmfStateProvider
implements IXmlStateSystemContainer {
    private final Path fFilePath;
    private final @NonNull String fStateId;
    private final Map<Integer, TmfAttributePool> fAttributePools = new HashMap<Integer, TmfAttributePool>();
    private final @NonNull Set<@NonNull TmfXmlLocation> fLocations;
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull TmfXmlMapEntry>> fMappingGroups;
    private final @NonNull Map<@NonNull String, @NonNull String> fStoredFields = new HashMap<String, String>();
    private final TmfXmlPatternEventHandler fHandler;
    private final ISegmentListener fListener;
    private final @NonNull TmfXmlScenarioHistoryBuilder fHistoryBuilder;
    private final AnalysisCompilationData fAnalysisCompilationData;

    public XmlPatternStateProvider(@NonNull ITmfTrace trace, @NonNull String stateid, @Nullable Path file, ISegmentListener listener) {
        super(trace, stateid);
        AnalysisCompilationData analysisData;
        this.fStateId = stateid;
        this.fFilePath = file;
        this.fListener = listener;
        this.fHistoryBuilder = new TmfXmlScenarioHistoryBuilder();
        String pathString = this.fFilePath.toAbsolutePath().toString();
        Element doc = TmfXmlUtils.getElementInFile(pathString, "pattern", this.fStateId);
        if (doc == null) {
            throw new IllegalArgumentException("XmlPatternStateProvider: Cannot find pattern element in file " + pathString);
        }
        NodeList storedFieldNodes = doc.getElementsByTagName("storedField");
        int i = 0;
        while (i < storedFieldNodes.getLength()) {
            Element element = (Element)storedFieldNodes.item(i);
            String key = element.getAttribute("alias");
            this.fStoredFields.put(element.getAttribute("id"), key.isEmpty() ? element.getAttribute("id") : key);
            ++i;
        }
        this.fAnalysisCompilationData = analysisData = new AnalysisCompilationData();
        List<@NonNull Element> childElements = TmfXmlUtils.getChildElements(doc, "definedValue");
        for (Element element : childElements) {
            analysisData.addDefinedValue(element.getAttribute("name"), element.getAttribute("value"));
        }
        childElements = TmfXmlUtils.getChildElements(doc, "location");
        for (Element element : childElements) {
            TmfXmlLocationCu.compile(analysisData, element);
        }
        ArrayList<TmfXmlMappingGroupCu> mapGroups = new ArrayList<TmfXmlMappingGroupCu>();
        childElements = TmfXmlUtils.getChildElements(doc, "mappingGroup");
        for (Element map : childElements) {
            TmfXmlMappingGroupCu compile = TmfXmlMappingGroupCu.compile(analysisData, map);
            if (compile == null) {
                throw new NullPointerException("Problem compiling a mapping group");
            }
            mapGroups.add(compile);
        }
        ITmfXmlModelFactory modelFactory = TmfXmlReadWriteModelFactory.getInstance();
        NodeList locationNodes = doc.getElementsByTagName("location");
        HashSet<@NonNull TmfXmlLocation> locations = new HashSet<TmfXmlLocation>();
        int i2 = 0;
        while (i2 < locationNodes.getLength()) {
            Element element = (Element)locationNodes.item(i2);
            if (element != null) {
                TmfXmlLocation location = modelFactory.createLocation(element, this);
                locations.add(location);
            }
            ++i2;
        }
        this.fLocations = Collections.unmodifiableSet(locations);
        @NonNull HashMap<@NonNull String, @NonNull HashSet<@NonNull E>> mapGroups2 = new HashMap();
        NodeList mapNodes = doc.getElementsByTagName("mappingGroup");
        int i3 = 0;
        while (i3 < mapNodes.getLength()) {
            Element map = (Element)mapNodes.item(i3);
            String id = map.getAttribute("id");
            HashSet<@NonNull TmfXmlMapEntry> entrySet = (HashSet<TmfXmlMapEntry>)mapGroups2.get(id);
            if (entrySet == null) {
                entrySet = new HashSet<TmfXmlMapEntry>();
                mapGroups2.put(id, entrySet);
            }
            NodeList entryNodes = map.getElementsByTagName("entry");
            int j = 0;
            while (j < entryNodes.getLength()) {
                Element entryElement = (Element)entryNodes.item(j);
                if (entryElement != null) {
                    TmfXmlMapEntry entry = modelFactory.createMapEntry(entryElement, this);
                    entrySet.add(entry);
                }
                ++j;
            }
            ++i3;
        }
        this.fMappingGroups = Collections.unmodifiableMap(mapGroups2);
        NodeList nodes = doc.getElementsByTagName("patternHandler");
        this.fHandler = modelFactory.createPatternEventHandler((Element)NonNullUtils.checkNotNull((Object)((Element)nodes.item(0))), this);
    }

    @Override
    public String getAttributeValue(String name) {
        String attribute = name;
        if (attribute.startsWith("$")) {
            attribute = this.getDefinedValue(attribute.substring(1));
        }
        return attribute;
    }

    public String getDefinedValue(String constant) {
        if (constant != null) {
            return this.fAnalysisCompilationData.getStringValue(constant);
        }
        return null;
    }

    public @NonNull Map<@NonNull String, @NonNull String> getStoredFields() {
        return this.fStoredFields;
    }

    public int getVersion() {
        return 0;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new XmlPatternStateProvider(this.getTrace(), this.getStateId(), this.fFilePath, this.fListener);
    }

    public @NonNull String getStateId() {
        return this.fStateId;
    }

    @Override
    public ITmfStateSystem getStateSystem() {
        ITmfStateSystemBuilder ss = this.getStateSystemBuilder();
        if (ss == null) {
            throw new NullPointerException("The state system should not be requested at this point, it is null");
        }
        return ss;
    }

    @Override
    public @NonNull Iterable<@NonNull TmfXmlLocation> getLocations() {
        return this.fLocations;
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        this.fHandler.handleEvent(event);
    }

    public ISegmentListener getListener() {
        return this.fListener;
    }

    public void dispose() {
        this.waitForEmptyQueue();
        this.fListener.onNewSegment(XmlPatternSegmentStoreModule.END_SEGMENT);
        this.fHandler.dispose();
        super.dispose();
    }

    public @NonNull TmfXmlScenarioHistoryBuilder getHistoryBuilder() {
        return this.fHistoryBuilder;
    }

    public @Nullable Set<@NonNull TmfXmlMapEntry> getLegacyMappingGroup(@NonNull String id) {
        return this.fMappingGroups.get(id);
    }

    @Override
    public @Nullable TmfAttributePool getAttributePool(int startNodeQuark) {
        ITmfStateSystem ss = this.getStateSystem();
        if (!(ss instanceof ITmfStateSystemBuilder)) {
            throw new IllegalStateException("The state system hasn't been initialized yet");
        }
        TmfAttributePool pool = this.fAttributePools.get(startNodeQuark);
        if (pool == null) {
            pool = new TmfAttributePool((ITmfStateSystemBuilder)ss, Integer.valueOf(startNodeQuark), TmfAttributePool.QueueType.PRIORITY);
            this.fAttributePools.put(startNodeQuark, pool);
        }
        return pool;
    }

    @Override
    public AnalysisCompilationData getAnalysisCompilationData() {
        return this.fAnalysisCompilationData;
    }
}

