/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpression;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpressionNotCu;

public class FilterSimpleExpressionCu {
    private String fField;
    private BiPredicate<String, String> fOperator;
    private String fValue;

    public FilterSimpleExpressionCu(String field, BiPredicate<String, String> op, String value) {
        this.fField = field;
        this.fOperator = op;
        this.fValue = value;
    }

    protected String getField() {
        return this.fField;
    }

    protected BiPredicate<String, String> getOperator() {
        return this.fOperator;
    }

    protected String getValue() {
        return this.fValue;
    }

    public static FilterSimpleExpressionCu compile(CommonTree tree) {
        if (tree.getToken() == null) {
            return null;
        }
        int childCount = tree.getChildCount();
        switch (tree.getToken().getType()) {
            case 4: 
            case 15: {
                StringBuilder paragraph = new StringBuilder();
                FilterSimpleExpressionCu.extractParagraph(tree, paragraph, 0, childCount);
                return new FilterSimpleExpressionCu("*", ConditionOperator.MATCHES, paragraph.toString().trim());
            }
            case 7: {
                String left = tree.getChild(0).getText();
                BiPredicate<String, String> op = FilterSimpleExpressionCu.getConditionOperator(tree.getChild(1).getText());
                String right = tree.getChild(2).getText();
                return new FilterSimpleExpressionCu(left, op, right);
            }
            case 8: {
                String left1 = tree.getChild(0).getText();
                BiPredicate<String, String> op1 = FilterSimpleExpressionCu.getConditionOperator(tree.getChild(1).getText());
                String right1 = null;
                return new FilterSimpleExpressionCu(left1, op1, right1);
            }
            case 9: 
            case 11: 
            case 12: {
                StringBuilder builder = new StringBuilder();
                int index = FilterSimpleExpressionCu.extractParagraph(tree, builder, 0, childCount);
                String left2 = builder.toString().trim();
                BiPredicate<String, String> op2 = FilterSimpleExpressionCu.getConditionOperator(tree.getChild(index++).getText());
                builder = new StringBuilder();
                FilterSimpleExpressionCu.extractParagraph(tree, builder, index, childCount);
                String right2 = builder.toString().trim();
                return new FilterSimpleExpressionCu(left2, op2, right2);
            }
            case 10: {
                StringBuilder builder1 = new StringBuilder();
                int index1 = FilterSimpleExpressionCu.extractParagraph(tree, builder1, 0, childCount);
                String left3 = builder1.toString().trim();
                BiPredicate<String, String> op3 = FilterSimpleExpressionCu.getConditionOperator(tree.getChild(index1).getText());
                String right3 = null;
                return new FilterSimpleExpressionCu(left3, op3, right3);
            }
            case 17: {
                if (childCount == 0 || childCount == 2 && tree.getChild(1).getType() != 4) {
                    return null;
                }
                boolean negate = tree.getChild(0).getText().equals("!");
                CommonTree expression = (CommonTree)tree.getChild(childCount - 1);
                FilterSimpleExpressionCu compiled = negate ? FilterSimpleExpressionNotCu.compile(expression) : FilterSimpleExpressionCu.compile(expression);
                return compiled;
            }
        }
        return null;
    }

    private static int extractParagraph(CommonTree tree, StringBuilder builder, int index, int count) {
        String separator = " ";
        boolean stop = false;
        int i = index;
        while (i < count && !stop) {
            Tree child = tree.getChild(i);
            if (child.getType() != 19) {
                stop = true;
            } else {
                builder.append(child.getText());
                builder.append(separator);
            }
            ++i;
        }
        return --i;
    }

    public FilterSimpleExpression generate() {
        return new FilterSimpleExpression(this.fField, this.fOperator, this.fValue);
    }

    private static BiPredicate<String, String> getConditionOperator(String equationType) {
        switch (equationType) {
            case "==": {
                return ConditionOperator.EQ;
            }
            case "!=": {
                return ConditionOperator.NE;
            }
            case "matches": {
                return ConditionOperator.MATCHES;
            }
            case "contains": {
                return ConditionOperator.CONTAINS;
            }
            case "present": {
                return ConditionOperator.PRESENT;
            }
            case ">": {
                return ConditionOperator.GT;
            }
            case "<": {
                return ConditionOperator.LT;
            }
        }
        throw new IllegalArgumentException("FilterSimpleExpression: invalid comparison operator.");
    }

    protected static enum ConditionOperator implements BiPredicate<String, String>
    {
        EQ((i, j) -> ConditionOperator.equals(i, j)),
        NE((i, j) -> !ConditionOperator.equals(i, j)),
        MATCHES(ConditionOperator.matchFunc()),
        CONTAINS((i, j) -> i.contains((CharSequence)j)),
        LT((i, j) -> ConditionOperator.numericalCompare(i, j) < 0),
        GT((i, j) -> ConditionOperator.numericalCompare(i, j) > 0),
        PRESENT((i, j) -> true);

        private final BiFunction<String, String, Boolean> fCmpFunction;

        private ConditionOperator(BiFunction<String, String, Boolean> cmpFunction) {
            this.fCmpFunction = cmpFunction;
        }

        private static BiFunction<String, String, Boolean> matchFunc() {
            return (i, j) -> {
                try {
                    Pattern filterPattern = Pattern.compile(j);
                    return filterPattern.matcher((CharSequence)i).find();
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            };
        }

        private static boolean equals(String i, String j) {
            if (Objects.equals(i, j)) {
                return true;
            }
            Number number1 = ConditionOperator.toNumber(i);
            if (number1 == null) {
                return false;
            }
            Number number2 = ConditionOperator.toNumber(j);
            if (number2 == null) {
                return false;
            }
            if (number1 instanceof Double || number2 instanceof Double || number1 instanceof Float || number2 instanceof Float) {
                return number1.doubleValue() == number2.doubleValue();
            }
            return number1.longValue() == number2.longValue();
        }

        private static int numericalCompare(String i, String j) {
            Number number1 = ConditionOperator.toNumber(i);
            if (number1 == null) {
                return 0;
            }
            Number number2 = ConditionOperator.toNumber(j);
            if (number2 == null) {
                return 0;
            }
            if (number1 instanceof Double || number2 instanceof Double || number1 instanceof Float || number2 instanceof Float) {
                return Double.compare(number1.doubleValue(), number2.doubleValue());
            }
            return Long.compare(number1.longValue(), number2.longValue());
        }

        private static Number toNumber(String value) {
            try {
                return Long.decode(value);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return NumberFormat.getInstance().parse(value);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        }

        @Override
        public boolean test(String arg0, String arg1) {
            return Objects.requireNonNull(this.fCmpFunction.apply(arg0, arg1));
        }
    }
}

