/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.ui.internal.actions.SmartRenameAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageReferenceCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public final class AddInputCommand
extends AddMessageReferenceCommand {
    private Input originalInput;

    public AddInputCommand(Operation operation, String name) {
        super(operation, name);
    }

    public AddInputCommand(Operation operation, String name, boolean createMessage) {
        super(operation, name, createMessage);
    }

    public AddInputCommand(Operation operation, Input originalInput, String name) {
        super(operation, name, false);
        this.originalInput = originalInput;
    }

    public void run() {
        this.messageReference = WSDLFactory.eINSTANCE.createInput();
        this.messageReference.setEnclosingDefinition(this.operation.getEnclosingDefinition());
        this.operation.setInput((javax.wsdl.Input)((Input)this.messageReference));
        if (this.originalInput == null) {
            if (this.createMessage) {
                this.createMessage();
            }
        } else if (this.originalInput.getEMessage() != null) {
            String originalMsgName = this.originalInput.getEMessage().getQName().getLocalPart();
            boolean gened = false;
            if (this.originalInput.eContainer() instanceof Operation) {
                gened = SmartRenameAction.isMessageNameGenerated(originalMsgName, ((Operation)this.originalInput.eContainer()).getName(), "Request");
            }
            String newMsgName = "";
            if (gened) {
                newMsgName = NameUtil.buildUniqueMessageName(this.operation.getEnclosingDefinition(), this.messageReference);
            } else {
                Definition definition = this.operation.getEnclosingDefinition();
                Message tMessage = this.originalInput.getEMessage();
                newMsgName = NameUtil.buildUniqueMessageName(definition, tMessage.getQName().getLocalPart());
            }
            this.createMessage((MessageReference)this.originalInput, newMsgName);
        }
    }
}

