/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.lang.reflect.Field;
import java.util.HashMap;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.spi.Setter;

public class MapSetter
implements Setter {
    private final Field f;
    private final Object bean;

    public MapSetter(Object bean, Field f) {
        this.f = f;
        this.bean = bean;
    }

    public Class getType() {
        return this.f.getType();
    }

    public boolean isMultiValued() {
        return false;
    }

    public void addValue(Object value) {
        String mapValue;
        if (String.valueOf(value).indexOf(61) == -1) {
            throw new RuntimeException(Messages.FORMAT_ERROR_FOR_MAP.format(new Object[0]));
        }
        String[] parts = String.valueOf(value).split("=");
        String mapKey = parts[0];
        String string = mapValue = parts.length > 1 ? parts[1] : null;
        if (mapKey == null || mapKey.length() == 0) {
            throw new RuntimeException(Messages.MAP_HAS_NO_KEY.format(new Object[0]));
        }
        try {
            this.addValue(mapKey, mapValue);
        }
        catch (IllegalAccessException _) {
            this.f.setAccessible(true);
            try {
                this.addValue(mapKey, mapValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
        }
    }

    private void addValue(Object key, Object value) throws IllegalArgumentException, IllegalAccessException {
        HashMap<Object, Object> map = (HashMap<Object, Object>)this.f.get(this.bean);
        if (map == null) {
            map = new HashMap<Object, Object>();
            this.f.set(this.bean, map);
        }
        map.put(key, value);
    }
}

