/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.StringTokenizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.impl.StockSeriesImpl;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.ChartPreviewPainter;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;

public class StockChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Stock Chart";
    protected static final String STANDARD_SUBTYPE_LITERAL = "Standard Stock Chart";
    protected static final String BAR_STICK_SUBTYPE_LITERAL = "Bar Stick Stock Chart";
    private static final String sCandleStickDescription = Messages.getString("StockChart.Txt.CandleStickDescription");
    private static final String sBarStickDescription = Messages.getString("StockChart.Txt.BarStickDescription");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/stockcharticon.gif");
    private transient Image img2DCandleStick = null;
    private transient Image img2DBarlStick = null;

    public StockChart() {
        this.chartTitle = Messages.getString("StockChart.Txt.DefaultStockChartTitle");
    }

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("StockChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            if (orientation.equals((Object)Orientation.VERTICAL_LITERAL)) {
                this.img2DCandleStick = UIHelper.getImage((String)"icons/wizban/stockchartimage.gif");
                this.img2DBarlStick = UIHelper.getImage((String)"icons/wizban/stockchartbarstickimage.gif");
            } else {
                this.img2DCandleStick = UIHelper.getImage((String)"icons/wizban/horizontalstockchartimage.gif");
                this.img2DBarlStick = UIHelper.getImage((String)"icons/wizban/horizontalstockchartbarstickimage.gif");
            }
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STANDARD_SUBTYPE_LITERAL, this.img2DCandleStick, sCandleStickDescription, Messages.getString("StockChart.SubType.CandleStick")));
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(BAR_STICK_SUBTYPE_LITERAL, this.img2DBarlStick, sBarStickDescription, Messages.getString("StockChart.SubType.BarStick")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.createDefault();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        ChartElementUtil.setEObjectAttribute((EObject)newChart, (String)"orientation", (Object)orientation, (orientation == null ? 1 : 0) != 0);
        ChartElementUtil.setEObjectAttribute((EObject)newChart, (String)"dimension", (Object)this.getDimensionFor(sDimension), (sDimension == null ? 1 : 0) != 0);
        try {
            ChartElementUtil.setDefaultValue((Object)newChart.getAxes().get(0), (String)"categoryAxis", (Object)true);
        }
        catch (ChartException chartException) {}
        Axis xAxis = (Axis)newChart.getAxes().get(0);
        SeriesDefinition sdX = SeriesDefinitionImpl.createDefault();
        Series categorySeries = SeriesImpl.createDefault();
        sdX.getSeries().add((Object)categorySeries);
        xAxis.getSeriesDefinitions().add((Object)sdX);
        Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
        SeriesDefinition sdY = SeriesDefinitionImpl.createDefault();
        Series valueSeries = StockSeriesImpl.createDefault();
        if (BAR_STICK_SUBTYPE_LITERAL.equals(sSubType)) {
            ((StockSeries)valueSeries).setShowAsBarStick(true);
        }
        sdY.getSeries().add((Object)valueSeries);
        yAxis.getSeriesDefinitions().add((Object)sdY);
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("01/25/2005,01/26/2005");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("5,4,12");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        newChart.setSampleData(sd);
    }

    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Axis xAxis;
        Chart helperModel = currentChart.copyInstance();
        helperModel.eAdapters().addAll((Collection)currentChart.eAdapters());
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        IChartType oldType = ChartUIUtil.getChartType((String)currentChart.getType());
        if (currentChart instanceof ChartWithAxes) {
            xAxis = (Axis)((ChartWithAxes)currentChart).getAxes().get(0);
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                if (!currentChart.getSubType().equals(sNewSubType)) {
                    currentChart.setSubType(sNewSubType);
                    for (Axis yAxis : xAxis.getAssociatedAxes()) {
                        yAxis.unsetPercent();
                        for (SeriesDefinition ysd : yAxis.getSeriesDefinitions()) {
                            Series series = ysd.getDesignTimeSeries();
                            series.unsetStacked();
                            if (!(series instanceof StockSeries)) continue;
                            ((StockSeries)series).setShowAsBarStick(BAR_STICK_SUBTYPE_LITERAL.equals(currentChart.getSubType()));
                        }
                    }
                }
            } else {
                if (!currentChart.getType().equals(TYPE_LITERAL)) {
                    currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), false));
                }
                currentChart.setType(TYPE_LITERAL);
                Text title = currentChart.getTitle().getLabel().getCaption();
                if (title.getValue() != null && (title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim()))) {
                    title.setValue(this.getDefaultTitle());
                }
                currentChart.setSubType(sNewSubType);
                int seriesIndex = 0;
                for (Axis yAxis : xAxis.getAssociatedAxes()) {
                    if (!ChartPreviewPainter.isLivePreviewActive()) {
                        yAxis.setType(AxisType.LINEAR_LITERAL);
                    }
                    yAxis.unsetPercent();
                    for (SeriesDefinition ysd : yAxis.getSeriesDefinitions()) {
                        Series series = ysd.getDesignTimeSeries();
                        series = this.getConvertedSeries(series, seriesIndex);
                        series.unsetStacked();
                        ysd.getSeries().clear();
                        ysd.getSeries().add((Object)series);
                        ++seriesIndex;
                    }
                }
            }
        } else {
            currentChart = ChartWithAxesImpl.createDefault();
            this.copyChartProperties(helperModel, currentChart);
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"orientation", (Object)newOrientation, (newOrientation == null ? 1 : 0) != 0);
            ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"dimension", (Object)this.getDimensionFor(sNewDimension), (sNewDimension == null ? 1 : 0) != 0);
            try {
                ChartElementUtil.setDefaultValue((Object)((ChartWithAxes)currentChart).getAxes().get(0), (String)"categoryAxis", (Object)true);
            }
            catch (ChartException chartException) {}
            xAxis = (Axis)((ChartWithAxes)currentChart).getAxes().get(0);
            Axis yAxis = (Axis)xAxis.getAssociatedAxes().get(0);
            currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), true));
            xAxis.getSeriesDefinitions().clear();
            xAxis.getSeriesDefinitions().add((Object)((SeriesDefinition)((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0)));
            yAxis.getSeriesDefinitions().clear();
            yAxis.getSeriesDefinitions().addAll((Collection)((SeriesDefinition)xAxis.getSeriesDefinitions().get(0)).getSeriesDefinitions());
            SeriesDefinition bsd = (SeriesDefinition)xAxis.getSeriesDefinitions().get(0);
            Series series = bsd.getDesignTimeSeries();
            bsd.getSeries().clear();
            bsd.getSeries().add((Object)series);
            int j = 0;
            for (SeriesDefinition vsd : yAxis.getSeriesDefinitions()) {
                series = vsd.getDesignTimeSeries();
                series = this.getConvertedSeries(series, j++);
                series.getLabel().unsetVisible();
                series.unsetStacked();
                vsd.getSeries().clear();
                vsd.getSeries().add((Object)series);
            }
            Text title = currentChart.getTitle().getLabel().getCaption();
            if (title.getValue() != null && (title.getValue().trim().length() == 0 || title.getValue().trim().equals(oldType.getDefaultTitle().trim()))) {
                title.setValue(this.getDefaultTitle());
            }
        }
        ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"orientation", (Object)newOrientation, (newOrientation == null ? 1 : 0) != 0);
        ChartElementUtil.setEObjectAttribute((EObject)currentChart, (String)"dimension", (Object)this.getDimensionFor(sNewDimension), (sNewDimension == null ? 1 : 0) != 0);
        ChartUIUtil.restoreLabelPositionFromCache((Chart)currentChart);
        SeriesGrouping sg = ((SeriesDefinition)ChartUtil.getBaseSeriesDefinitions((Chart)currentChart).get(0)).getGrouping();
        if (sg.getGroupType().getValue() == 1) {
            ChartUIUtil.updateDefaultAggregations((Chart)currentChart);
        }
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals(SeriesImpl.class.getName())) {
            return series;
        }
        StockSeries stockseries = (StockSeries)ChartCacheManager.getInstance().findSeries(StockSeriesImpl.class.getName(), seriesIndex);
        if (stockseries == null) {
            stockseries = (StockSeries)StockSeriesImpl.createDefault();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)stockseries);
        return stockseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, boolean convertBaseToDate) {
        if (convertBaseToDate) {
            ArrayList<BaseSampleData> vNewBaseSampleData = new ArrayList<BaseSampleData>();
            for (BaseSampleData bsd : currentSampleData.getBaseSampleData()) {
                bsd.setDataSetRepresentation(this.getConvertedBaseSampleDataRepresentation(bsd.getDataSetRepresentation()));
                vNewBaseSampleData.add(bsd);
            }
            currentSampleData.getBaseSampleData().clear();
            currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        }
        ArrayList<OrthogonalSampleData> vNewOrthogonalSampleData = new ArrayList<OrthogonalSampleData>();
        int i = 0;
        for (OrthogonalSampleData osd : currentSampleData.getOrthogonalSampleData()) {
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)AxisType.LINEAR_LITERAL, (String)osd.getDataSetRepresentation(), (int)i++));
            vNewOrthogonalSampleData.add(osd);
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    private String getConvertedBaseSampleDataRepresentation(String sOldRepresentation) {
        StringTokenizer strtok = new StringTokenizer(sOldRepresentation, ",");
        StringBuffer sbNewRepresentation = new StringBuffer("");
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        int iValueCount = 0;
        while (strtok.hasMoreTokens()) {
            Calendar cal;
            String sElement = strtok.nextToken().trim();
            if (!sElement.startsWith("'")) {
                cal = Calendar.getInstance();
                cal.set(5, cal.get(5) + iValueCount);
                sbNewRepresentation.append(sdf.format(cal.getTime()));
                ++iValueCount;
            } else {
                sElement = sElement.substring(1, sElement.length() - 1);
                try {
                    sdf.parse(sElement);
                    sbNewRepresentation.append(sElement);
                }
                catch (ParseException parseException) {
                    cal = Calendar.getInstance();
                    cal.set(5, cal.get(5) + iValueCount);
                    sbNewRepresentation.append(sdf.format(cal.getTime()));
                    ++iValueCount;
                }
            }
            sbNewRepresentation.append(",");
        }
        return sbNewRepresentation.toString().substring(0, sbNewRepresentation.length() - 1);
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return false;
    }

    private ChartDimension getDimensionFor(String sDimension) {
        return ChartDimension.TWO_DIMENSIONAL_LITERAL;
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("StockChart.Txt.DisplayName");
    }

    public Series getSeries() {
        return this.getSeries(true);
    }

    public Series getSeries(boolean needInitialing) {
        if (needInitialing) {
            return StockSeriesImpl.create();
        }
        return StockSeriesImpl.createDefault();
    }

    public boolean canCombine() {
        return true;
    }
}

