/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.wizard.IWizardPage;

public class DataSourceSelectionHelper {
    private static final String DTP_ODA_EXT_POINT = "org.eclipse.datatools.connectivity.oda.dataSource";
    public static final String SCRIPT_DATA_SOURCE_DISPLAY_NAME = Messages.getString((String)"DataSourceSelectionPage.ScriptDataSource.DisplayName");
    public static final String CASSANDRA_DATA_SOURCE_DISPLAY_NAME = Messages.getString((String)"CassandraScriptedDataSource.display.name");

    public Object[] getFilteredDataSourceArray() {
        ManifestExplorer.Filter aFilter = ManifestExplorer.createFilter();
        aFilter.setMissingDataSetTypesFilter(true);
        aFilter.setDeprecatedFilter(true);
        ExtensionManifest[] dataSources = ManifestExplorer.getInstance().getExtensionManifests(DTP_ODA_EXT_POINT, aFilter);
        if (dataSources == null) {
            dataSources = new ExtensionManifest[]{};
        }
        Object[] newArray = new Object[dataSources.length + 2];
        int i = 0;
        while (i < dataSources.length) {
            newArray[i] = dataSources[i];
            ++i;
        }
        newArray[dataSources.length] = SCRIPT_DATA_SOURCE_DISPLAY_NAME;
        newArray[dataSources.length + 1] = CASSANDRA_DATA_SOURCE_DISPLAY_NAME;
        return newArray;
    }

    public boolean hasNextPage(Object selectedObject) {
        if (selectedObject == null) {
            return false;
        }
        if (selectedObject instanceof ExtensionManifest) {
            IConfigurationElement[] elements;
            if (DesignSessionUtil.hasValidOdaDesignUIExtension((String)((ExtensionManifest)selectedObject).getDataSourceElementID())) {
                return true;
            }
            IConfigurationElement dataSourceElement = DataSetProvider.findDataSourceElement((String)((ExtensionManifest)selectedObject).getExtensionID());
            if (dataSourceElement != null && (elements = dataSourceElement.getChildren("newDataSourceWizard")) != null && elements.length > 0) {
                return true;
            }
        }
        return false;
    }

    public IWizardPage getNextPage(Object selectedObject) {
        return null;
    }

    public DataSourceHandle createNoneOdaDataSourceHandle(String dataSourceName, Object selectedObject) {
        return null;
    }

    public DataSourceHandle createDataSource(Class classType, String dataSourceName, String dataSourceType) {
        if (classType == OdaDataSourceHandle.class) {
            OdaDataSourceHandle dsHandle = Utility.newOdaDataSource((String)dataSourceName, (String)dataSourceType);
            return dsHandle;
        }
        if (classType == ScriptDataSourceHandle.class) {
            ScriptDataSourceHandle dsHandle = Utility.newScriptDataSource((String)dataSourceName);
            if (dataSourceType.equals("Cassandra")) {
                UserPropertyDefn userProperty = new UserPropertyDefn();
                userProperty.setName("script_type");
                userProperty.setDefault((Object)"me.prettyprint.hector");
                try {
                    dsHandle.addUserPropertyDefn(userProperty);
                }
                catch (SemanticException semanticException) {}
            }
            return dsHandle;
        }
        return null;
    }
}

