/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.ISimpleComboDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.metadata.IPredefinedStyle;

public class SimpleComboPropertyDescriptorProvider
extends PropertyDescriptorProvider
implements ISimpleComboDescriptorProvider {
    boolean isEditable = false;

    public SimpleComboPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    @Override
    public String[] getItems() {
        String[] items = null;
        if ("dataSet".equals(this.getProperty())) {
            items = ChoiceSetFactory.getDataSets();
        } else if ("masterPage".equals(this.getProperty())) {
            items = ChoiceSetFactory.getMasterPages();
        } else if ("style".equals(this.getProperty())) {
            items = this.getModifiedStyles();
        } else if ("theme".equals(this.getProperty())) {
            items = ChoiceSetFactory.getThemes();
        }
        return items;
    }

    private String[] getAllStyles() {
        String[] items = ChoiceSetFactory.getStyles();
        List preStyles = DesignEngine.getMetaDataDictionary().getPredefinedStyles();
        ArrayList<String> preStyleNames = new ArrayList<String>();
        int i = 0;
        while (i < preStyles.size()) {
            preStyleNames.add(((IPredefinedStyle)preStyles.get(i)).getName());
            ++i;
        }
        ArrayList<String> sytleNames = new ArrayList<String>();
        int i2 = 0;
        while (i2 < items.length) {
            if (preStyleNames.indexOf(items[i2]) == -1) {
                sytleNames.add(items[i2]);
            }
            ++i2;
        }
        String[] styleNamesArray = sytleNames.toArray(new String[0]);
        return styleNamesArray;
    }

    private String[] getModifiedStyles() {
        String[] styleNamesArray;
        block14: {
            LibraryHandle libary;
            ThemeHandle theme;
            ArrayList cssList;
            ModuleHandle module;
            ArrayList<String> sytleNames;
            block15: {
                this.isEditable = false;
                styleNamesArray = this.getAllStyles();
                sytleNames = new ArrayList<String>();
                sytleNames.addAll(Arrays.asList(styleNamesArray));
                module = SessionHandleAdapter.getInstance().getReportDesignHandle();
                cssList = new ArrayList();
                if (!(module instanceof ReportDesignHandle)) break block15;
                ReportDesignHandle reportDesign = (ReportDesignHandle)module;
                cssList.addAll(reportDesign.getAllCssStyleSheets());
                int i = 0;
                while (i < cssList.size()) {
                    block16: {
                        CssStyleSheetHandle uriCss;
                        CssStyleSheetHandle css;
                        block13: {
                            css = (CssStyleSheetHandle)cssList.get(i);
                            IncludedCssStyleSheetHandle inCss = reportDesign.findIncludedCssStyleSheetHandleByProperties(css.getFileName(), css.getExternalCssURI(), css.isUseExternalCss());
                            if (css.isUseExternalCss() || css.getExternalCssURI() != null) {
                                this.isEditable = true;
                            }
                            if (inCss == null || inCss.getExternalCssURI() == null || inCss.getExternalCssURI().length() <= 0) break block16;
                            String fileName = inCss.getExternalCssURI();
                            uriCss = null;
                            try {
                                uriCss = SessionHandleAdapter.getInstance().getReportDesignHandle().openCssStyleSheet(fileName);
                                if (uriCss == null) {
                                }
                                break block13;
                            }
                            catch (StyleSheetException e) {
                                e.printStackTrace();
                            }
                            break block16;
                        }
                        Iterator iter = css.getStyleIterator();
                        while (iter.hasNext()) {
                            SharedStyleHandle styleHandle = (SharedStyleHandle)iter.next();
                            int index = sytleNames.indexOf(styleHandle.getName());
                            if (index < 0 || uriCss.findStyle(styleHandle.getName()) == null) continue;
                            styleNamesArray[index] = String.valueOf(styleHandle.getName()) + " " + Messages.getString((String)"CssStyleSheetNodeProvider.Tooltip.URI");
                        }
                    }
                    ++i;
                }
                ThemeHandle theme2 = reportDesign.getTheme();
                if (theme2 == null) break block14;
                cssList.addAll(theme2.getAllCssStyleSheets());
                int i2 = 0;
                while (i2 < cssList.size()) {
                    CssStyleSheetHandle css = (CssStyleSheetHandle)cssList.get(i2);
                    theme2.findIncludedCssStyleSheetHandleByProperties(css.getFileName(), css.getExternalCssURI(), css.isUseExternalCss());
                    if (css.isUseExternalCss() || css.getExternalCssURI() != null) {
                        this.isEditable = true;
                        break block14;
                    }
                    ++i2;
                }
                break block14;
            }
            if (module instanceof LibraryHandle && (theme = (libary = (LibraryHandle)module).getTheme()) != null) {
                cssList.addAll(theme.getAllCssStyleSheets());
                int i = 0;
                while (i < cssList.size()) {
                    CssStyleSheetHandle css = (CssStyleSheetHandle)cssList.get(i);
                    IncludedCssStyleSheetHandle inCss = theme.findIncludedCssStyleSheetHandleByProperties(css.getFileName(), css.getExternalCssURI(), css.isUseExternalCss());
                    if (css.isUseExternalCss() || css.getExternalCssURI() != null) {
                        this.isEditable = true;
                    }
                    if (inCss != null && inCss.getExternalCssURI() != null && inCss.getExternalCssURI().length() > 0) {
                        Iterator iter = css.getStyleIterator();
                        while (iter.hasNext()) {
                            SharedStyleHandle styleHandle = (SharedStyleHandle)iter.next();
                            int index = sytleNames.indexOf(styleHandle.getName());
                            String tooltipURI = Messages.getString((String)"CssStyleSheetNodeProvider.Tooltip.URI");
                            if (index < 0) continue;
                            styleNamesArray[index] = String.valueOf(styleHandle.getName()) + " " + tooltipURI;
                        }
                    }
                    ++i;
                }
            }
        }
        return styleNamesArray;
    }

    @Override
    public boolean isSpecialProperty() {
        return "style".equals(this.getProperty()) || "theme".equals(this.getProperty()) || "masterPage".equals(this.getProperty());
    }

    @Override
    public void save(Object value) throws SemanticException {
        if ("style".equals(this.getProperty())) {
            String[] styleNamesArray = this.getAllStyles();
            String[] modifiedArray = this.getModifiedStyles();
            int index = Arrays.asList(modifiedArray).indexOf(value);
            if (index >= 0) {
                value = styleNamesArray[index];
            } else if (!this.isEditable) {
                value = null;
            }
        }
        super.save(value);
    }

    @Override
    public Object load() {
        Object obj = super.load();
        if ("style".equals(this.getProperty())) {
            String[] styleNamesArray = this.getAllStyles();
            String[] modifiedArray = this.getModifiedStyles();
            int index = Arrays.asList(styleNamesArray).indexOf(obj);
            if (index >= 0) {
                obj = modifiedArray[index];
            }
        }
        return obj;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    @Override
    public boolean isReadOnly() {
        GroupPropertyHandle propertyHandle = null;
        if (this.input instanceof GroupElementHandle) {
            propertyHandle = ((GroupElementHandle)this.input).getPropertyHandle(this.property);
        } else if (this.input instanceof List) {
            propertyHandle = DEUtil.getGroupElementHandle((List)((List)this.input)).getPropertyHandle(this.property);
        }
        if (propertyHandle != null) {
            return propertyHandle.isReadOnly();
        }
        return false;
    }
}

