/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.parts;

import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.TableCellKeyDelegate;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractCellEditPart;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.events.KeyEvent;

public class ReportViewerKeyHandler
extends GraphicalViewerKeyHandler {
    private ActionRegistry actionRegistry;
    private TableCellKeyDelegate tableDelgate;
    public static final int NO_MASK = 0;

    public ReportViewerKeyHandler(GraphicalViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
        this.put(KeyStroke.getPressed((int)0x100000B, (int)0), actionRegistry.getAction((Object)"org.eclipse.gef.direct_edit"));
        this.tableDelgate = new TableCellKeyDelegate(viewer, actionRegistry);
    }

    public void put(char character, int keyCode, int stateMask, String actionID) {
        IAction action = this.actionRegistry.getAction((Object)actionID);
        if (action != null) {
            this.put(KeyStroke.getReleased((char)character, (int)keyCode, (int)stateMask), action);
        }
    }

    public boolean keyPressed(KeyEvent event) {
        GraphicalEditPart part = this.getFocusEditPart();
        switch (event.keyCode) {
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                if (!this.scrollIncrement(part, event)) break;
                return true;
            }
            case 0x1000005: 
            case 0x1000006: {
                if (!this.scrollPageIncrement(part, event.keyCode)) break;
                return true;
            }
        }
        if (part instanceof AbstractCellEditPart) {
            return this.tableCellKeyPressed(event);
        }
        return super.keyPressed(event);
    }

    private boolean scrollIncrement(GraphicalEditPart part, KeyEvent event) {
        if ((event.stateMask & 0x40000) == 0) {
            return false;
        }
        if (!(part.getViewer() instanceof DeferredGraphicalViewer)) {
            return false;
        }
        DeferredGraphicalViewer viewer = (DeferredGraphicalViewer)part.getViewer();
        FigureCanvas canvas = viewer.getFigureCanvas();
        int code = event.keyCode;
        int increment = 0;
        if (code == 0x1000004) {
            increment = canvas.getHorizontalBar().getSelection() + canvas.getHorizontalBar().getIncrement();
        } else if (code == 0x1000003) {
            increment = canvas.getHorizontalBar().getSelection() - canvas.getHorizontalBar().getIncrement();
        } else if (code == 0x1000002) {
            increment = canvas.getVerticalBar().getSelection() + canvas.getVerticalBar().getIncrement();
        } else if (code == 0x1000001) {
            increment = canvas.getVerticalBar().getSelection() - canvas.getVerticalBar().getIncrement();
        }
        if (code == 0x1000004 || code == 0x1000003) {
            canvas.scrollToX(increment);
        }
        if (code == 0x1000001 || code == 0x1000002) {
            canvas.scrollToY(increment);
        }
        return true;
    }

    private boolean scrollPageIncrement(GraphicalEditPart part, int code) {
        if (!(part.getViewer() instanceof DeferredGraphicalViewer)) {
            return false;
        }
        DeferredGraphicalViewer viewer = (DeferredGraphicalViewer)part.getViewer();
        FigureCanvas canvas = viewer.getFigureCanvas();
        int increment = 0;
        if (code == 0x1000006) {
            increment = canvas.getVerticalBar().getSelection() + canvas.getVerticalBar().getPageIncrement();
        } else if (code == 0x1000005) {
            increment = canvas.getVerticalBar().getSelection() - canvas.getVerticalBar().getPageIncrement();
        }
        canvas.scrollToY(increment);
        return true;
    }

    protected boolean tableCellKeyPressed(KeyEvent event) {
        return this.tableDelgate.keyPressed(event);
    }
}

