/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.preferences;

import java.io.File;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.ConfigurationManager;
import org.eclipse.buildship.core.internal.i18n.CoreMessages;
import org.eclipse.buildship.core.internal.util.binding.Validator;
import org.eclipse.buildship.core.internal.util.binding.Validators;
import org.eclipse.buildship.ui.internal.preferences.GradleDistributionValidatingListener;
import org.eclipse.buildship.ui.internal.preferences.GradleUserHomeValidatingListener;
import org.eclipse.buildship.ui.internal.util.gradle.GradleDistributionViewModel;
import org.eclipse.buildship.ui.internal.util.widget.GradleProjectSettingsComposite;
import org.eclipse.buildship.ui.internal.util.widget.GradleUserHomeGroup;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;

public final class GradleProjectPreferencePage
extends PropertyPage {
    public static final String PAGE_ID = "org.eclipse.buildship.ui.projectproperties";
    private GradleProjectSettingsComposite gradleProjectSettingsComposite;
    private final Validator<GradleDistributionViewModel> distributionValidator;
    private final Validator<File> gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)CoreMessages.Preference_Label_GradleUserHome);

    public GradleProjectPreferencePage() {
        this.distributionValidator = GradleDistributionViewModel.validator();
    }

    protected Control createContents(Composite parent) {
        this.gradleProjectSettingsComposite = GradleProjectSettingsComposite.builder(parent).withAutoSyncCheckbox().withOverrideCheckbox("Override workspace settings", "Configure Workspace Settings").build();
        this.initValues();
        this.addListeners();
        return this.gradleProjectSettingsComposite;
    }

    private void initValues() {
        IProject project = this.getTargetProject();
        BuildConfiguration buildConfig = CorePlugin.configurationManager().loadProjectConfiguration(project).getBuildConfiguration();
        boolean overrideWorkspaceSettings = buildConfig.isOverrideWorkspaceSettings();
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().setDistribution(GradleDistributionViewModel.from(buildConfig.getGradleDistribution()));
        this.gradleProjectSettingsComposite.getGradleUserHomeGroup().setGradleUserHome(buildConfig.getGradleUserHome());
        this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().setSelection(overrideWorkspaceSettings);
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().setSelection(buildConfig.isBuildScansEnabled());
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().setSelection(buildConfig.isOfflineMode());
        this.gradleProjectSettingsComposite.getAutoSyncCheckbox().setSelection(buildConfig.isAutoSync());
        this.gradleProjectSettingsComposite.updateEnablement();
    }

    private void addListeners() {
        this.gradleProjectSettingsComposite.getParentPreferenceLink().addSelectionListener((SelectionListener)new WorkbenchPreferenceOpeningSelectionListener());
        GradleUserHomeGroup gradleUserHomeGroup = this.gradleProjectSettingsComposite.getGradleUserHomeGroup();
        gradleUserHomeGroup.getGradleUserHomeText().addModifyListener((ModifyListener)new GradleUserHomeValidatingListener((PreferencePage)this, gradleUserHomeGroup, this.gradleUserHomeValidator));
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().addDistributionChangedListener(new GradleDistributionValidatingListener((PreferencePage)this, this.distributionValidator));
    }

    public boolean performOk() {
        IProject project = this.getTargetProject();
        ConfigurationManager manager = CorePlugin.configurationManager();
        BuildConfiguration currentConfig = manager.loadProjectConfiguration(project).getBuildConfiguration();
        BuildConfiguration updatedConfig = manager.createBuildConfiguration(currentConfig.getRootProjectDirectory(), this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().getSelection(), this.gradleProjectSettingsComposite.getGradleDistributionGroup().getDistribution().toGradleDistribution(), this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHome(), this.gradleProjectSettingsComposite.getBuildScansCheckbox().getSelection(), this.gradleProjectSettingsComposite.getOfflineModeCheckbox().getSelection(), this.gradleProjectSettingsComposite.getAutoSyncCheckbox().getSelection());
        manager.saveBuildConfiguration(updatedConfig);
        return true;
    }

    private IProject getTargetProject() {
        return (IProject)Platform.getAdapterManager().getAdapter((Object)this.getElement(), IProject.class);
    }

    private class WorkbenchPreferenceOpeningSelectionListener
    implements SelectionListener {
        private WorkbenchPreferenceOpeningSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        private void openWorkspacePreferences() {
            PreferencesUtil.createPreferenceDialogOn((Shell)GradleProjectPreferencePage.this.getShell(), (String)"org.eclipse.buildship.ui.preferences", null, null).open();
        }
    }
}

